/*
 * Decompiled with CFR 0.152.
 */
package com.nubosolutions.pkcs11helper;

import com.nubosolutions.pkcs11helper.CertificateObject;
import com.nubosolutions.pkcs11helper.DataObject;
import com.nubosolutions.pkcs11helper.FileVersionInfo;
import com.nubosolutions.pkcs11helper.PasswordDialogRunnable;
import com.nubosolutions.pkcs11helper.PrivateKeyObject;
import com.nubosolutions.pkcs11helper.PublicKeyObject;
import com.nubosolutions.pkcs11helper.Utilities;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.bouncycastle.asn1.DEROctetString;
import org.ietf.jgss.Oid;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class PKCS11Helper {
    private static org.apache.logging.log4j.Logger a = LogManager.getLogger((String)PKCS11Helper.class.getName());
    private KeyStore.PasswordProtection b;
    private static String c;
    private ArrayList<X509Certificate> d = new ArrayList();
    public ArrayList<Long> hObjects = new ArrayList();
    public ArrayList<String> lectores = new ArrayList();
    public ArrayList<CK_TOKEN_INFO> tarjetas = new ArrayList();
    public PKCS11 p11 = null;
    public static CK_INFO info;
    public static CK_TOKEN_INFO ckti;
    public static final long CKR_OK = 0L;
    public static final long CKR_USER_ALREADY_LOGGED_IN = 256L;
    public static final long CKR_DEVICE_ERROR = 48L;

    public PKCS11Helper(String string) {
        c = string;
        System.out.println("PKCS11Helper: pk11LibPath:" + c);
        a.info("PKCS11Helper: pk11LibPath:" + c);
    }

    public static PKCS11Helper initHelper(byte by) {
        Object object;
        a.debug("INICIO initHelper");
        PKCS11Helper pKCS11Helper = null;
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        String string3 = "";
        try {
            string3 = PKCS11Helper.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        if (string3.endsWith("jar")) {
            string3 = new File(string3).getParent();
        }
        if (string3.endsWith("lib") || string3.endsWith("lib/") || string3.endsWith("lib\\")) {
            string3 = new File(string3).getParent();
        }
        string3 = string3 + "/";
        a.info("initHelper: jarPath:" + string3);
        System.out.println("initHelper: jarPath:" + string3);
        if (by != 0) {
            if (by == 1 || by == 2 || by == 5) {
                if (string2.contains("64")) {
                    if (new File("FNMT_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("FNMT_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/FNMT_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11_x64.dll");
                        } else if (new File("C:/Windows/System32/FNMT_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11.dll");
                        }
                    }
                } else {
                    if (new File("FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("FNMT_P11.dll");
                    }
                    if (pKCS11Helper == null && new File("C:/Windows/SysWOW64/FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/FNMT_P11.dll");
                    }
                }
            } else if (by == 4) {
                if (string2.contains("64")) {
                    if (new File("DNIe_P11_priv_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11_priv_x64.dll");
                    } else if (new File("DNIe_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/DNIe_P11_priv_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/DNIe_P11_priv_x64.dll");
                        } else if (new File("C:/Windows/System32/DNIe_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/DNIe_P11_x64.dll");
                        }
                    }
                } else {
                    if (new File("DNIe_P11_priv.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11_priv.dll");
                    } else if (new File("DNIe_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/SysWOW64/DNIe_P11_priv.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/DNIe_P11_priv.dll");
                        } else if (new File("C:/Windows/SysWOW64/DNIe_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/DNIe_P11.dll");
                        }
                    }
                }
            } else if (by == 3) {
                if (string2.contains("64")) {
                    if (new File("TIF_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("TIF_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/TIF_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/TIF_P11_x64.dll");
                        } else if (new File("C:/Windows/System32/TIF_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/TIF_P11.dll");
                        }
                    }
                } else {
                    if (new File("TIF_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("TIF_P11.dll");
                    }
                    if (pKCS11Helper == null && new File("C:/Windows/SysWOW64/TIF_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/TIF_P11.dll");
                    }
                }
            }
        } else if (string.contains("windows")) {
            Utilities.isWindows = true;
            if (System.getenv("ProgramFiles(x86)") != null) {
                if (string2.contains("64")) {
                    if (new File(string3 + "FNMT_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper(string3 + "FNMT_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/FNMT_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11_x64.dll");
                        } else if (new File("C:/Windows/System32/FNMT_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11.dll");
                        }
                    }
                    if (pKCS11Helper == null) {
                        pKCS11Helper = new PKCS11Helper("FNMT_P11_x64.dll");
                    }
                } else {
                    if (new File(string3 + "FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper(string3 + "FNMT_P11.dll");
                    }
                    if (pKCS11Helper == null && new File("C:/Windows/SysWOW64/FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/FNMT_P11.dll");
                    }
                }
            } else {
                if (new File(string3 + "FNMT_P11.dll").exists()) {
                    pKCS11Helper = new PKCS11Helper(string3 + "FNMT_P11_x64.dll");
                }
                if (pKCS11Helper == null && new File("C:/Windows/System32/FNMT_P11.dll").exists()) {
                    pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11.dll");
                }
            }
            if (pKCS11Helper == null) {
                pKCS11Helper = new PKCS11Helper("FNMT_P11.dll");
            }
        } else if (string.contains("linux")) {
            System.out.println("sistemaOperativo: " + string);
            Utilities.isLinux = true;
            object = Utilities.getLinuxDistribution().toLowerCase();
            System.out.println("getLinuxDistribution: " + (String)object);
            if (((String)object).contains("ubuntu") || ((String)object).contains("debian")) {
                if (new File("/usr/lib/libpkcs11-fnmtdnie.so").isFile()) {
                    pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmtdnie.so");
                }
                if (pKCS11Helper == null && new File("/usr/lib/libpkcs11-fnmt.so").isFile()) {
                    pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmt.so");
                }
            } else if (((String)object).contains("fedora") || ((String)object).contains("opensuse") || ((String)object).contains("redhat")) {
                if (string2.contains("64")) {
                    if (new File("/usr/lib64/libpkcs11-fnmtdnie.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib64/libpkcs11-fnmtdnie.so");
                    }
                    if (pKCS11Helper == null && new File("/usr/lib64/libpkcs11-fnmt.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib64/libpkcs11-fnmt.so");
                    }
                } else {
                    if (new File("/usr/lib/libpkcs11-fnmtdnie.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmtdnie.so");
                    }
                    if (pKCS11Helper == null && new File("/usr/lib/libpkcs11-fnmt.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmt.so");
                    }
                }
            }
        } else if (string.contains("mac")) {
            Utilities.isMac = true;
            if (new File("/Library/Libpkcs11-fnmtdnie/lib/libpkcs11-fnmtdnie.so").isFile()) {
                pKCS11Helper = new PKCS11Helper("/Library/Libpkcs11-fnmtdnie/lib/libpkcs11-fnmtdnie.so");
            } else if (new File("/Library/Libpkcs11-fnmt/lib/libpkcs11-fnmt.so").isFile()) {
                pKCS11Helper = new PKCS11Helper("/Library/Libpkcs11-fnmt/lib/libpkcs11-fnmt.so");
            }
        }
        if (pKCS11Helper != null) {
            a.debug("Cargada librer\u00eda " + c);
        } else {
            a.debug("No se ha cargado librer\u00eda");
        }
        a.debug("FIN initHelper");
        return pKCS11Helper;
    }

    private X509Certificate a(long l2, long l3) {
        Object object;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        block3: {
            a.debug("INICIO loadCert");
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            try {
                a.debug("C_GetAttributeValue CKA_VALUE");
                this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = pKCS11Exception;
                int n2 = (int)pKCS11Exception.getErrorCode();
                if (n2 != -2146408056 && n2 != -2146407802) break block3;
                this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
            }
        }
        byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
        object = byArray;
        if (byArray == null) {
            a.debug("unexpectedly retrieved null byte array");
            throw new CertificateException("unexpectedly retrieved null byte array");
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        a.debug("generateCertificate");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
        a.debug("FIN loadCert");
        return x509Certificate;
    }

    public byte[] getID(long l2, long l3) {
        a.debug("INICIO getID");
        byte[] byArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 258L;
        try {
            a.debug("C_GetAttributeValue CKA_ID");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            byArray = cK_ATTRIBUTEArray[0].getByteArray();
        }
        a.debug("FIN getID");
        return byArray;
    }

    public char[] getLabel(long l2, long l3) {
        a.debug("INICIO getLabel");
        char[] cArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 3L;
        try {
            a.debug("C_GetAttributeValue CKA_LABEL");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            cArray = cK_ATTRIBUTEArray[0].getCharArray();
        }
        a.debug("FIN getLabel");
        return cArray;
    }

    public char[] getSubject(long l2, long l3) {
        a.debug("INICIO getSubject");
        char[] cArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 257L;
        try {
            a.debug("C_GetAttributeValue CKA_SUBJECT");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            cArray = cK_ATTRIBUTEArray[0].getCharArray();
        }
        a.debug("FIN getSubject");
        return cArray;
    }

    public byte[] getIssuer(long l2, long l3) {
        a.debug("INICIO getIssuer");
        byte[] byArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 129L;
        try {
            a.debug("C_GetAttributeValue CKA_ISSUER");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            byArray = cK_ATTRIBUTEArray[0].getByteArray();
        }
        a.debug("FIN getIssuer");
        return byArray;
    }

    private X509Certificate[] a() {
        a.debug("INICIO getCertificates");
        X509Certificate[] x509CertificateArray = new X509Certificate[]{};
        x509CertificateArray = this.d.toArray(x509CertificateArray);
        a.debug("FIN getCertificates");
        return x509CertificateArray;
    }

    public int getP11Instance() {
        a.debug("INICIO getP11Instance");
        int n2 = 0;
        Object object = new File(c);
        try {
            c = ((File)object).getCanonicalPath();
            a.debug("getCanonicalPath: " + c);
            if (Utilities.isWindows) {
                a.debug("Version PKCS11: " + FileVersionInfo.FileVersion(c));
            }
        }
        catch (IOException iOException) {
            a.error("Exception:", (Throwable)iOException);
            return 1;
        }
        object = System.getProperty("java.version");
        a.debug("Java version: " + (String)object);
        if (((String)object).startsWith("1.8.") || ((String)object).startsWith("11.") || ((String)object).startsWith("12.") || ((String)object).startsWith("13.") || ((String)object).startsWith("14.") || ((String)object).startsWith("15.")) {
            try {
                a.debug("getInstance");
                this.p11 = PKCS11.getInstance(c, "C_GetFunctionList", null, false);
                a.debug("C_GetInfo");
                info = this.p11.C_GetInfo();
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = pKCS11Exception;
                String string = pKCS11Exception.getMessage();
                a.error("Exception:", (Throwable)object);
                if (string.contains("incompatible architecture")) {
                    return 4;
                }
                return 2;
            }
            catch (IllegalArgumentException | SecurityException runtimeException) {
                a.error("Exception:", (Throwable)runtimeException);
            }
            catch (IOException iOException) {
                a.error("Exception:", (Throwable)iOException);
            }
        } else {
            n2 = 3;
        }
        a.debug("FIN getP11Instance");
        return n2;
    }

    public ArrayList<String> getReaders() {
        a.debug("INICIO openSession");
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            a.debug("C_GetSlotList");
            long[] lArray = this.p11.C_GetSlotList(false);
            if (lArray == null) {
                return null;
            }
            for (long l2 : lArray) {
                arrayList.add(new String(this.p11.C_GetSlotInfo((long)l2).slotDescription));
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        return arrayList;
    }

    public ArrayList<Long> openSession(long l2, byte by) {
        long[] lArray;
        a.debug("INICIO openSession");
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            a.debug("C_GetSlotList");
            lArray = this.p11.C_GetSlotList(true);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (lArray == null) {
            return null;
        }
        for (long l3 : lArray) {
            try {
                a.debug("C_GetMechanismList");
                this.p11.C_GetMechanismList(l3);
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.error("Exception:", (Throwable)pKCS11Exception);
                return null;
            }
            try {
                block12: {
                    a.debug("C_GetTokenInfo");
                    try {
                        ckti = this.p11.C_GetTokenInfo(l3);
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        a.error("Exception:", (Throwable)pKCS11Exception);
                        ckti = this.p11.C_GetTokenInfo(l3);
                    }
                    Object object = new String(PKCS11Helper.ckti.manufacturerID).substring(0, 8);
                    a.debug("Manufacturer: " + (String)object);
                    if (!((String)object).equalsIgnoreCase("FNMT-RCM") && !((String)object).toUpperCase().contains("TC-FNMT") && (by != 1 || !((String)object).equalsIgnoreCase("CNP-FNMT")) && (by != 1 || !((String)object).equalsIgnoreCase("DGP-FNMT"))) continue;
                    try {
                        a.debug("C_OpenSession");
                        arrayList.add(this.p11.C_OpenSession(l3, l2, null, null));
                    }
                    catch (PKCS11Exception pKCS11Exception) {
                        object = pKCS11Exception;
                        if (pKCS11Exception.getErrorCode() != 352L) break block12;
                        a.debug("RE C_OpenSession");
                        arrayList.add(this.p11.C_OpenSession(l3, l2, null, null));
                    }
                }
                a.debug("C_GetSlotInfo");
                this.lectores.add(new String(this.p11.C_GetSlotInfo((long)l3).slotDescription));
                this.tarjetas.add(ckti);
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.error("Exception:", (Throwable)pKCS11Exception);
                return null;
            }
        }
        a.debug("FIN openSession");
        return arrayList;
    }

    public boolean generateKeyPari(long l2) {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(260L, true), new CK_ATTRIBUTE(266L, true), new CK_ATTRIBUTE(267L, true), new CK_ATTRIBUTE(262L, true), new CK_ATTRIBUTE(289L, 2048L), new CK_ATTRIBUTE(290L, RSAKeyGenParameterSpec.F4)};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(259L, true), new CK_ATTRIBUTE(261L, true), new CK_ATTRIBUTE(264L, true), new CK_ATTRIBUTE(265L, true), new CK_ATTRIBUTE(263L, true), new CK_ATTRIBUTE(354L, true)};
        try {
            this.p11.C_GenerateKeyPair(l2, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }
        catch (PKCS11Exception pKCS11Exception) {
            return false;
        }
        return true;
    }

    public void closeSession(ArrayList<Long> object) {
        a.debug("INICIO closeSession");
        this.lectores = new ArrayList();
        try {
            if (object != null) {
                object = ((ArrayList)object).iterator();
                while (object.hasNext()) {
                    long l2 = (Long)object.next();
                    this.p11.C_CloseSession(l2);
                }
            }
            a.debug("FIN closeSession");
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return;
        }
    }

    public void logout(long l2) {
        try {
            this.p11.C_Logout(l2);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            return;
        }
    }

    public int login(int n2, Frame frame, long l2) {
        int n3 = 0;
        a.debug("INICIO login");
        if (this.b == null) {
            PasswordDialogRunnable passwordDialogRunnable = new PasswordDialogRunnable(frame, n2, false);
            passwordDialogRunnable.run();
            this.b = passwordDialogRunnable.getPasswordProtection();
        }
        try {
            if (this.b != null) {
                a.debug("C_Login");
                this.p11.C_Login(l2, 1L, this.b.getPassword());
            } else {
                n3 = 1;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.b = null;
            a.error("Exception:", (Throwable)pKCS11Exception);
            if (pKCS11Exception.getErrorCode() != 256L) {
                pKCS11Exception.getErrorCode();
            }
            n3 = 2;
        }
        a.debug("FIN login");
        return n3;
    }

    public ArrayList<CertificateObject> getCertificateObject(long l2) {
        a.debug("INICIO getCertificateObject");
        ArrayList<CertificateObject> arrayList = new ArrayList<CertificateObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 1L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                CertificateObject certificateObject = new CertificateObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                try {
                    a.debug("C_GetAttributeValue CKA_VALUE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.value = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    a.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    a.debug("C_GetAttributeValue CKA_ID");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.id = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(130L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SERIAL_NUMBER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.serialNumber = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(257L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SUBJECT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.subject = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(129L)};
                try {
                    a.debug("C_GetAttributeValue CKA_ISSUER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.issuer = cK_ATTRIBUTEArray[0].getByteArray();
                }
                arrayList.add(certificateObject);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
        }
        a.debug("FIN getCertificateObject");
        return arrayList;
    }

    public ArrayList<String> getTypePublicKeys(long l2) {
        a.debug("INICIO loadPublicKeys");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList arrayList3 = new ArrayList();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        Object[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 2L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            int n2;
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, (CK_ATTRIBUTE[])objectArray);
            a.debug("C_FindObjects");
            objectArray = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            Object[] objectArray2 = objectArray;
            int n3 = objectArray.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                CK_ATTRIBUTE cK_ATTRIBUTE2 = objectArray2[i2];
                CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cfr_ignored_0 = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE3.type = 0L;
                cK_ATTRIBUTE3.pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, (long)cK_ATTRIBUTE2);
                if (cK_ATTRIBUTE.pValue == null) continue;
                arrayList.add(cK_ATTRIBUTE.pValue);
                arrayList2.add((long)cK_ATTRIBUTE2);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                CK_ATTRIBUTE cK_ATTRIBUTE4 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE4.type = 0L;
                cK_ATTRIBUTE4.pValue = 1L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = arrayList.get(n2);
                cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE4;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                a.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                a.debug("C_FindObjects");
                long[] lArray = this.p11.C_FindObjects(l2, 1000L);
                a.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
                if (lArray == null || lArray.length == 0) continue;
                a.debug("add object");
                arrayList3.add(arrayList2.get(n2));
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
                try {
                    a.debug("C_GetAttributeValue CKA_KEY_TYPE");
                    this.p11.C_GetAttributeValue(l2, (Long)arrayList3.get(n2), cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue == null) continue;
                if (cK_ATTRIBUTEArray[0].getLong() == 0L) {
                    arrayList4.add("CKK_RSA");
                    continue;
                }
                if (cK_ATTRIBUTEArray[0].getLong() != 3L) continue;
                arrayList4.add("CKK_ECDSA");
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        a.debug("FIN loadPublicKeys: " + 0);
        return arrayList4;
    }

    public ArrayList<PublicKeyObject> getPublicKeyObject(long l2) {
        a.debug("INICIO getPublicKeyObject");
        ArrayList<PublicKeyObject> arrayList = new ArrayList<PublicKeyObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 2L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                PublicKeyObject publicKeyObject = new PublicKeyObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
                try {
                    a.debug("C_GetAttributeValue CKA_KEY_TYPE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                int n2 = 0;
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    if (cK_ATTRIBUTEArray[0].getLong() == 0L) {
                        publicKeyObject.key = "CKK_RSA";
                    } else if (cK_ATTRIBUTEArray[0].getLong() == 3L) {
                        publicKeyObject.key = "CKK_ECDSA";
                        n2 = 3;
                    }
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    a.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    a.debug("C_GetAttributeValue CKA_ID");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.id = cK_ATTRIBUTEArray[0].getByteArray();
                }
                if (n2 == 0) {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(289L)};
                    try {
                        a.debug("C_GetAttributeValue CKA_MODULUS_BITS");
                        this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                    }
                    catch (Exception exception) {
                        a.error("Exception:", (Throwable)exception);
                    }
                    if (cK_ATTRIBUTEArray[0].pValue != null) {
                        publicKeyObject.modulus_bits = cK_ATTRIBUTEArray[0].getLong();
                    }
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
                    try {
                        a.debug("C_GetAttributeValue CKA_MODULUS");
                        this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                    }
                    catch (Exception exception) {
                        a.error("Exception:", (Throwable)exception);
                    }
                    if (cK_ATTRIBUTEArray[0].pValue != null) {
                        publicKeyObject.modulus = cK_ATTRIBUTEArray[0].getByteArray();
                    }
                } else {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
                    try {
                        a.debug("C_GetAttributeValue CKA_EC_POINT");
                        this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                    }
                    catch (Exception exception) {
                        a.error("Exception:", (Throwable)exception);
                    }
                    if (cK_ATTRIBUTEArray[0].pValue != null) {
                        publicKeyObject.ecPoint = cK_ATTRIBUTEArray[0].getByteArray();
                    }
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(257L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SUBJECT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.subject = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(260L)};
                try {
                    a.debug("C_GetAttributeValue CKA_ENCRYPT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.encrypt = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(266L)};
                try {
                    a.debug("C_GetAttributeValue CKA_VERIFY");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.verify = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(267L)};
                try {
                    a.debug("C_GetAttributeValue CKA_VERIFY_RECOVER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.verify_recover = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(262L)};
                try {
                    a.debug("C_GetAttributeValue CKA_WRAP");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.wrap = cK_ATTRIBUTEArray[0].getBoolean();
                }
                arrayList.add(publicKeyObject);
            }
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
        }
        a.debug("FIN getPublicKeyObject");
        return arrayList;
    }

    public long getPrivateKeyObjectByModulus(long l2) {
        a.debug("INICIO getPrivateKeyObject");
        new PrivateKeyObject();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        Object object = new CK_ATTRIBUTE();
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE();
        new CK_ATTRIBUTE();
        ((CK_ATTRIBUTE)object).type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 3L;
        byte[] byArray = Utilities.decodeHexString("C15904B5323564CF3A3A10DFD02D3368A57A81BA814B057613DA823EC9CF9A9028F742FC12F130D14FD2FA49FC812F4CEA4B6A07628605AC8676B6758354C397CAFEFF97935B512BD61DD083A52D3BB6DB26854B2E1F8FEF94E2B20CF9E77F580886BC5C24C7FA578FC7BF04FD27B4724301C5A1A455F165BC8AB161CD6CAF59CE438878ED38F76D5743F48B453B6C96138F5D0BEB23FB1E2A8717BABA8701151E9A028A3892236B0889BAB78BFCAC9BABEE07640926F813DBBBD7526A9140C4DF973C0BA04DF07F431EC9BA3942AC7427C200FEA54D80FD5DDBB0B0F42F679828C43F16B8F63E27EBFCA9C60402F1811D8D29089D64FB4EB9F60BB2A2598587");
        cK_ATTRIBUTE.type = 288L;
        cK_ATTRIBUTE.pValue = byArray;
        cK_ATTRIBUTEArray[0] = object;
        cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
        object = null;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
        }
        a.debug("FIN getPrivateKeyObject");
        return (long)object[0];
    }

    public long getPublicKeyObjectByModulus(long l2) {
        a.debug("INICIO getPrivateKeyObject");
        new PrivateKeyObject();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        Object object = new CK_ATTRIBUTE();
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE();
        new CK_ATTRIBUTE();
        ((CK_ATTRIBUTE)object).type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 2L;
        byte[] byArray = Utilities.decodeHexString("C15904B5323564CF3A3A10DFD02D3368A57A81BA814B057613DA823EC9CF9A9028F742FC12F130D14FD2FA49FC812F4CEA4B6A07628605AC8676B6758354C397CAFEFF97935B512BD61DD083A52D3BB6DB26854B2E1F8FEF94E2B20CF9E77F580886BC5C24C7FA578FC7BF04FD27B4724301C5A1A455F165BC8AB161CD6CAF59CE438878ED38F76D5743F48B453B6C96138F5D0BEB23FB1E2A8717BABA8701151E9A028A3892236B0889BAB78BFCAC9BABEE07640926F813DBBBD7526A9140C4DF973C0BA04DF07F431EC9BA3942AC7427C200FEA54D80FD5DDBB0B0F42F679828C43F16B8F63E27EBFCA9C60402F1811D8D29089D64FB4EB9F60BB2A2598587");
        cK_ATTRIBUTE.type = 288L;
        cK_ATTRIBUTE.pValue = byArray;
        cK_ATTRIBUTEArray[0] = object;
        cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
        object = null;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
        }
        a.debug("FIN getPrivateKeyObject");
        return (long)object[0];
    }

    public ArrayList<PrivateKeyObject> getPrivateKeyObject(long l2) {
        a.debug("INICIO getPrivateKeyObject");
        ArrayList<PrivateKeyObject> arrayList = new ArrayList<PrivateKeyObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 3L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                PrivateKeyObject privateKeyObject = new PrivateKeyObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
                try {
                    a.debug("C_GetAttributeValue CKA_KEY_TYPE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                int n2 = 0;
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    if (cK_ATTRIBUTEArray[0].getLong() == 0L) {
                        privateKeyObject.key = "CKK_RSA";
                    } else if (cK_ATTRIBUTEArray[0].getLong() == 3L) {
                        privateKeyObject.key = "CKK_ECDSA";
                        n2 = 3;
                    }
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    a.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    a.debug("C_GetAttributeValue CKA_ID");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.id = cK_ATTRIBUTEArray[0].getByteArray();
                }
                if (n2 == 0) {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
                    try {
                        a.debug("C_GetAttributeValue CKA_MODULUS");
                        this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                    }
                    catch (Exception exception) {
                        a.error("Exception:", (Throwable)exception);
                    }
                    if (cK_ATTRIBUTEArray[0].pValue != null) {
                        privateKeyObject.modulus = cK_ATTRIBUTEArray[0].getByteArray();
                    }
                } else {
                    cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
                    try {
                        a.debug("C_GetAttributeValue CKA_EC_POINT");
                        this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                    }
                    catch (Exception exception) {
                        a.error("Exception:", (Throwable)exception);
                    }
                    if (cK_ATTRIBUTEArray[0].pValue != null) {
                        privateKeyObject.ecPoint = cK_ATTRIBUTEArray[0].getByteArray();
                    }
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(257L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SUBJECT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.subject = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(259L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SENSITIVE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.sensitive = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(261L)};
                try {
                    a.debug("C_GetAttributeValue CKA_DECRYPT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.decrypt = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(264L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SIGN");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.sign = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(265L)};
                try {
                    a.debug("C_GetAttributeValue CKA_SIGN_RECOVER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.sign_recover = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(263L)};
                try {
                    a.debug("C_GetAttributeValue CKA_UNWRAP");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.unwrap = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(354L)};
                try {
                    a.debug("C_GetAttributeValue CKA_EXTRACTABLE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.extractable = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(357L)};
                try {
                    a.debug("C_GetAttributeValue CKA_ALWAYS_SENSITIVE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.always_sensitive = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(356L)};
                try {
                    a.debug("C_GetAttributeValue CKA_NEVER_EXTRACTABLE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.never_extractable = cK_ATTRIBUTEArray[0].getBoolean();
                }
                arrayList.add(privateKeyObject);
            }
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
        }
        a.debug("FIN getPrivateKeyObject");
        return arrayList;
    }

    public ArrayList<DataObject> getDataObject(long l2) {
        a.debug("INICIO getDataObject");
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 0L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                DataObject dataObject = new DataObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    a.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    dataObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(16L)};
                try {
                    a.debug("C_GetAttributeValue CKA_APPLICATION");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    dataObject.application = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                try {
                    a.debug("C_GetAttributeValue CKA_VALUE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    a.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    dataObject.value = cK_ATTRIBUTEArray[0].getByteArray();
                }
                arrayList.add(dataObject);
            }
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
        }
        a.debug("FIN getDataObject");
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public int loadPublicKeys(long l2) {
        a.debug("INICIO loadPublicKeys");
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 2L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            void var7_10;
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            a.debug("C_FindObjects");
            long[] i2 = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] iterator = i2;
            int n3 = i2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                long l3 = iterator[i3];
                CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cfr_ignored_0 = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE2.type = 0L;
                cK_ATTRIBUTE2.pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue != null) {
                    arrayList.add(cK_ATTRIBUTE.pValue);
                    arrayList2.add(l3);
                    continue;
                }
                arrayList3.add(l3);
            }
            boolean pKCS11Exception = false;
            while (var7_10 < arrayList.size()) {
                CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE3.type = 0L;
                cK_ATTRIBUTE3.pValue = 1L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = arrayList.get((int)var7_10);
                cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE3;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                a.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                a.debug("C_FindObjects");
                long[] lArray = this.p11.C_FindObjects(l2, 1000L);
                a.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
                if (lArray == null || lArray.length == 0) {
                    a.debug("C_DestroyObject");
                    this.p11.C_DestroyObject(l2, (Long)arrayList2.get((int)var7_10));
                    ++n2;
                }
                ++var7_10;
            }
            Iterator iterator2 = arrayList3.iterator();
            while (iterator2.hasNext()) {
                long l4 = (Long)iterator2.next();
                a.debug("C_DestroyObject publicKeysNoCKA");
                this.p11.C_DestroyObject(l2, l4);
                ++n2;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return -1;
        }
        a.debug("FIN loadPublicKeys: " + n2);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public int loadPrivateKeys(long l2) {
        a.debug("INICIO loadPrivateKeys");
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 3L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            void var7_10;
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            a.debug("C_FindObjects");
            long[] i2 = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] iterator = i2;
            int n3 = i2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                long l3 = iterator[i3];
                Object object = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                ((CK_ATTRIBUTE)object).type = 0L;
                ((CK_ATTRIBUTE)object).pValue = 3L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue != null) {
                    cK_ATTRIBUTEArray[0] = object;
                    cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                    a.debug("C_FindObjectsInit");
                    this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                    a.debug("C_FindObjects");
                    object = this.p11.C_FindObjects(l2, 1000L);
                    a.debug("C_FindObjectsFinal");
                    this.p11.C_FindObjectsFinal(l2);
                    if (((Object)object).length == 1) {
                        arrayList.add(cK_ATTRIBUTE.pValue);
                        arrayList2.add(l3);
                        continue;
                    }
                    arrayList3.add(l3);
                    continue;
                }
                arrayList3.add(l3);
            }
            boolean pKCS11Exception = false;
            while (var7_10 < arrayList.size()) {
                CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE2.type = 0L;
                cK_ATTRIBUTE2.pValue = 1L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = arrayList.get((int)var7_10);
                cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE2;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                a.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                a.debug("C_FindObjects");
                long[] lArray = this.p11.C_FindObjects(l2, 1000L);
                a.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
                if (lArray == null || lArray.length == 0) {
                    a.debug("C_DestroyObject");
                    this.p11.C_DestroyObject(l2, (Long)arrayList2.get((int)var7_10));
                    ++n2;
                }
                ++var7_10;
            }
            Iterator iterator2 = arrayList3.iterator();
            while (iterator2.hasNext()) {
                long l4 = (Long)iterator2.next();
                a.debug("C_DestroyObject privateKeysNoCKA");
                this.p11.C_DestroyObject(l2, l4);
                ++n2;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            return -1;
        }
        a.debug("FIN loadPrivateKeys: " + n2);
        return n2;
    }

    public void deleteAllObjects(long l2) {
        a.debug("INICIO deleteAllObjects");
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            long[] lArray = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                a.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
            cK_ATTRIBUTE.pValue = 3L;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            lArray = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                a.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
            cK_ATTRIBUTE.pValue = 2L;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            lArray = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                a.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
            cK_ATTRIBUTE.pValue = 0L;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            lArray = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                a.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
        }
        a.debug("FIN deleteAllObjects");
    }

    public X509Certificate[] getCertificates(long l2, boolean bl) {
        a.debug("INICIO getCertificates");
        this.d = new ArrayList();
        this.hObjects = new ArrayList();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            a.debug("C_FindObjects");
            long[] exception = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] lArray = exception;
            int n2 = exception.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = lArray[i2];
                Object object = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                ((CK_ATTRIBUTE)object).type = 0L;
                ((CK_ATTRIBUTE)object).pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue == null) continue;
                cK_ATTRIBUTEArray[0] = object;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                a.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                a.debug("C_FindObjects");
                long[] lArray2 = this.p11.C_FindObjects(l2, 1000L);
                object = lArray2;
                if (lArray2.length > 0) {
                    this.d.add(this.a(l2, l3));
                    this.hObjects.add(l3);
                } else if (bl) {
                    this.p11.C_DestroyObject(l2, l3);
                }
                a.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
            }
        }
        catch (CertificateException | PKCS11Exception exception) {
            a.error("Exception:", (Throwable)exception);
            return null;
        }
        X509Certificate[] x509CertificateArray = this.a();
        a.debug("FIN getCertificates");
        return x509CertificateArray;
    }

    public X509Certificate[] getCertificatesLogout(long l2) {
        a.debug("INICIO getCertificatesLogout");
        this.d = new ArrayList();
        this.hObjects = new ArrayList();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            a.debug("C_FindObjects");
            long[] exception = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] lArray = exception;
            int n2 = exception.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = lArray[i2];
                Object object = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                ((CK_ATTRIBUTE)object).type = 0L;
                ((CK_ATTRIBUTE)object).pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue == null) continue;
                cK_ATTRIBUTEArray[0] = object;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                a.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                a.debug("C_FindObjects");
                long[] lArray2 = this.p11.C_FindObjects(l2, 1000L);
                object = lArray2;
                if (lArray2.length > 0) {
                    this.d.add(this.a(l2, l3));
                    this.hObjects.add(l3);
                }
                a.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
            }
        }
        catch (CertificateException | PKCS11Exception exception) {
            a.error("Exception:", (Throwable)exception);
            return null;
        }
        X509Certificate[] x509CertificateArray = this.a();
        a.debug("FIN getCertificatesLogout");
        return x509CertificateArray;
    }

    public boolean isNewCertificate(long l2, byte[] objectArray) {
        a.debug("INICIO isNewCertificate");
        boolean bl = true;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        cK_ATTRIBUTE.type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        cK_ATTRIBUTE2.type = 258L;
        cK_ATTRIBUTE2.pValue = objectArray;
        cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE2;
        try {
            a.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            a.debug("C_FindObjects");
            objectArray = this.p11.C_FindObjects(l2, 1000L);
            a.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            if (objectArray.length > 0) {
                bl = false;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
        }
        a.debug("FIN isNewCertificate");
        return bl;
    }

    public long makeCertificate(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        a.debug("INICIO makeCertificate");
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 128L;
        cK_ATTRIBUTE2.pValue = 0L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[9];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)cK_ATTRIBUTE3;
        objectArray[3] = (byte)cK_ATTRIBUTE2;
        objectArray[4] = (byte)new CK_ATTRIBUTE(257L, byArray2);
        objectArray[5] = (byte)object;
        objectArray[6] = (byte)new CK_ATTRIBUTE(129L, byArray3);
        objectArray[7] = (byte)new CK_ATTRIBUTE(130L, byArray4);
        objectArray[8] = (byte)new CK_ATTRIBUTE(17L, byArray);
        try {
            a.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                a.debug("FIN makeCertificate");
                return l3;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception:", (Throwable)pKCS11Exception);
            a.debug("FIN makeCertificate");
            if (pKCS11Exception.getErrorCode() == 49L) {
                return -2L;
            }
            return -1L;
        }
        a.debug("FIN makeCertificate");
        return 0L;
    }

    public long makePublicKey(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        a.debug("INICIO makePublicKey");
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 2L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 256L;
        cK_ATTRIBUTE2.pValue = 0L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[8];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)cK_ATTRIBUTE3;
        objectArray[3] = (byte)cK_ATTRIBUTE2;
        objectArray[4] = (byte)object;
        objectArray[5] = (byte)new CK_ATTRIBUTE(257L, byArray);
        if (byArray2.length % 64 != 0) {
            byArray2 = Arrays.copyOfRange(byArray2, 1, byArray2.length);
        }
        objectArray[6] = (byte)new CK_ATTRIBUTE(288L, byArray2);
        objectArray[7] = (byte)new CK_ATTRIBUTE(290L, byArray3);
        try {
            a.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                a.debug("FIN makePublicKey");
                return l3;
            }
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
            a.debug("FIN makePublicKey");
            return -1L;
        }
        a.debug("FIN makePublicKey");
        return 0L;
    }

    public long makePrivateKey(long l2, String object, byte[] objectArray, byte[] object2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7, byte[] byArray8) {
        a.debug("INICIO makePrivateKey");
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 3L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 256L;
        cK_ATTRIBUTE2.pValue = 0L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[16];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)new CK_ATTRIBUTE(2L, true);
        objectArray[3] = (byte)cK_ATTRIBUTE3;
        objectArray[4] = (byte)cK_ATTRIBUTE2;
        objectArray[5] = (byte)object;
        objectArray[6] = (byte)new CK_ATTRIBUTE(257L, object2);
        objectArray[7] = (byte)new CK_ATTRIBUTE(259L, true);
        if (byArray.length % 64 != 0 && byArray[0] == 0) {
            byArray = Arrays.copyOfRange(byArray, 1, byArray.length);
        }
        objectArray[8] = (byte)new CK_ATTRIBUTE(288L, byArray);
        objectArray[9] = (byte)new CK_ATTRIBUTE(290L, byArray2);
        if (byArray3.length % 64 != 0) {
            if (byArray3.length > byArray.length) {
                if (byArray3[0] == 0) {
                    byArray3 = Arrays.copyOfRange(byArray3, 1, byArray3.length);
                }
            } else if (byArray3.length < byArray.length) {
                object = new byte[]{0};
                object2 = new ByteArrayOutputStream();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    ((OutputStream)object2).write(byArray3);
                }
                catch (IOException iOException) {
                    a.debug((Object)iOException);
                }
                byArray3 = ((ByteArrayOutputStream)object2).toByteArray();
            }
        }
        objectArray[10] = (byte)new CK_ATTRIBUTE(291L, byArray3);
        if (byArray4.length % 64 != 0) {
            if (byArray4.length > byArray.length / 2) {
                if (byArray4[0] == 0) {
                    byArray4 = Arrays.copyOfRange(byArray4, 1, byArray4.length);
                }
            } else if (byArray4.length < byArray.length / 2) {
                object = new byte[]{0};
                object2 = new ByteArrayOutputStream();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    ((OutputStream)object2).write(byArray4);
                }
                catch (IOException iOException) {
                    a.debug((Object)iOException);
                }
                byArray4 = ((ByteArrayOutputStream)object2).toByteArray();
            }
        }
        objectArray[11] = (byte)new CK_ATTRIBUTE(292L, byArray4);
        if (byArray5.length % 64 != 0) {
            if (byArray5.length > byArray.length / 2) {
                if (byArray5[0] == 0) {
                    byArray5 = Arrays.copyOfRange(byArray5, 1, byArray5.length);
                }
            } else if (byArray5.length < byArray.length / 2) {
                object = new byte[]{0};
                object2 = new ByteArrayOutputStream();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    ((OutputStream)object2).write(byArray5);
                }
                catch (IOException iOException) {
                    a.debug((Object)iOException);
                }
                byArray5 = ((ByteArrayOutputStream)object2).toByteArray();
            }
        }
        objectArray[12] = (byte)new CK_ATTRIBUTE(293L, byArray5);
        if (byArray6.length % 64 != 0) {
            if (byArray6.length > byArray.length / 2) {
                if (byArray6[0] == 0) {
                    byArray6 = Arrays.copyOfRange(byArray6, 1, byArray6.length);
                }
            } else if (byArray6.length < byArray.length / 2) {
                object = new byte[]{0};
                object2 = new ByteArrayOutputStream();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    ((OutputStream)object2).write(byArray6);
                }
                catch (IOException iOException) {
                    a.debug((Object)iOException);
                }
                byArray6 = ((ByteArrayOutputStream)object2).toByteArray();
            }
        }
        objectArray[13] = (byte)new CK_ATTRIBUTE(294L, byArray6);
        if (byArray7.length % 64 != 0) {
            if (byArray7.length > byArray.length / 2) {
                if (byArray7[0] == 0) {
                    byArray7 = Arrays.copyOfRange(byArray7, 1, byArray7.length);
                }
            } else if (byArray7.length < byArray.length / 2) {
                object = new byte[]{0};
                object2 = new ByteArrayOutputStream();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    ((OutputStream)object2).write(byArray7);
                }
                catch (IOException iOException) {
                    a.debug((Object)iOException);
                }
                byArray7 = ((ByteArrayOutputStream)object2).toByteArray();
            }
        }
        objectArray[14] = (byte)new CK_ATTRIBUTE(295L, byArray7);
        if (byArray8.length % 64 != 0) {
            if (byArray8.length > byArray.length / 2) {
                if (byArray8[0] == 0) {
                    byArray8 = Arrays.copyOfRange(byArray8, 1, byArray8.length);
                }
            } else if (byArray8.length < byArray.length / 2) {
                object = new byte[]{0};
                object2 = new ByteArrayOutputStream();
                try {
                    ((OutputStream)object2).write((byte[])object);
                    ((OutputStream)object2).write(byArray8);
                }
                catch (IOException iOException) {
                    a.debug((Object)iOException);
                }
                byArray8 = ((ByteArrayOutputStream)object2).toByteArray();
            }
        }
        objectArray[15] = (byte)new CK_ATTRIBUTE(296L, byArray8);
        try {
            a.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                a.debug("FIN makePrivateKey");
                return l3;
            }
        }
        catch (Exception exception) {
            a.error("Exception:", (Throwable)exception);
            a.debug("FIN makePrivateKey");
            return -1L;
        }
        a.debug("FIN makePrivateKey");
        return 0L;
    }

    public long makeECPublicKey(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2, byte[] object2) {
        a.debug("INICIO makeECPublicKey");
        a.debug("Parameters:");
        a.debug("- Alias: " + (String)object);
        a.debug("- Identifier: " + Utilities.bytesToHex(objectArray));
        a.debug("- Subject: " + Utilities.bytesToHex(byArray));
        a.debug("- Oid curva: " + Utilities.bytesToHex(byArray2));
        a.debug("- Public point: " + Utilities.bytesToHex(object2));
        try {
            DEROctetString dEROctetString = new DEROctetString(object2);
            object2 = dEROctetString;
            object2 = dEROctetString.getEncoded();
            a.debug("- Atributo CKA_EC_POINT: " + Utilities.bytesToHex(object2));
            CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
            new CK_ATTRIBUTE().type = 0L;
            cK_ATTRIBUTE.pValue = 2L;
            CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
            new CK_ATTRIBUTE().type = 256L;
            cK_ATTRIBUTE2.pValue = 3L;
            CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
            new CK_ATTRIBUTE().type = 3L;
            cK_ATTRIBUTE3.pValue = object;
            object = new CK_ATTRIBUTE();
            new CK_ATTRIBUTE().type = 258L;
            ((CK_ATTRIBUTE)object).pValue = objectArray;
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[8];
            objectArray = cK_ATTRIBUTEArray;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
            objectArray[2] = (byte)cK_ATTRIBUTE3;
            objectArray[3] = (byte)cK_ATTRIBUTE2;
            objectArray[4] = (byte)object;
            objectArray[5] = (byte)new CK_ATTRIBUTE(257L, byArray);
            objectArray[6] = (byte)new CK_ATTRIBUTE(384L, byArray2);
            objectArray[7] = (byte)new CK_ATTRIBUTE(385L, object2);
            try {
                a.debug("C_CreateObject");
                long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
                if (0L != l3) {
                    a.debug("FIN makeECPublicKey");
                    return l3;
                }
            }
            catch (Exception exception) {
                a.debug("FIN makeECPublicKey. ERROR:" + exception.getMessage());
                return -1L;
            }
            a.debug("FIN makeECPublicKey");
        }
        catch (Exception exception) {}
        return 0L;
    }

    public long makeECPrivateKey(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2) {
        a.debug("INI makeECPrivateKey");
        a.debug("Parameters:");
        a.debug("- Alias: " + (String)object);
        a.debug("- Identifier: " + Utilities.bytesToHex(objectArray));
        a.debug("- Subject: " + Utilities.bytesToHex(byArray));
        a.debug("- Punto priv: " + Utilities.bytesToHex(byArray2));
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 3L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 256L;
        cK_ATTRIBUTE2.pValue = 3L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[9];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)new CK_ATTRIBUTE(2L, true);
        objectArray[3] = (byte)cK_ATTRIBUTE3;
        objectArray[4] = (byte)cK_ATTRIBUTE2;
        objectArray[5] = (byte)object;
        objectArray[6] = (byte)new CK_ATTRIBUTE(257L, byArray);
        objectArray[7] = (byte)new CK_ATTRIBUTE(259L, true);
        if (byArray2.length % 2 != 0 && byArray2[0] == 0) {
            byArray2 = Arrays.copyOfRange(byArray2, 1, byArray2.length);
        }
        objectArray[8] = (byte)new CK_ATTRIBUTE(17L, byArray2);
        try {
            a.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                a.debug("FIN makeECPrivateKey");
                return l3;
            }
        }
        catch (Exception exception) {
            a.debug("FIN makeECPrivateKey.ERROR:" + exception.getMessage());
            return -1L;
        }
        a.debug("FIN makeECPrivateKey");
        return 0L;
    }

    public static byte[] extraerAlgClaveCurvas(byte[] object) {
        byte[] byArray;
        block8: {
            byArray = null;
            try {
                Oid oid = new Oid("1.2.840.10045.3.1.7");
                Oid oid2 = new Oid("1.3.132.0.34");
                Oid oid3 = new Oid("1.3.132.0.35");
                Oid oid4 = new Oid("1.3.36.3.3.2.8.1.1.7");
                Oid oid5 = new Oid("1.3.36.3.3.2.8.1.1.11");
                Oid oid6 = new Oid("1.3.36.3.3.2.8.1.1.13");
                a.debug("nist256 encoded:" + Utilities.bytesToHex(oid.getDER()));
                String string = Utilities.bytesToHex(oid.getDER());
                String string2 = Utilities.bytesToHex(oid2.getDER());
                String string3 = Utilities.bytesToHex(oid3.getDER());
                String string4 = Utilities.bytesToHex(oid4.getDER());
                String string5 = Utilities.bytesToHex(oid5.getDER());
                String string6 = Utilities.bytesToHex(oid6.getDER());
                String string7 = Utilities.bytesToHex((byte[])object);
                object = string7;
                if (string7.contains(string)) {
                    byArray = oid.getDER();
                    break block8;
                }
                if (((String)object).contains(string2)) {
                    byArray = oid2.getDER();
                    break block8;
                }
                if (((String)object).contains(string3)) {
                    byArray = oid3.getDER();
                    break block8;
                }
                if (((String)object).contains(string4)) {
                    byArray = oid4.getDER();
                    break block8;
                }
                if (((String)object).contains(string5)) {
                    byArray = oid5.getDER();
                    break block8;
                }
                if (((String)object).contains(string6)) {
                    byArray = oid6.getDER();
                    break block8;
                }
                throw new Exception("Algoritmo de Clave no soportada");
            }
            catch (Exception exception) {
                a.debug("Exception:" + exception.getMessage());
            }
        }
        return byArray;
    }

    public void testSign(long l2) {
        try {
            byte[] byArray = new byte[25];
            this.p11.C_SignInit(l2, new CK_MECHANISM(13L), this.getPrivateKeyObjectByModulus(l2));
            byte[] byArray2 = this.p11.C_Sign(l2, byArray);
            this.p11.C_Verify(l2, byArray, byArray2);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            Logger.getLogger(PKCS11Helper.class.getName()).log(Level.SEVERE, null, pKCS11Exception);
            return;
        }
    }

    static {
        info = null;
    }
}

