/*
 * Decompiled with CFR 0.152.
 */
package sun.net.httpserver;

import com.sun.net.httpserver.Headers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import sun.net.httpserver.ServerConfig;
import sun.net.httpserver.ServerImpl;

class Request {
    static final int BUF_LEN = 2048;
    static final byte CR = 13;
    static final byte LF = 10;
    private String startLine;
    private SocketChannel chan;
    private InputStream is;
    private OutputStream os;
    private final int maxReqHeaderSize;
    char[] buf = new char[2048];
    int pos;
    StringBuffer lineBuf;
    Headers hdrs = null;

    Request(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.maxReqHeaderSize = ServerConfig.getMaxReqHeaderSize();
        this.is = inputStream;
        this.os = outputStream;
        do {
            this.startLine = this.readLine();
            if (this.startLine != null) continue;
            return;
        } while (this.startLine != null && this.startLine.equals(""));
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    public String readLine() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        this.pos = 0;
        this.lineBuf = new StringBuffer();
        long l = 32L;
        while (!bl2) {
            int n = this.is.read();
            if (n == -1) {
                return null;
            }
            if (bl) {
                if (n == 10) {
                    bl2 = true;
                } else {
                    bl = false;
                    this.consume(13);
                    this.consume(n);
                    l += 2L;
                }
            } else if (n == 13) {
                bl = true;
            } else {
                this.consume(n);
                ++l;
            }
            if (this.maxReqHeaderSize <= 0 || l <= (long)this.maxReqHeaderSize) continue;
            throw new IOException("Maximum size of request headers (sun.net.httpserver.maxReqHeaderSize) exceeded, " + this.maxReqHeaderSize + ".");
        }
        this.lineBuf.append(this.buf, 0, this.pos);
        return new String(this.lineBuf);
    }

    private void consume(int n) throws IOException {
        if (this.pos == 2048) {
            this.lineBuf.append(this.buf);
            this.pos = 0;
        }
        this.buf[this.pos++] = (char)n;
    }

    public String requestLine() {
        return this.startLine;
    }

    /*
     * Enabled aggressive block sorting
     */
    Headers headers() throws IOException {
        if (this.hdrs != null) {
            return this.hdrs;
        }
        this.hdrs = new Headers();
        char[] cArray = new char[10];
        int n = 0;
        int n2 = this.is.read();
        if (n2 == 13 || n2 == 10) {
            int n3 = this.is.read();
            if (n3 == 13 || n3 == 10) {
                return this.hdrs;
            }
            cArray[0] = (char)n2;
            n = 1;
            n2 = n3;
        }
        long l = (long)this.startLine.length() + 32L;
        while (true) {
            String string;
            int n4;
            block25: {
                int n5;
                long l2;
                boolean bl;
                if (n2 != 10 && n2 != 13 && n2 >= 0) {
                    n4 = -1;
                    bl = n2 > 32;
                    cArray[n++] = (char)n2;
                    l2 = this.maxReqHeaderSize > 0 ? (long)this.maxReqHeaderSize - ++l - 32L : Long.MAX_VALUE;
                } else {
                    return this.hdrs;
                }
                while ((n5 = this.is.read()) >= 0) {
                    switch (n5) {
                        case 58: {
                            if (bl && n > 0) {
                                n4 = n;
                            }
                            bl = false;
                            break;
                        }
                        case 9: {
                            n5 = 32;
                        }
                        case 32: {
                            bl = false;
                            break;
                        }
                        case 10: 
                        case 13: {
                            n2 = this.is.read();
                            if (n5 == 13 && n2 == 10 && (n2 = this.is.read()) == 13) {
                                n2 = this.is.read();
                            }
                            if (n2 == 10 || n2 == 13 || n2 > 32) break block25;
                            n5 = 32;
                        }
                    }
                    if (n >= cArray.length) {
                        char[] cArray2 = new char[cArray.length * 2];
                        System.arraycopy(cArray, 0, cArray2, 0, n);
                        cArray = cArray2;
                    }
                    cArray[n++] = (char)n5;
                    if (this.maxReqHeaderSize <= 0 || (long)n <= l2) continue;
                    throw new IOException("Maximum header (sun.net.httpserver.maxReqHeaderSize) exceeded, " + ServerConfig.getMaxReqHeaderSize() + ".");
                }
                n2 = -1;
            }
            while (n > 0 && cArray[n - 1] <= ' ') {
                --n;
            }
            if (n4 <= 0) {
                string = null;
                n4 = 0;
            } else {
                string = String.copyValueOf(cArray, 0, n4);
                if (n4 < n && cArray[n4] == ':') {
                    ++n4;
                }
                while (n4 < n && cArray[n4] <= ' ') {
                    ++n4;
                }
            }
            String string2 = n4 >= n ? new String() : String.copyValueOf(cArray, n4, n - n4);
            if (this.hdrs.size() >= ServerConfig.getMaxReqHeaders()) {
                throw new IOException("Maximum number of request headers (sun.net.httpserver.maxReqHeaders) exceeded, " + ServerConfig.getMaxReqHeaders() + ".");
            }
            l = l + (long)n + 32L;
            if (this.maxReqHeaderSize > 0 && l > (long)this.maxReqHeaderSize) {
                throw new IOException("Maximum header (sun.net.httpserver.maxReqHeaderSize) exceeded, " + ServerConfig.getMaxReqHeaderSize() + ".");
            }
            if (string == null) {
                string = "";
            }
            this.hdrs.add(string, string2);
            n = 0;
        }
    }

    static class ReadStream
    extends InputStream {
        SocketChannel channel;
        ByteBuffer chanbuf;
        byte[] one;
        private boolean closed = false;
        private boolean eof = false;
        ByteBuffer markBuf;
        boolean marked;
        boolean reset;
        int readlimit;
        static long readTimeout;
        ServerImpl server;
        static final int BUFSIZE = 8192;

        public ReadStream(ServerImpl serverImpl, SocketChannel socketChannel) throws IOException {
            this.channel = socketChannel;
            this.server = serverImpl;
            this.chanbuf = ByteBuffer.allocate(8192);
            this.chanbuf.clear();
            this.one = new byte[1];
            this.reset = false;
            this.marked = false;
            this.closed = false;
        }

        @Override
        public synchronized int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public synchronized int read() throws IOException {
            int n = this.read(this.one, 0, 1);
            if (n == 1) {
                return this.one[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.eof) {
                return -1;
            }
            assert (this.channel.isBlocking());
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            if (this.reset) {
                int n4 = this.markBuf.remaining();
                n3 = n4 > n2 ? n2 : n4;
                this.markBuf.get(byArray, n, n3);
                if (n4 == n3) {
                    this.reset = false;
                }
            } else {
                this.chanbuf.clear();
                if (n2 < 8192) {
                    this.chanbuf.limit(n2);
                }
                while ((n3 = this.channel.read(this.chanbuf)) == 0) {
                }
                if (n3 == -1) {
                    this.eof = true;
                    return -1;
                }
                this.chanbuf.flip();
                this.chanbuf.get(byArray, n, n3);
                if (this.marked) {
                    try {
                        this.markBuf.put(byArray, n, n3);
                    }
                    catch (BufferOverflowException bufferOverflowException) {
                        this.marked = false;
                    }
                }
            }
            return n3;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized int available() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            if (this.eof) {
                return -1;
            }
            if (this.reset) {
                return this.markBuf.remaining();
            }
            return this.chanbuf.remaining();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.closed = true;
        }

        @Override
        public synchronized void mark(int n) {
            if (this.closed) {
                return;
            }
            this.readlimit = n;
            this.markBuf = ByteBuffer.allocate(n);
            this.marked = true;
            this.reset = false;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.closed) {
                return;
            }
            if (!this.marked) {
                throw new IOException("Stream not marked");
            }
            this.marked = false;
            this.reset = true;
            this.markBuf.flip();
        }
    }

    static class WriteStream
    extends OutputStream {
        SocketChannel channel;
        ByteBuffer buf;
        SelectionKey key;
        boolean closed;
        byte[] one;
        ServerImpl server;

        public WriteStream(ServerImpl serverImpl, SocketChannel socketChannel) throws IOException {
            this.channel = socketChannel;
            this.server = serverImpl;
            assert (socketChannel.isBlocking());
            this.closed = false;
            this.one = new byte[1];
            this.buf = ByteBuffer.allocate(4096);
        }

        @Override
        public synchronized void write(int n) throws IOException {
            this.one[0] = (byte)n;
            this.write(this.one, 0, 1);
        }

        @Override
        public synchronized void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = n2;
            if (this.closed) {
                throw new IOException("stream is closed");
            }
            int n5 = this.buf.capacity();
            if (n5 < n2) {
                n3 = n2 - n5;
                this.buf = ByteBuffer.allocate(2 * (n5 + n3));
            }
            this.buf.clear();
            this.buf.put(byArray, n, n2);
            this.buf.flip();
            while ((n3 = this.channel.write(this.buf)) < n4) {
                if ((n4 -= n3) != 0) continue;
                return;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.channel.close();
            this.closed = true;
        }
    }
}

