/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import com.sun.org.apache.xml.internal.serializer.AttributesImplSerializer;
import com.sun.org.apache.xml.internal.serializer.DOMSerializer;
import com.sun.org.apache.xml.internal.serializer.ElemContext;
import com.sun.org.apache.xml.internal.serializer.NamespaceMappings;
import com.sun.org.apache.xml.internal.serializer.SerializationHandler;
import com.sun.org.apache.xml.internal.serializer.SerializerConstants;
import com.sun.org.apache.xml.internal.serializer.SerializerTrace;
import com.sun.org.apache.xml.internal.serializer.dom3.DOM3SerializerImpl;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.Locator2;

public abstract class SerializerBase
implements SerializationHandler,
SerializerConstants {
    protected boolean m_needToCallStartDocument = true;
    protected boolean m_cdataTagOpen = false;
    protected AttributesImplSerializer m_attributes = new AttributesImplSerializer();
    protected boolean m_inEntityRef = false;
    protected boolean m_inExternalDTD = false;
    protected String m_doctypeSystem;
    protected String m_doctypePublic;
    boolean m_needToOutputDocTypeDecl = true;
    protected boolean m_shouldNotWriteXMLHeader = false;
    private String m_standalone;
    protected boolean m_standaloneWasSpecified = false;
    protected boolean m_isStandalone = false;
    protected boolean m_doIndent = false;
    protected int m_indentAmount = 0;
    protected String m_version = null;
    protected String m_mediatype;
    private Transformer m_transformer;
    protected NamespaceMappings m_prefixMap;
    protected SerializerTrace m_tracer;
    protected SourceLocator m_sourceLocator;
    protected Writer m_writer = null;
    protected ElemContext m_elemContext = new ElemContext();
    protected char[] m_charsBuff = new char[60];
    protected char[] m_attrBuff = new char[30];
    private Locator m_locator = null;
    protected boolean m_needToCallSetDocumentInfo = true;
    protected String m_StringOfCDATASections = null;
    boolean m_docIsEmpty = true;
    protected HashMap<String, HashMap<String, String>> m_CdataElems = null;
    private HashMap<String, String> m_OutputProps;
    private HashMap<String, String> m_OutputPropsDefault;

    protected void fireEndElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(4, string, (Attributes)null);
        }
    }

    protected void fireCharEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(5, cArray, n, n2);
        }
    }

    @Override
    public void comment(String string) throws SAXException {
        int n = string.length();
        if (n > this.m_charsBuff.length) {
            this.m_charsBuff = new char[n * 2 + 1];
        }
        string.getChars(0, n, this.m_charsBuff, 0);
        this.comment(this.m_charsBuff, 0, n);
    }

    protected String patchName(String string) {
        int n = string.lastIndexOf(58);
        if (n > 0) {
            int n2 = string.indexOf(58);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n + 1);
            String string4 = this.m_prefixMap.lookupNamespace(string2);
            if (string4 != null && string4.length() == 0) {
                return string3;
            }
            if (n2 != n) {
                return string2 + ':' + string3;
            }
        }
        return string;
    }

    protected static String getLocalName(String string) {
        int n = string.lastIndexOf(58);
        return n > 0 ? string.substring(n + 1) : string;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5, boolean bl) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.addAttributeAlways(string, string2, string3, string4, string5, bl);
        }
    }

    public boolean addAttributeAlways(String string, String string2, String string3, String string4, String string5, boolean bl) {
        boolean bl2;
        int n = string2 == null || string == null || string.length() == 0 ? this.m_attributes.getIndex(string3) : this.m_attributes.getIndex(string, string2);
        if (n >= 0) {
            this.m_attributes.setValue(n, string5);
            bl2 = false;
        } else {
            this.m_attributes.addAttribute(string, string2, string3, string4, string5);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void addAttribute(String string, String string2) {
        if (this.m_elemContext.m_startTagOpen) {
            String string3 = this.patchName(string);
            String string4 = SerializerBase.getLocalName(string3);
            String string5 = this.getNamespaceURI(string3, false);
            this.addAttributeAlways(string5, string4, string3, "CDATA", string2, false);
        }
    }

    @Override
    public void addXSLAttribute(String string, String string2, String string3) {
        if (this.m_elemContext.m_startTagOpen) {
            String string4 = this.patchName(string);
            String string5 = SerializerBase.getLocalName(string4);
            this.addAttributeAlways(string3, string5, string4, "CDATA", string2, true);
        }
    }

    @Override
    public void addAttributes(Attributes attributes) throws SAXException {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getURI(i);
            if (null == string) {
                string = "";
            }
            this.addAttributeAlways(string, attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i), false);
        }
    }

    @Override
    public ContentHandler asContentHandler() throws IOException {
        return this;
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (string.equals("[dtd]")) {
            this.m_inExternalDTD = false;
        }
        this.m_inEntityRef = false;
        if (this.m_tracer != null) {
            this.fireEndEntity(string);
        }
    }

    @Override
    public void close() {
    }

    protected void initCDATA() {
    }

    @Override
    public String getEncoding() {
        return this.getOutputProperty("encoding");
    }

    @Override
    public void setEncoding(String string) {
        this.setOutputProperty("encoding", string);
    }

    @Override
    public void setOmitXMLDeclaration(boolean bl) {
        String string = bl ? "yes" : "no";
        this.setOutputProperty("omit-xml-declaration", string);
    }

    @Override
    public boolean getOmitXMLDeclaration() {
        return this.m_shouldNotWriteXMLHeader;
    }

    @Override
    public String getDoctypePublic() {
        return this.m_doctypePublic;
    }

    @Override
    public void setDoctypePublic(String string) {
        this.setOutputProperty("doctype-public", string);
    }

    @Override
    public String getDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    @Override
    public void setDoctypeSystem(String string) {
        this.setOutputProperty("doctype-system", string);
    }

    @Override
    public void setDoctype(String string, String string2) {
        this.setOutputProperty("doctype-system", string);
        this.setOutputProperty("doctype-public", string2);
    }

    @Override
    public void setStandalone(String string) {
        this.setOutputProperty("standalone", string);
    }

    protected void setStandaloneInternal(String string) {
        this.m_standalone = "yes".equals(string) ? "yes" : "no";
    }

    @Override
    public String getStandalone() {
        return this.m_standalone;
    }

    @Override
    public boolean getIndent() {
        return this.m_doIndent;
    }

    @Override
    public String getMediaType() {
        return this.m_mediatype;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    @Override
    public void setVersion(String string) {
        this.setOutputProperty("version", string);
    }

    @Override
    public void setMediaType(String string) {
        this.setOutputProperty("media-type", string);
    }

    @Override
    public int getIndentAmount() {
        return this.m_indentAmount;
    }

    @Override
    public void setIndentAmount(int n) {
        this.m_indentAmount = n;
    }

    @Override
    public void setIndent(boolean bl) {
        String string = bl ? "yes" : "no";
        this.setOutputProperty("indent", string);
    }

    @Override
    public void setIsStandalone(boolean bl) {
        this.m_isStandalone = bl;
    }

    @Override
    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
    }

    @Override
    public DOMSerializer asDOMSerializer() throws IOException {
        return this;
    }

    private static final boolean subPartMatch(String string, String string2) {
        return string == string2 || null != string && string.equals(string2);
    }

    protected static final String getPrefixPart(String string) {
        int n = string.indexOf(58);
        return n > 0 ? string.substring(0, n) : null;
    }

    @Override
    public NamespaceMappings getNamespaceMappings() {
        return this.m_prefixMap;
    }

    @Override
    public String getPrefix(String string) {
        String string2 = this.m_prefixMap.lookupPrefix(string);
        return string2;
    }

    @Override
    public String getNamespaceURI(String string, boolean bl) {
        String string2;
        String string3 = "";
        int n = string.lastIndexOf(58);
        String string4 = string2 = n > 0 ? string.substring(0, n) : "";
        if (!("".equals(string2) && !bl || this.m_prefixMap == null || (string3 = this.m_prefixMap.lookupNamespace(string2)) != null || string2.equals("xmlns"))) {
            throw new RuntimeException(Utils.messages.createMessage("ER_NAMESPACE_PREFIX", new Object[]{string.substring(0, n)}));
        }
        return string3;
    }

    @Override
    public String getNamespaceURIFromPrefix(String string) {
        String string2 = null;
        if (this.m_prefixMap != null) {
            string2 = this.m_prefixMap.lookupNamespace(string);
        }
        return string2;
    }

    @Override
    public void entityReference(String string) throws SAXException {
        this.flushPending();
        this.startEntity(string);
        this.endEntity(string);
        if (this.m_tracer != null) {
            this.fireEntityReference(string);
        }
    }

    @Override
    public void setTransformer(Transformer transformer) {
        this.m_transformer = transformer;
        this.m_tracer = this.m_transformer instanceof SerializerTrace && ((SerializerTrace)((Object)this.m_transformer)).hasTraceListeners() ? (SerializerTrace)((Object)this.m_transformer) : null;
    }

    @Override
    public Transformer getTransformer() {
        return this.m_transformer;
    }

    @Override
    public void characters(Node node) throws SAXException {
        this.flushPending();
        String string = node.getNodeValue();
        if (string != null) {
            int n = string.length();
            if (n > this.m_charsBuff.length) {
                this.m_charsBuff = new char[n * 2 + 1];
            }
            string.getChars(0, n, this.m_charsBuff, 0);
            this.characters(this.m_charsBuff, 0, n);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.m_elemContext.m_startTagOpen = false;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    protected void fireStartEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string);
        }
    }

    private void flushMyWriter() {
        if (this.m_writer != null) {
            try {
                this.m_writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void fireCDATAEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(10, cArray, n, n2);
        }
    }

    protected void fireCommentEvent(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(8, new String(cArray, n, n2));
        }
    }

    public void fireEndEntity(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
        }
    }

    protected void fireStartDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(1);
        }
    }

    protected void fireEndDoc() throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(2);
        }
    }

    protected void fireStartElem(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(3, string, this.m_attributes);
        }
    }

    protected void fireEscapingEvent(String string, String string2) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(7, string, string2);
        }
    }

    protected void fireEntityReference(String string) throws SAXException {
        if (this.m_tracer != null) {
            this.flushMyWriter();
            this.m_tracer.fireGenerateEvent(9, string, (Attributes)null);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.startDocumentInternal();
        this.m_needToCallStartDocument = false;
    }

    protected void startDocumentInternal() throws SAXException {
        if (this.m_tracer != null) {
            this.fireStartDoc();
        }
    }

    protected void setDocumentInfo() {
        if (this.m_locator == null) {
            return;
        }
        try {
            String string = ((Locator2)this.m_locator).getXMLVersion();
            if (string != null) {
                this.setVersion(string);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Override
    public void setSourceLocator(SourceLocator sourceLocator) {
        this.m_sourceLocator = sourceLocator;
    }

    @Override
    public void setNamespaceMappings(NamespaceMappings namespaceMappings) {
        this.m_prefixMap = namespaceMappings;
    }

    @Override
    public boolean reset() {
        this.resetSerializerBase();
        return true;
    }

    private void resetSerializerBase() {
        this.m_attributes.clear();
        this.m_StringOfCDATASections = null;
        this.m_elemContext = new ElemContext();
        this.m_doctypePublic = null;
        this.m_doctypeSystem = null;
        this.m_doIndent = false;
        this.m_indentAmount = 0;
        this.m_inEntityRef = false;
        this.m_inExternalDTD = false;
        this.m_mediatype = null;
        this.m_needToCallStartDocument = true;
        this.m_needToOutputDocTypeDecl = false;
        if (this.m_prefixMap != null) {
            this.m_prefixMap.reset();
        }
        this.m_shouldNotWriteXMLHeader = false;
        this.m_sourceLocator = null;
        this.m_standalone = null;
        this.m_standaloneWasSpecified = false;
        this.m_tracer = null;
        this.m_transformer = null;
        this.m_version = null;
    }

    final boolean inTemporaryOutputState() {
        return this.getEncoding() == null;
    }

    @Override
    public void addAttribute(String string, String string2, String string3, String string4, String string5) throws SAXException {
        if (this.m_elemContext.m_startTagOpen) {
            this.addAttributeAlways(string, string2, string3, string4, string5, false);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public void setDTDEntityExpansion(boolean bl) {
    }

    void initCdataElems(String string) {
        if (string != null) {
            int n = string.length();
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!bl) {
                        if (stringBuilder.length() <= 0) continue;
                        string3 = stringBuilder.toString();
                        if (!bl2) {
                            string2 = "";
                        }
                        this.addCDATAElement(string2, string3);
                        stringBuilder.setLength(0);
                        bl2 = false;
                        continue;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if ('{' == c) {
                    bl = true;
                    continue;
                }
                if ('}' == c) {
                    bl2 = true;
                    string2 = stringBuilder.toString();
                    stringBuilder.setLength(0);
                    bl = false;
                    continue;
                }
                stringBuilder.append(c);
            }
            if (stringBuilder.length() > 0) {
                string3 = stringBuilder.toString();
                if (!bl2) {
                    string2 = "";
                }
                this.addCDATAElement(string2, string3);
            }
        }
    }

    private void addCDATAElement(String string, String string2) {
        HashMap<String, String> hashMap;
        if (this.m_CdataElems == null) {
            this.m_CdataElems = new HashMap();
        }
        if ((hashMap = this.m_CdataElems.get(string2)) == null) {
            hashMap = new HashMap();
            this.m_CdataElems.put(string2, hashMap);
        }
        hashMap.put(string, string);
    }

    public boolean documentIsEmpty() {
        return this.m_docIsEmpty && this.m_elemContext.m_currentElemDepth == 0;
    }

    protected boolean isCdataSection() {
        boolean bl = false;
        if (null != this.m_StringOfCDATASections) {
            Object v;
            Object object;
            if (this.m_elemContext.m_elementLocalName == null) {
                object = SerializerBase.getLocalName(this.m_elemContext.m_elementName);
                this.m_elemContext.m_elementLocalName = object;
            }
            if (this.m_elemContext.m_elementURI == null) {
                this.m_elemContext.m_elementURI = this.getElementURI();
            } else if (this.m_elemContext.m_elementURI.length() == 0) {
                if (this.m_elemContext.m_elementName == null) {
                    this.m_elemContext.m_elementName = this.m_elemContext.m_elementLocalName;
                } else if (this.m_elemContext.m_elementLocalName.length() < this.m_elemContext.m_elementName.length()) {
                    this.m_elemContext.m_elementURI = this.getElementURI();
                }
            }
            object = null;
            if (this.m_CdataElems != null) {
                object = this.m_CdataElems.get(this.m_elemContext.m_elementLocalName);
            }
            if (object != null && (v = ((HashMap)object).get(this.m_elemContext.m_elementURI)) != null) {
                bl = true;
            }
        }
        return bl;
    }

    private String getElementURI() {
        String string = null;
        String string2 = SerializerBase.getPrefixPart(this.m_elemContext.m_elementName);
        string = string2 == null ? this.m_prefixMap.lookupNamespace("") : this.m_prefixMap.lookupNamespace(string2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getOutputProperty(String string) {
        String string2 = this.getOutputPropertyNonDefault(string);
        if (string2 == null) {
            string2 = this.getOutputPropertyDefault(string);
        }
        return string2;
    }

    public String getOutputPropertyNonDefault(String string) {
        return this.getProp(string, false);
    }

    @Override
    public Object asDOM3Serializer() throws IOException {
        return new DOM3SerializerImpl(this);
    }

    @Override
    public String getOutputPropertyDefault(String string) {
        return this.getProp(string, true);
    }

    @Override
    public void setOutputProperty(String string, String string2) {
        this.setProp(string, string2, false);
    }

    @Override
    public void setOutputPropertyDefault(String string, String string2) {
        this.setProp(string, string2, true);
    }

    Set<String> getOutputPropDefaultKeys() {
        return this.m_OutputPropsDefault.keySet();
    }

    Set<String> getOutputPropKeys() {
        return this.m_OutputProps.keySet();
    }

    private String getProp(String string, boolean bl) {
        if (this.m_OutputProps == null) {
            this.m_OutputProps = new HashMap();
            this.m_OutputPropsDefault = new HashMap();
        }
        String string2 = bl ? this.m_OutputPropsDefault.get(string) : this.m_OutputProps.get(string);
        return string2;
    }

    void setProp(String string, String string2, boolean bl) {
        if (this.m_OutputProps == null) {
            this.m_OutputProps = new HashMap();
            this.m_OutputPropsDefault = new HashMap();
        }
        if (bl) {
            this.m_OutputPropsDefault.put(string, string2);
        } else if ("cdata-section-elements".equals(string) && string2 != null) {
            this.initCdataElems(string2);
            String string3 = this.m_OutputProps.get(string);
            String string4 = string3 == null ? string3 + ' ' + string2 : string2;
            this.m_OutputProps.put(string, string4);
        } else {
            this.m_OutputProps.put(string, string2);
        }
    }

    static char getFirstCharLocName(String string) {
        int n = string.indexOf(125);
        char c = n < 0 ? string.charAt(0) : string.charAt(n + 1);
        return c;
    }
}

