/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.AttributeHTML;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

final class MethodHTML {
    private final String className;
    private final PrintWriter printWriter;
    private final ConstantHTML constantHtml;
    private final AttributeHTML attributeHtml;

    MethodHTML(String string, String string2, Method[] methodArray, Field[] fieldArray, ConstantHTML constantHTML, AttributeHTML attributeHTML, Charset charset) throws FileNotFoundException, UnsupportedEncodingException {
        this.className = string2;
        this.attributeHtml = attributeHTML;
        this.constantHtml = constantHTML;
        try (PrintWriter printWriter = new PrintWriter(string + string2 + "_methods.html", charset.name());){
            this.printWriter = printWriter;
            this.printWriter.print("<HTML><head><meta charset=\"");
            this.printWriter.print(charset.name());
            this.printWriter.println("\"></head>");
            this.printWriter.println("<BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
            this.printWriter.println("<TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Type</TH><TH ALIGN=LEFT>Field&nbsp;name</TH></TR>");
            for (Field field : fieldArray) {
                this.writeField(field);
            }
            this.printWriter.println("</TABLE>");
            this.printWriter.println("<TABLE BORDER=0><TR><TH ALIGN=LEFT>Access&nbsp;flags</TH><TH ALIGN=LEFT>Return&nbsp;type</TH><TH ALIGN=LEFT>Method&nbsp;name</TH><TH ALIGN=LEFT>Arguments</TH></TR>");
            for (int i = 0; i < methodArray.length; ++i) {
                this.writeMethod(methodArray[i], i);
            }
            this.printWriter.println("</TABLE></BODY></HTML>");
        }
    }

    private void writeField(Field field) {
        int n;
        String string = Utility.signatureToString(field.getSignature());
        String string2 = field.getName();
        String string3 = Utility.accessToString(field.getAccessFlags());
        string3 = Utility.replace(string3, " ", "&nbsp;");
        this.printWriter.print("<TR><TD><FONT COLOR=\"#FF0000\">" + string3 + "</FONT></TD>\n<TD>" + Class2HTML.referenceType(string) + "</TD><TD><A NAME=\"field" + string2 + "\">" + string2 + "</A></TD>");
        Attribute[] attributeArray = field.getAttributes();
        for (n = 0; n < attributeArray.length; ++n) {
            this.attributeHtml.writeAttribute(attributeArray[n], string2 + "@" + n);
        }
        for (n = 0; n < attributeArray.length; ++n) {
            if (attributeArray[n].getTag() != 1) continue;
            String string4 = attributeArray[n].toString();
            this.printWriter.print("<TD>= <A HREF=\"" + this.className + "_attributes.html#" + string2 + "@" + n + "\" TARGET=\"Attributes\">" + string4 + "</TD>\n");
            break;
        }
        this.printWriter.println("</TR>");
    }

    private void writeMethod(Method method, int n) {
        int n2;
        String string = method.getSignature();
        String[] stringArray = Utility.methodSignatureArgumentTypes(string, false);
        String string2 = Utility.methodSignatureReturnType(string, false);
        String string3 = method.getName();
        String string4 = Utility.accessToString(method.getAccessFlags());
        Attribute[] attributeArray = method.getAttributes();
        string4 = Utility.replace(string4, " ", "&nbsp;");
        String string5 = Class2HTML.toHTML(string3);
        this.printWriter.print("<TR VALIGN=TOP><TD><FONT COLOR=\"#FF0000\"><A NAME=method" + n + ">" + string4 + "</A></FONT></TD>");
        this.printWriter.print("<TD>" + Class2HTML.referenceType(string2) + "</TD><TD><A HREF=" + this.className + "_code.html#method" + n + " TARGET=Code>" + string5 + "</A></TD>\n<TD>(");
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.printWriter.print(Class2HTML.referenceType(stringArray[n2]));
            if (n2 >= stringArray.length - 1) continue;
            this.printWriter.print(", ");
        }
        this.printWriter.print(")</TD></TR>");
        for (n2 = 0; n2 < attributeArray.length; ++n2) {
            int n3;
            Object[] objectArray;
            this.attributeHtml.writeAttribute(attributeArray[n2], "method" + n + "@" + n2, n);
            byte by = attributeArray[n2].getTag();
            if (by == 3) {
                this.printWriter.print("<TR VALIGN=TOP><TD COLSPAN=2></TD><TH ALIGN=LEFT>throws</TH><TD>");
                objectArray = ((ExceptionTable)attributeArray[n2]).getExceptionIndexTable();
                for (n3 = 0; n3 < objectArray.length; ++n3) {
                    this.printWriter.print(this.constantHtml.referenceConstant((int)objectArray[n3]));
                    if (n3 >= objectArray.length - 1) continue;
                    this.printWriter.print(", ");
                }
                this.printWriter.println("</TD></TR>");
                continue;
            }
            if (by != 2) continue;
            objectArray = ((Code)attributeArray[n2]).getAttributes();
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.attributeHtml.writeAttribute(objectArray[n3], "method" + n + "@" + n2 + "@" + n3, n);
            }
        }
    }
}

