/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class LocalVariableInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    @Deprecated
    protected int n = -1;
    private short cTag = (short)-1;
    private short canonTag = (short)-1;

    LocalVariableInstruction() {
    }

    LocalVariableInstruction(short s, short s2) {
        this.canonTag = s;
        this.cTag = s2;
    }

    protected LocalVariableInstruction(short s, short s2, int n) {
        super(s, (short)2);
        this.cTag = s2;
        this.canonTag = s;
        this.setIndex(n);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide()) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(super.getOpcode());
        if (super.getLength() > 1) {
            if (this.wide()) {
                dataOutputStream.writeShort(this.n);
            } else {
                dataOutputStream.writeByte(this.n);
            }
        }
    }

    public short getCanonicalTag() {
        return this.canonTag;
    }

    @Override
    public final int getIndex() {
        return this.n;
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (this.canonTag) {
            case 21: 
            case 54: {
                return Type.INT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
        }
        throw new ClassGenException("Unknown case in switch" + this.canonTag);
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        if (bl) {
            this.n = byteSequence.readUnsignedShort();
            super.setLength(4);
        } else {
            short s = super.getOpcode();
            if (s >= 21 && s <= 25 || s >= 54 && s <= 58) {
                this.n = byteSequence.readUnsignedByte();
                super.setLength(2);
            } else {
                this.n = s <= 45 ? (s - 26) % 4 : (s - 59) % 4;
                super.setLength(1);
            }
        }
    }

    @Override
    public void setIndex(int n) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Illegal value: " + n);
        }
        this.n = n;
        if (n <= 3) {
            super.setOpcode((short)(this.cTag + n));
            super.setLength(1);
        } else {
            super.setOpcode(this.canonTag);
            if (this.wide()) {
                super.setLength(4);
            } else {
                super.setLength(2);
            }
        }
    }

    final void setIndexOnly(int n) {
        this.n = n;
    }

    @Override
    public String toString(boolean bl) {
        short s = super.getOpcode();
        if (s >= 26 && s <= 45 || s >= 59 && s <= 78) {
            return super.toString(bl);
        }
        return super.toString(bl) + " " + this.n;
    }

    private boolean wide() {
        return this.n > 255;
    }
}

