/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.NamedAndTyped;
import com.sun.org.apache.bcel.internal.generic.Type;

public class LocalVariableGen
implements InstructionTargeter,
NamedAndTyped,
Cloneable {
    private int index;
    private String name;
    private Type type;
    private InstructionHandle start;
    private InstructionHandle end;
    private int origIndex;
    private boolean liveToEnd;

    public LocalVariableGen(int n, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Invalid index: " + n);
        }
        this.name = string;
        this.type = type;
        this.index = n;
        this.setStart(instructionHandle);
        this.setEnd(instructionHandle2);
        this.origIndex = n;
        this.liveToEnd = instructionHandle2 == null;
    }

    public LocalVariableGen(int n, String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2, int n2) {
        this(n, string, type, instructionHandle, instructionHandle2);
        this.origIndex = n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.start == instructionHandle || this.end == instructionHandle;
    }

    void dispose() {
        this.setStart(null);
        this.setEnd(null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalVariableGen)) {
            return false;
        }
        LocalVariableGen localVariableGen = (LocalVariableGen)object;
        return localVariableGen.index == this.index && localVariableGen.start == this.start && localVariableGen.end == this.end;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getLiveToEnd() {
        return this.liveToEnd;
    }

    public LocalVariable getLocalVariable(ConstantPoolGen constantPoolGen) {
        int n = 0;
        int n2 = 0;
        if (this.start != null && this.end != null) {
            n = this.start.getPosition();
            n2 = this.end.getPosition() - n;
            if (this.end.getNext() == null && this.liveToEnd) {
                n2 += this.end.getInstruction().getLength();
            }
        }
        int n3 = constantPoolGen.addUtf8(this.name);
        int n4 = constantPoolGen.addUtf8(this.type.getSignature());
        return new LocalVariable(n, n2, n3, n4, this.index, constantPoolGen.getConstantPool(), this.origIndex);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getOrigIndex() {
        return this.origIndex;
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.type.hashCode();
    }

    public void setEnd(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.end, instructionHandle, this);
        this.end = instructionHandle;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setLiveToEnd(boolean bl) {
        this.liveToEnd = bl;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    public void setStart(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.start, instructionHandle, this);
        this.start = instructionHandle;
    }

    @Override
    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "LocalVariableGen(" + this.name + ", " + this.type + ", " + this.start + ", " + this.end + ")";
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.start == instructionHandle) {
            bl = true;
            this.setStart(instructionHandle2);
        }
        if (this.end == instructionHandle) {
            bl = true;
            this.setEnd(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.start + ", " + this.end + "}");
        }
    }
}

