/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SourceFile
extends Attribute {
    private int sourceFileIndex;

    SourceFile(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), constantPool);
    }

    public SourceFile(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)0, n, Args.require(n2, 2, "SourceFile length attribute"), constantPool);
        this.sourceFileIndex = Args.requireU2(n3, 0, constantPool.getLength(), "SourceFile source file index");
    }

    public SourceFile(SourceFile sourceFile) {
        this(sourceFile.getNameIndex(), sourceFile.getLength(), sourceFile.getSourceFileIndex(), sourceFile.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSourceFile(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.sourceFileIndex);
    }

    public int getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    public String getSourceFileName() {
        return super.getConstantPool().getConstantUtf8(this.sourceFileIndex).getBytes();
    }

    public void setSourceFileIndex(int n) {
        this.sourceFileIndex = n;
    }

    @Override
    public String toString() {
        return "SourceFile: " + this.getSourceFileName();
    }
}

