/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import com.sun.org.apache.bcel.internal.util.ClassQueue;
import com.sun.org.apache.bcel.internal.util.Repository;
import com.sun.org.apache.bcel.internal.util.SyntheticRepository;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node,
Comparable<JavaClass> {
    public static final String EXTENSION = ".class";
    public static final JavaClass[] EMPTY_ARRAY = new JavaClass[0];
    public static final byte HEAP = 1;
    public static final byte FILE = 2;
    public static final byte ZIP = 3;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            JavaClass javaClass = (JavaClass)object;
            JavaClass javaClass2 = (JavaClass)object2;
            return Objects.equals(javaClass.getClassName(), javaClass2.getClassName());
        }

        @Override
        public int hashCode(Object object) {
            JavaClass javaClass = (JavaClass)object;
            return javaClass.getClassName().hashCode();
        }
    };
    private String fileName;
    private final String packageName;
    private String sourceFileName = "<Unknown>";
    private int classNameIndex;
    private int superclassNameIndex;
    private String className;
    private String superclassName;
    private int major;
    private int minor;
    private ConstantPool constantPool;
    private int[] interfaces;
    private String[] interfaceNames;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private AnnotationEntry[] annotations;
    private byte source = 1;
    private boolean isAnonymous;
    private boolean isNested;
    private boolean computedNestedTypeStatus;
    private transient Repository repository = SyntheticRepository.getInstance();

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    private static String indent(Object object) {
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), "\n");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.append("\t").append(stringTokenizer.nextToken()).append("\n");
        }
        return stringBuilder.toString();
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray) {
        this(n, n2, string, n3, n4, n5, constantPool, nArray, fieldArray, methodArray, attributeArray, 1);
    }

    public JavaClass(int n, int n2, String string, int n3, int n4, int n5, ConstantPool constantPool, int[] nArray, Field[] fieldArray, Method[] methodArray, Attribute[] attributeArray, byte by) {
        super(n5);
        if (nArray == null) {
            nArray = Const.EMPTY_INT_ARRAY;
        }
        if (attributeArray == null) {
            attributeArray = Attribute.EMPTY_ARRAY;
        }
        if (fieldArray == null) {
            fieldArray = Field.EMPTY_FIELD_ARRAY;
        }
        if (methodArray == null) {
            methodArray = Method.EMPTY_METHOD_ARRAY;
        }
        this.classNameIndex = n;
        this.superclassNameIndex = n2;
        this.fileName = string;
        this.major = n3;
        this.minor = n4;
        this.constantPool = constantPool;
        this.interfaces = nArray;
        this.fields = fieldArray;
        this.methods = methodArray;
        this.attributes = attributeArray;
        this.source = by;
        Attribute[] attributeArray2 = attributeArray;
        int n6 = attributeArray2.length;
        for (int i = 0; i < n6; ++i) {
            Attribute attribute = attributeArray2[i];
            if (!(attribute instanceof SourceFile)) continue;
            this.sourceFileName = ((SourceFile)attribute).getSourceFileName();
            break;
        }
        this.className = constantPool.getConstantString(n, (byte)7);
        this.className = Utility.compactClassName(this.className, false);
        int n7 = this.className.lastIndexOf(46);
        this.packageName = n7 < 0 ? "" : this.className.substring(0, n7);
        if (n2 > 0) {
            this.superclassName = constantPool.getConstantString(n2, (byte)7);
            this.superclassName = Utility.compactClassName(this.superclassName, false);
        } else {
            this.superclassName = "java.lang.Object";
        }
        this.interfaceNames = new String[nArray.length];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            String string2 = constantPool.getConstantString(nArray[n6], (byte)7);
            this.interfaceNames[n6] = Utility.compactClassName(string2, false);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitJavaClass(this);
    }

    @Override
    public int compareTo(JavaClass javaClass) {
        return this.getClassName().compareTo(javaClass.getClassName());
    }

    private void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof InnerClasses)) continue;
            for (InnerClass innerClass : ((InnerClasses)attribute).getInnerClasses()) {
                boolean bl = false;
                String string = this.constantPool.getConstantString(innerClass.getInnerClassIndex(), (byte)7);
                if ((string = Utility.compactClassName(string, false)).equals(this.getClassName())) {
                    bl = true;
                }
                if (!bl) continue;
                this.isNested = true;
                if (innerClass.getInnerNameIndex() != 0) continue;
                this.isAnonymous = true;
            }
        }
        this.computedNestedTypeStatus = true;
    }

    public JavaClass copy() {
        try {
            int n;
            JavaClass javaClass = (JavaClass)this.clone();
            javaClass.constantPool = this.constantPool.copy();
            javaClass.interfaces = (int[])this.interfaces.clone();
            javaClass.interfaceNames = (String[])this.interfaceNames.clone();
            javaClass.fields = new Field[this.fields.length];
            for (n = 0; n < this.fields.length; ++n) {
                javaClass.fields[n] = this.fields[n].copy(javaClass.constantPool);
            }
            javaClass.methods = new Method[this.methods.length];
            for (n = 0; n < this.methods.length; ++n) {
                javaClass.methods[n] = this.methods[n].copy(javaClass.constantPool);
            }
            javaClass.attributes = new Attribute[this.attributes.length];
            for (n = 0; n < this.attributes.length; ++n) {
                javaClass.attributes[n] = this.attributes[n].copy(javaClass.constantPool);
            }
            return javaClass;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(this.minor);
        dataOutputStream.writeShort(this.major);
        this.constantPool.dump(dataOutputStream);
        dataOutputStream.writeShort(super.getAccessFlags());
        dataOutputStream.writeShort(this.classNameIndex);
        dataOutputStream.writeShort(this.superclassNameIndex);
        dataOutputStream.writeShort(this.interfaces.length);
        for (int n : this.interfaces) {
            dataOutputStream.writeShort(n);
        }
        dataOutputStream.writeShort(this.fields.length);
        for (Field field : this.fields) {
            field.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.length);
        for (Method method : this.methods) {
            method.dump(dataOutputStream);
        }
        if (this.attributes != null) {
            dataOutputStream.writeShort(this.attributes.length);
            for (Attribute attribute : this.attributes) {
                attribute.dump(dataOutputStream);
            }
        } else {
            dataOutputStream.writeShort(0);
        }
        dataOutputStream.flush();
    }

    public void dump(File file) throws IOException {
        Object object;
        String string = file.getParent();
        if (string != null && !((File)(object = new File(string))).mkdirs() && !((File)object).isDirectory()) {
            throw new IOException("Could not create the directory " + object);
        }
        object = new DataOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        try {
            this.dump((DataOutputStream)object);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((FilterOutputStream)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((FilterOutputStream)object).close();
                }
            }
        }
    }

    public void dump(OutputStream outputStream) throws IOException {
        this.dump(new DataOutputStream(outputStream));
    }

    public void dump(String string) throws IOException {
        this.dump(new File(string));
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public JavaClass[] getAllInterfaces() throws ClassNotFoundException {
        ClassQueue classQueue = new ClassQueue();
        TreeSet<JavaClass> treeSet = new TreeSet<JavaClass>();
        classQueue.enqueue(this);
        while (!classQueue.empty()) {
            JavaClass javaClass = classQueue.dequeue();
            JavaClass javaClass2 = javaClass.getSuperClass();
            JavaClass[] javaClassArray = javaClass.getInterfaces();
            if (javaClass.isInterface()) {
                treeSet.add(javaClass);
            } else if (javaClass2 != null) {
                classQueue.enqueue(javaClass2);
            }
            for (JavaClass javaClass3 : javaClassArray) {
                classQueue.enqueue(javaClass3);
            }
        }
        return treeSet.toArray(EMPTY_ARRAY);
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotations == null) {
            this.annotations = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotations;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            this.dump(dataOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getClassName() {
        return this.className;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int[] getInterfaceIndices() {
        return this.interfaces;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public JavaClass[] getInterfaces() throws ClassNotFoundException {
        String[] stringArray = this.getInterfaceNames();
        JavaClass[] javaClassArray = new JavaClass[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            javaClassArray[i] = this.repository.loadClass(stringArray[i]);
        }
        return javaClassArray;
    }

    public int getMajor() {
        return this.major;
    }

    public Method getMethod(java.lang.reflect.Method method) {
        for (Method method2 : this.methods) {
            if (!method.getName().equals(method2.getName()) || method.getModifiers() != method2.getModifiers() || !Type.getSignature(method).equals(method2.getSignature())) continue;
            return method2;
        }
        return null;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public final byte getSource() {
        return this.source;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSourceFilePath() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.packageName.isEmpty()) {
            stringBuilder.append(Utility.packageToPath(this.packageName));
            stringBuilder.append('/');
        }
        stringBuilder.append(this.sourceFileName);
        return stringBuilder.toString();
    }

    public JavaClass getSuperClass() throws ClassNotFoundException {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        return this.repository.loadClass(this.getSuperclassName());
    }

    public JavaClass[] getSuperClasses() throws ClassNotFoundException {
        JavaClass javaClass = this;
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (javaClass = javaClass.getSuperClass(); javaClass != null; javaClass = javaClass.getSuperClass()) {
            arrayList.add(javaClass);
        }
        return arrayList.toArray(EMPTY_ARRAY);
    }

    public String getSuperclassName() {
        return this.superclassName;
    }

    public int getSuperclassNameIndex() {
        return this.superclassNameIndex;
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    public boolean implementationOf(JavaClass javaClass) throws ClassNotFoundException {
        JavaClass[] javaClassArray;
        if (!javaClass.isInterface()) {
            throw new IllegalArgumentException(javaClass.getClassName() + " is no interface");
        }
        if (this.equals(javaClass)) {
            return true;
        }
        for (JavaClass javaClass2 : javaClassArray = this.getAllInterfaces()) {
            if (!javaClass2.equals(javaClass)) continue;
            return true;
        }
        return false;
    }

    public final boolean instanceOf(JavaClass javaClass) throws ClassNotFoundException {
        if (this.equals(javaClass)) {
            return true;
        }
        for (JavaClass javaClass2 : this.getSuperClasses()) {
            if (!javaClass2.equals(javaClass)) continue;
            return true;
        }
        if (javaClass.isInterface()) {
            return this.implementationOf(javaClass);
        }
        return false;
    }

    public final boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final boolean isClass() {
        return (super.getAccessFlags() & 0x200) == 0;
    }

    public final boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    public final boolean isSuper() {
        return (super.getAccessFlags() & 0x20) != 0;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setClassNameIndex(int n) {
        this.classNameIndex = n;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setInterfaceNames(String[] stringArray) {
        this.interfaceNames = stringArray;
    }

    public void setInterfaces(int[] nArray) {
        this.interfaces = nArray;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMethods(Method[] methodArray) {
        this.methods = methodArray;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setSourceFileName(String string) {
        this.sourceFileName = string;
    }

    public void setSuperclassName(String string) {
        this.superclassName = string;
    }

    public void setSuperclassNameIndex(int n) {
        this.superclassNameIndex = n;
    }

    public String toString() {
        AnnotationEntry[] annotationEntryArray;
        String string = Utility.accessToString(super.getAccessFlags(), true);
        string = string.isEmpty() ? "" : string + " ";
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(string).append(Utility.classOrInterface(super.getAccessFlags())).append(" ").append(this.className).append(" extends ").append(Utility.compactClassName(this.superclassName, false)).append('\n');
        int n = this.interfaces.length;
        if (n > 0) {
            stringBuilder.append("implements\t\t");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.interfaceNames[i]);
                if (i >= n - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append("file name\t\t").append(this.fileName).append('\n');
        stringBuilder.append("compiled from\t\t").append(this.sourceFileName).append('\n');
        stringBuilder.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        stringBuilder.append("access flags\t\t").append(super.getAccessFlags()).append('\n');
        stringBuilder.append("constant pool\t\t").append(this.constantPool.getLength()).append(" entries\n");
        stringBuilder.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            stringBuilder.append("\nAttribute(s):\n");
            for (Attribute attribute : this.attributes) {
                stringBuilder.append(JavaClass.indent(attribute));
            }
        }
        if ((annotationEntryArray = this.getAnnotationEntries()) != null && annotationEntryArray.length > 0) {
            stringBuilder.append("\nAnnotation(s):\n");
            for (AnnotationEntry node : annotationEntryArray) {
                stringBuilder.append(JavaClass.indent(node));
            }
        }
        if (this.fields.length > 0) {
            stringBuilder.append("\n").append(this.fields.length).append(" fields:\n");
            for (Field field : this.fields) {
                stringBuilder.append("\t").append(field).append('\n');
            }
        }
        if (this.methods.length > 0) {
            stringBuilder.append("\n").append(this.methods.length).append(" methods:\n");
            for (Method method : this.methods) {
                stringBuilder.append("\t").append(method).append('\n');
            }
        }
        return stringBuilder.toString();
    }
}

