/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.BootstrapMethod;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class BootstrapMethods
extends Attribute
implements Iterable<BootstrapMethod> {
    private BootstrapMethod[] bootstrapMethods;

    public BootstrapMethods(BootstrapMethods bootstrapMethods) {
        this(bootstrapMethods.getNameIndex(), bootstrapMethods.getLength(), bootstrapMethods.getBootstrapMethods(), bootstrapMethods.getConstantPool());
    }

    public BootstrapMethods(int n, int n2, BootstrapMethod[] bootstrapMethodArray, ConstantPool constantPool) {
        super((byte)20, n, n2, constantPool);
        this.bootstrapMethods = bootstrapMethodArray;
    }

    BootstrapMethods(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (BootstrapMethod[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.bootstrapMethods = new BootstrapMethod[n3];
        for (int i = 0; i < n3; ++i) {
            this.bootstrapMethods[i] = new BootstrapMethod(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitBootstrapMethods(this);
    }

    @Override
    public BootstrapMethods copy(ConstantPool constantPool) {
        BootstrapMethods bootstrapMethods = (BootstrapMethods)this.clone();
        bootstrapMethods.bootstrapMethods = new BootstrapMethod[this.bootstrapMethods.length];
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            bootstrapMethods.bootstrapMethods[i] = this.bootstrapMethods[i].copy();
        }
        bootstrapMethods.setConstantPool(constantPool);
        return bootstrapMethods;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.bootstrapMethods.length);
        for (BootstrapMethod bootstrapMethod : this.bootstrapMethods) {
            bootstrapMethod.dump(dataOutputStream);
        }
    }

    public final BootstrapMethod[] getBootstrapMethods() {
        return this.bootstrapMethods;
    }

    @Override
    public Iterator<BootstrapMethod> iterator() {
        return Arrays.asList(this.bootstrapMethods).iterator();
    }

    public final void setBootstrapMethods(BootstrapMethod[] bootstrapMethodArray) {
        this.bootstrapMethods = bootstrapMethodArray;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BootstrapMethods(");
        stringBuilder.append(this.bootstrapMethods.length);
        stringBuilder.append("):");
        for (int i = 0; i < this.bootstrapMethods.length; ++i) {
            stringBuilder.append("\n");
            int n = stringBuilder.length();
            stringBuilder.append("  ").append(i).append(": ");
            int n2 = stringBuilder.length() - n;
            String[] stringArray = this.bootstrapMethods[i].toString(super.getConstantPool()).split("\\r?\\n");
            stringBuilder.append(stringArray[0]);
            for (int j = 1; j < stringArray.length; ++j) {
                stringBuilder.append("\n").append("          ", 0, n2).append(stringArray[j]);
            }
        }
        return stringBuilder.toString();
    }
}

