/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.dtm.ref;

import java.util.HashMap;
import java.util.Vector;

public class DTMStringPool {
    Vector m_intToString = new Vector();
    HashMap<String, Integer> m_stringToInt = new HashMap();
    public static final int NULL = -1;

    public DTMStringPool(int n) {
        this.removeAllElements();
        this.stringToIndex("");
    }

    public DTMStringPool() {
        this(512);
    }

    public void removeAllElements() {
        this.m_intToString.removeAllElements();
        this.m_stringToInt.clear();
    }

    public String indexToString(int n) throws ArrayIndexOutOfBoundsException {
        if (n == -1) {
            return null;
        }
        return (String)this.m_intToString.elementAt(n);
    }

    public int stringToIndex(String string) {
        if (string == null) {
            return -1;
        }
        Integer n = this.m_stringToInt.get(string);
        if (n != null) {
            return n;
        }
        int n2 = this.m_intToString.size();
        this.m_intToString.add(string);
        this.m_stringToInt.put(string, n2);
        return n2;
    }

    public static void _main(String[] stringArray) {
        String[] stringArray2 = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen", "Twenty", "Twenty-One", "Twenty-Two", "Twenty-Three", "Twenty-Four", "Twenty-Five", "Twenty-Six", "Twenty-Seven", "Twenty-Eight", "Twenty-Nine", "Thirty", "Thirty-One", "Thirty-Two", "Thirty-Three", "Thirty-Four", "Thirty-Five", "Thirty-Six", "Thirty-Seven", "Thirty-Eight", "Thirty-Nine"};
        DTMStringPool dTMStringPool = new DTMStringPool();
        System.out.println("If no complaints are printed below, we passed initial test.");
        for (int i = 0; i <= 1; ++i) {
            int n;
            int n2;
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                n = dTMStringPool.stringToIndex(stringArray2[n2]);
                if (n == n2) continue;
                System.out.println("\tMismatch populating pool: assigned " + n + " for create " + n2);
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                n = dTMStringPool.stringToIndex(stringArray2[n2]);
                if (n == n2) continue;
                System.out.println("\tMismatch in stringToIndex: returned " + n + " for lookup " + n2);
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                String string = dTMStringPool.indexToString(n2);
                if (stringArray2[n2].equals(string)) continue;
                System.out.println("\tMismatch in indexToString: returned" + string + " for lookup " + n2);
            }
            dTMStringPool.removeAllElements();
            System.out.println("\nPass " + i + " complete\n");
        }
    }
}

