/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.Repository;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SyntheticRepository
implements Repository {
    private final Map<String, SoftReference<JavaClass>> loadedClasses = new HashMap<String, SoftReference<JavaClass>>();

    private SyntheticRepository() {
    }

    public static SyntheticRepository getInstance() {
        return new SyntheticRepository();
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public JavaClass findClass(String string) {
        SoftReference<JavaClass> softReference = this.loadedClasses.get(string);
        return softReference == null ? null : softReference.get();
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        this.loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this.loadedClasses.put(javaClass.getClassName(), new SoftReference<JavaClass>(javaClass));
        javaClass.setRepository(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        String string = clazz.getName();
        JavaClass javaClass2 = this.findClass(string);
        if (javaClass2 != null) {
            return javaClass2;
        }
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        try (InputStream inputStream = clazz.getResourceAsStream(string2 + ".class");){
            JavaClass javaClass = this.loadClass(inputStream, string);
            return javaClass;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private JavaClass loadClass(InputStream inputStream, String string) throws ClassNotFoundException {
        try {
            if (inputStream != null) {
                ClassParser classParser = new ClassParser(inputStream, string);
                JavaClass javaClass = classParser.parse();
                this.storeClass(javaClass);
                return javaClass;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException, iOException);
        }
        throw new ClassNotFoundException("ClassRepository could not load " + string);
    }

    @Override
    public JavaClass loadClass(String string) throws ClassNotFoundException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("Invalid class name " + string);
        }
        JavaClass javaClass = this.findClass(string = Utility.pathToPackage(string));
        if (javaClass != null) {
            return javaClass;
        }
        IOException iOException = new IOException("Couldn't find: " + string + ".class");
        throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException, iOException);
    }
}

