/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.InnerClass;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.Class2HTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

final class AttributeHTML
implements Closeable {
    private final String className;
    private final PrintWriter printWriter;
    private int attrCount;
    private final ConstantHTML constantHtml;
    private final ConstantPool constantPool;

    AttributeHTML(String string, String string2, ConstantPool constantPool, ConstantHTML constantHTML, Charset charset) throws FileNotFoundException, UnsupportedEncodingException {
        this.className = string2;
        this.constantPool = constantPool;
        this.constantHtml = constantHTML;
        this.printWriter = new PrintWriter(string + string2 + "_attributes.html", charset.name());
        this.printWriter.print("<HTML><head><meta charset=\"");
        this.printWriter.print(charset.name());
        this.printWriter.println("\"></head>");
        this.printWriter.println("<BODY BGCOLOR=\"#C0C0C0\"><TABLE BORDER=0>");
    }

    @Override
    public void close() {
        this.printWriter.println("</TABLE></BODY></HTML>");
        this.printWriter.close();
    }

    private String codeLink(int n, int n2) {
        return "<A HREF=\"" + this.className + "_code.html#code" + n2 + "@" + n + "\" TARGET=Code>" + n + "</A>";
    }

    void writeAttribute(Attribute attribute, String string) {
        this.writeAttribute(attribute, string, 0);
    }

    void writeAttribute(Attribute attribute, String string, int n) {
        byte by = attribute.getTag();
        if (by == -1) {
            return;
        }
        ++this.attrCount;
        if (this.attrCount % 2 == 0) {
            this.printWriter.print("<TR BGCOLOR=\"#C0C0C0\"><TD>");
        } else {
            this.printWriter.print("<TR BGCOLOR=\"#A0A0A0\"><TD>");
        }
        this.printWriter.println("<H4><A NAME=\"" + string + "\">" + this.attrCount + " " + Const.getAttributeName(by) + "</A></H4>");
        switch (by) {
            case 2: {
                Code code = (Code)attribute;
                this.printWriter.print("<UL><LI>Maximum stack size = " + code.getMaxStack() + "</LI>\n<LI>Number of local variables = " + code.getMaxLocals() + "</LI>\n<LI><A HREF=\"" + this.className + "_code.html#method" + n + "\" TARGET=Code>Byte code</A></LI></UL>\n");
                CodeException[] codeExceptionArray = code.getExceptionTable();
                int n2 = codeExceptionArray.length;
                if (n2 <= 0) break;
                this.printWriter.print("<P><B>Exceptions handled</B><UL>");
                for (CodeException codeException : codeExceptionArray) {
                    int n3 = codeException.getCatchType();
                    this.printWriter.print("<LI>");
                    if (n3 != 0) {
                        this.printWriter.print(this.constantHtml.referenceConstant(n3));
                    } else {
                        this.printWriter.print("Any Exception");
                    }
                    this.printWriter.print("<BR>(Ranging from lines " + this.codeLink(codeException.getStartPC(), n) + " to " + this.codeLink(codeException.getEndPC(), n) + ", handled at line " + this.codeLink(codeException.getHandlerPC(), n) + ")</LI>");
                }
                this.printWriter.print("</UL>");
                break;
            }
            case 1: {
                int n4 = ((ConstantValue)attribute).getConstantValueIndex();
                this.printWriter.print("<UL><LI><A HREF=\"" + this.className + "_cp.html#cp" + n4 + "\" TARGET=\"ConstantPool\">Constant value index(" + n4 + ")</A></UL>\n");
                break;
            }
            case 0: {
                int n5 = ((SourceFile)attribute).getSourceFileIndex();
                this.printWriter.print("<UL><LI><A HREF=\"" + this.className + "_cp.html#cp" + n5 + "\" TARGET=\"ConstantPool\">Source file index(" + n5 + ")</A></UL>\n");
                break;
            }
            case 3: {
                int[] nArray = ((ExceptionTable)attribute).getExceptionIndexTable();
                this.printWriter.print("<UL>");
                for (int n6 : nArray) {
                    this.printWriter.print("<LI><A HREF=\"" + this.className + "_cp.html#cp" + n6 + "\" TARGET=\"ConstantPool\">Exception class index(" + n6 + ")</A>\n");
                }
                this.printWriter.print("</UL>\n");
                break;
            }
            case 4: {
                LineNumber[] lineNumberArray = ((LineNumberTable)attribute).getLineNumberTable();
                this.printWriter.print("<P>");
                for (int i = 0; i < lineNumberArray.length; ++i) {
                    this.printWriter.print("(" + lineNumberArray[i].getStartPC() + ",&nbsp;" + lineNumberArray[i].getLineNumber() + ")");
                    if (i >= lineNumberArray.length - 1) continue;
                    this.printWriter.print(", ");
                }
                break;
            }
            case 5: {
                LocalVariable[] localVariableArray = ((LocalVariableTable)attribute).getLocalVariableTable();
                this.printWriter.print("<UL>");
                for (LocalVariable localVariable : localVariableArray) {
                    int n7 = localVariable.getSignatureIndex();
                    String string2 = ((ConstantUtf8)this.constantPool.getConstant(n7, (byte)1)).getBytes();
                    string2 = Utility.signatureToString(string2, false);
                    int n8 = localVariable.getStartPC();
                    int n9 = n8 + localVariable.getLength();
                    this.printWriter.println("<LI>" + Class2HTML.referenceType(string2) + "&nbsp;<B>" + localVariable.getName() + "</B> in slot %" + localVariable.getIndex() + "<BR>Valid from lines <A HREF=\"" + this.className + "_code.html#code" + n + "@" + n8 + "\" TARGET=Code>" + n8 + "</A> to <A HREF=\"" + this.constantPool + "_code.html#code" + n + "@" + n9 + "\" TARGET=Code>" + n9 + "</A></LI>");
                }
                this.printWriter.print("</UL>\n");
                break;
            }
            case 6: {
                this.printWriter.print("<UL>");
                for (InnerClass innerClass : ((InnerClasses)attribute).getInnerClasses()) {
                    int n10 = innerClass.getInnerNameIndex();
                    String string3 = n10 > 0 ? this.constantPool.getConstantUtf8(n10).getBytes() : "&lt;anonymous&gt;";
                    String string4 = Utility.accessToString(innerClass.getInnerAccessFlags());
                    this.printWriter.print("<LI><FONT COLOR=\"#FF0000\">" + string4 + "</FONT> " + this.constantHtml.referenceConstant(innerClass.getInnerClassIndex()) + " in&nbsp;class " + this.constantHtml.referenceConstant(innerClass.getOuterClassIndex()) + " named " + string3 + "</LI>\n");
                }
                this.printWriter.print("</UL>\n");
                break;
            }
            default: {
                this.printWriter.print("<P>" + attribute);
            }
        }
        this.printWriter.println("</TD></TR>");
        this.printWriter.flush();
    }
}

