/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;

public class Args {
    public static int require(int n, int n2, String string) {
        if (n != n2) {
            throw new ClassFormatException(String.format("%s [Value must be 0: %,d]", string, n));
        }
        return n;
    }

    public static int require0(int n, String string) {
        return Args.require(n, 0, string);
    }

    public static int requireU1(int n, String string) {
        if (n < 0 || n > 255) {
            throw new ClassFormatException(String.format("%s [Value out of range (0 - %,d) for type u1: %,d]", string, 255, n));
        }
        return n;
    }

    public static int requireU2(int n, int n2, int n3, String string) {
        if (n3 > 65535) {
            throw new IllegalArgumentException(String.format("%s programming error: max %,d > %,d", string, n3, 65535));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("%s programming error: min %,d < 0", string, n2));
        }
        if (n < n2 || n > n3) {
            throw new ClassFormatException(String.format("%s [Value out of range (%,d - %,d) for type u2: %,d]", string, n2, 65535, n));
        }
        return n;
    }

    public static int requireU2(int n, int n2, String string) {
        return Args.requireU2(n, n2, 65535, string);
    }

    public static int requireU2(int n, String string) {
        return Args.requireU2(n, 0, string);
    }

    public static int requireU4(int n, int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("%s programming error: min %,d < 0", string, n2));
        }
        if (n < n2) {
            throw new ClassFormatException(String.format("%s [Value out of range (%,d - %,d) for type u2: %,d]", string, n2, Integer.MAX_VALUE, (long)n & 0xFFFFFFFFL));
        }
        return n;
    }

    public static int requireU4(int n, String string) {
        return Args.requireU4(n, 0, string);
    }
}

