/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;

public abstract class Type {
    public static final BasicType VOID = new BasicType(12);
    public static final BasicType BOOLEAN = new BasicType(4);
    public static final BasicType INT = new BasicType(10);
    public static final BasicType SHORT = new BasicType(9);
    public static final BasicType BYTE = new BasicType(8);
    public static final BasicType LONG = new BasicType(11);
    public static final BasicType DOUBLE = new BasicType(7);
    public static final BasicType FLOAT = new BasicType(6);
    public static final BasicType CHAR = new BasicType(5);
    public static final ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final ObjectType CLASS = new ObjectType("java.lang.Class");
    public static final ObjectType STRING = new ObjectType("java.lang.String");
    public static final ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final Type[] NO_ARGS = new Type[0];
    public static final ReferenceType NULL = new ReferenceType(){};
    public static final Type UNKNOWN = new Type(15, "<unknown object>"){};
    private static final ThreadLocal<Integer> CONSUMED_CHARS = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    @Deprecated
    protected byte type;
    @Deprecated
    protected String signature;

    static int consumed(int n) {
        return n >> 2;
    }

    static int encode(int n, int n2) {
        return n2 << 2 | n;
    }

    public static Type[] getArgumentTypes(String string) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        try {
            int n = string.indexOf(40) + 1;
            if (n <= 0) {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            while (string.charAt(n) != ')') {
                arrayList.add(Type.getType(string.substring(n)));
                n += Type.unwrap(CONSUMED_CHARS);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
        Type[] typeArray = new Type[arrayList.size()];
        arrayList.toArray(typeArray);
        return typeArray;
    }

    static int getArgumentTypesSize(String string) {
        int n = 0;
        try {
            int n2 = string.indexOf(40) + 1;
            if (n2 <= 0) {
                throw new ClassFormatException("Invalid method signature: " + string);
            }
            while (string.charAt(n2) != ')') {
                int n3 = Type.getTypeSize(string.substring(n2));
                n += Type.size(n3);
                n2 += Type.consumed(n3);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
        return n;
    }

    public static String getMethodSignature(Type type, Type[] typeArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (typeArray != null) {
            for (Type type2 : typeArray) {
                stringBuilder.append(type2.getSignature());
            }
        }
        stringBuilder.append(')');
        stringBuilder.append(type.getSignature());
        return stringBuilder.toString();
    }

    public static Type getReturnType(String string) {
        try {
            int n = string.lastIndexOf(41) + 1;
            return Type.getType(string.substring(n));
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ClassFormatException("Invalid method signature: " + string, stringIndexOutOfBoundsException);
        }
    }

    static int getReturnTypeSize(String string) {
        int n = string.lastIndexOf(41) + 1;
        return Type.size(Type.getTypeSize(string.substring(n)));
    }

    public static String getSignature(Method method) {
        Class<?>[] classArray;
        StringBuilder stringBuilder = new StringBuilder("(");
        for (Class<?> clazz : classArray = method.getParameterTypes()) {
            stringBuilder.append(Type.getType(clazz).getSignature());
        }
        stringBuilder.append(")");
        stringBuilder.append(Type.getType(method.getReturnType()).getSignature());
        return stringBuilder.toString();
    }

    public static Type getType(Class<?> clazz) {
        Objects.requireNonNull(clazz, "cls");
        if (clazz.isArray()) {
            return Type.getType(clazz.getName());
        }
        if (!clazz.isPrimitive()) {
            return ObjectType.getInstance(clazz.getName());
        }
        if (clazz == Integer.TYPE) {
            return INT;
        }
        if (clazz == Void.TYPE) {
            return VOID;
        }
        if (clazz == Double.TYPE) {
            return DOUBLE;
        }
        if (clazz == Float.TYPE) {
            return FLOAT;
        }
        if (clazz == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (clazz == Byte.TYPE) {
            return BYTE;
        }
        if (clazz == Short.TYPE) {
            return SHORT;
        }
        if (clazz == Long.TYPE) {
            return LONG;
        }
        if (clazz == Character.TYPE) {
            return CHAR;
        }
        throw new IllegalStateException("Unknown primitive type " + clazz);
    }

    public static Type getType(String string) throws StringIndexOutOfBoundsException {
        byte by = Utility.typeOfSignature(string);
        if (by <= 12) {
            Type.wrap(CONSUMED_CHARS, 1);
            return BasicType.getType(by);
        }
        if (by != 13) {
            String string2 = Utility.typeSignatureToString(string, false);
            Type.wrap(CONSUMED_CHARS, string2.length() + 2);
            return ObjectType.getInstance(Utility.pathToPackage(string2));
        }
        int n = 0;
        while (string.charAt(++n) == '[') {
        }
        Type type = Type.getType(string.substring(n));
        int n2 = Type.unwrap(CONSUMED_CHARS) + n;
        Type.wrap(CONSUMED_CHARS, n2);
        return new ArrayType(type, n);
    }

    public static Type[] getTypes(Class<?>[] classArray) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = Type.getType(classArray[i]);
        }
        return typeArray;
    }

    static int getTypeSize(String string) throws StringIndexOutOfBoundsException {
        byte by = Utility.typeOfSignature(string);
        if (by <= 12) {
            return Type.encode(BasicType.getType(by).getSize(), 1);
        }
        if (by == 13) {
            int n = 0;
            while (string.charAt(++n) == '[') {
            }
            int n2 = Type.consumed(Type.getTypeSize(string.substring(n)));
            return Type.encode(1, n + n2);
        }
        int n = string.indexOf(59);
        if (n < 0) {
            throw new ClassFormatException("Invalid signature: " + string);
        }
        return Type.encode(1, n + 1);
    }

    static int size(int n) {
        return n & 3;
    }

    private static int unwrap(ThreadLocal<Integer> threadLocal) {
        return threadLocal.get();
    }

    private static void wrap(ThreadLocal<Integer> threadLocal, int n) {
        threadLocal.set(n);
    }

    protected Type(byte by, String string) {
        this.type = by;
        this.signature = string;
    }

    public boolean equals(Object object) {
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.type == type.type && this.signature.equals(type.signature);
        }
        return false;
    }

    public String getClassName() {
        return this.toString();
    }

    public String getSignature() {
        return this.signature;
    }

    public int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    public byte getType() {
        return this.type;
    }

    public int hashCode() {
        return this.type ^ this.signature.hashCode();
    }

    public Type normalizeForStackOrLocal() {
        if (this == BOOLEAN || this == BYTE || this == SHORT || this == CHAR) {
            return INT;
        }
        return this;
    }

    void setSignature(String string) {
        this.signature = string;
    }

    public String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }
}

