/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class TABLESWITCH
extends Select {
    TABLESWITCH() {
    }

    public TABLESWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)170, nArray, instructionHandleArray, instructionHandle);
        short s = (short)(13 + this.getMatchLength() * 4);
        super.setLength(s);
        this.setFixedLength(s);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackConsumer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitTABLESWITCH(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        int n = this.getMatchLength();
        int n2 = n > 0 ? super.getMatch(0) : 0;
        dataOutputStream.writeInt(n2);
        int n3 = n > 0 ? super.getMatch(n - 1) : 0;
        dataOutputStream.writeInt(n3);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeInt(this.setIndices(i, this.getTargetOffset(super.getTarget(i))));
        }
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.initFromFile(byteSequence, bl);
        int n = byteSequence.readInt();
        int n2 = byteSequence.readInt();
        int n3 = n2 - n + 1;
        this.setMatchLength(n3);
        short s = (short)(13 + n3 * 4);
        this.setFixedLength(s);
        super.setLength((short)(s + super.getPadding()));
        super.setMatches(new int[n3]);
        super.setIndices(new int[n3]);
        super.setTargets(new InstructionHandle[n3]);
        for (int i = 0; i < n3; ++i) {
            super.setMatch(i, n + i);
            super.setIndices(i, byteSequence.readInt());
        }
    }
}

