/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.CompoundInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.LOOKUPSWITCH;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TABLESWITCH;
import java.util.Arrays;

public final class SWITCH
implements CompoundInstruction {
    private final Select instruction;

    private static boolean matchIsOrdered(int[] nArray, int n, int n2) {
        for (int i = 1; i < n; ++i) {
            if (nArray[i] - nArray[i - 1] <= n2) continue;
            return false;
        }
        return true;
    }

    private static void sort(int n, int n2, int[] nArray, InstructionHandle[] instructionHandleArray) {
        int n3 = n;
        int n4 = n2;
        int n5 = nArray[n + n2 >>> 1];
        while (true) {
            if (nArray[n3] < n5) {
                ++n3;
                continue;
            }
            while (n5 < nArray[n4]) {
                --n4;
            }
            if (n3 <= n4) {
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                InstructionHandle instructionHandle = instructionHandleArray[n3];
                instructionHandleArray[n3] = instructionHandleArray[n4];
                instructionHandleArray[n4] = instructionHandle;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            SWITCH.sort(n, n4, nArray, instructionHandleArray);
        }
        if (n3 < n2) {
            SWITCH.sort(n3, n2, nArray, instructionHandleArray);
        }
    }

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        this(nArray, instructionHandleArray, instructionHandle, 1);
    }

    public SWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle, int n) {
        int[] nArray2 = (int[])nArray.clone();
        InstructionHandle[] instructionHandleArray2 = (InstructionHandle[])instructionHandleArray.clone();
        int n2 = nArray.length;
        if (n2 < 2) {
            this.instruction = new TABLESWITCH(nArray, instructionHandleArray, instructionHandle);
        } else {
            SWITCH.sort(0, n2 - 1, nArray2, instructionHandleArray2);
            if (SWITCH.matchIsOrdered(nArray2, n2, n)) {
                int n3 = n2 + n2 * n;
                int[] nArray3 = new int[n3];
                InstructionHandle[] instructionHandleArray3 = new InstructionHandle[n3];
                int n4 = 1;
                nArray3[0] = nArray[0];
                instructionHandleArray3[0] = instructionHandleArray[0];
                for (int i = 1; i < n2; ++i) {
                    int n5 = nArray[i - 1];
                    int n6 = nArray[i] - n5;
                    for (int j = 1; j < n6; ++j) {
                        nArray3[n4] = n5 + j;
                        instructionHandleArray3[n4] = instructionHandle;
                        ++n4;
                    }
                    nArray3[n4] = nArray[i];
                    instructionHandleArray3[n4] = instructionHandleArray[i];
                    ++n4;
                }
                this.instruction = new TABLESWITCH(Arrays.copyOf(nArray3, n4), Arrays.copyOf(instructionHandleArray3, n4), instructionHandle);
            } else {
                this.instruction = new LOOKUPSWITCH(nArray2, instructionHandleArray2, instructionHandle);
            }
        }
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    public InstructionList getInstructionList() {
        return new InstructionList(this.instruction);
    }
}

