/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ClassObserver;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            ClassGen classGen = (ClassGen)object;
            ClassGen classGen2 = (ClassGen)object2;
            return Objects.equals(classGen.getClassName(), classGen2.getClassName());
        }

        @Override
        public int hashCode(Object object) {
            ClassGen classGen = (ClassGen)object;
            return classGen.getClassName().hashCode();
        }
    };
    private String className;
    private String superClassName;
    private final String fileName;
    private int classNameIndex = -1;
    private int superclassNameIndex = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private final List<Field> fieldList = new ArrayList<Field>();
    private final List<Method> methodList = new ArrayList<Method>();
    private final List<Attribute> attributeList = new ArrayList<Attribute>();
    private final List<String> interfaceList = new ArrayList<String>();
    private final List<AnnotationEntryGen> annotationList = new ArrayList<AnnotationEntryGen>();
    private List<ClassObserver> observers;

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public ClassGen(JavaClass javaClass) {
        super(javaClass.getAccessFlags());
        this.classNameIndex = javaClass.getClassNameIndex();
        this.superclassNameIndex = javaClass.getSuperclassNameIndex();
        this.className = javaClass.getClassName();
        this.superClassName = javaClass.getSuperclassName();
        this.fileName = javaClass.getSourceFileName();
        this.cp = new ConstantPoolGen(javaClass.getConstantPool());
        this.major = javaClass.getMajor();
        this.minor = javaClass.getMinor();
        Attribute[] attributeArray = javaClass.getAttributes();
        AnnotationEntryGen[] annotationEntryGenArray = this.unpackAnnotations(attributeArray);
        Collections.addAll(this.interfaceList, javaClass.getInterfaceNames());
        for (Attribute attribute : attributeArray) {
            if (attribute instanceof Annotations) continue;
            this.addAttribute(attribute);
        }
        Collections.addAll(this.annotationList, annotationEntryGenArray);
        Collections.addAll(this.methodList, javaClass.getMethods());
        Collections.addAll(this.fieldList, javaClass.getFields());
    }

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray) {
        this(string, string2, string3, n, stringArray, new ConstantPoolGen());
    }

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray, ConstantPoolGen constantPoolGen) {
        super(n);
        this.className = string;
        this.superClassName = string2;
        this.fileName = string3;
        this.cp = constantPoolGen;
        if (string3 != null) {
            this.addAttribute(new SourceFile(constantPoolGen.addUtf8("SourceFile"), 2, constantPoolGen.addUtf8(string3), constantPoolGen.getConstantPool()));
        }
        this.classNameIndex = constantPoolGen.addClass(string);
        this.superclassNameIndex = constantPoolGen.addClass(string2);
        if (stringArray != null) {
            Collections.addAll(this.interfaceList, stringArray);
        }
    }

    public void addAnnotationEntry(AnnotationEntryGen annotationEntryGen) {
        this.annotationList.add(annotationEntryGen);
    }

    public void addAttribute(Attribute attribute) {
        this.attributeList.add(attribute);
    }

    public void addEmptyConstructor(int n) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(InstructionConst.THIS);
        instructionList.append(new INVOKESPECIAL(this.cp.addMethodref(this.superClassName, "<init>", "()V")));
        instructionList.append(InstructionConst.RETURN);
        MethodGen methodGen = new MethodGen(n, Type.VOID, Type.NO_ARGS, null, "<init>", this.className, instructionList, this.cp);
        methodGen.setMaxStack(1);
        this.addMethod(methodGen.getMethod());
    }

    public void addField(Field field) {
        this.fieldList.add(field);
    }

    public void addInterface(String string) {
        this.interfaceList.add(string);
    }

    public void addMethod(Method method) {
        this.methodList.add(method);
    }

    public void addObserver(ClassObserver classObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList<ClassObserver>();
        }
        this.observers.add(classObserver);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    public boolean containsField(Field field) {
        return this.fieldList.contains(field);
    }

    public Field containsField(String string) {
        for (Field field : this.fieldList) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String string, String string2) {
        for (Method method : this.methodList) {
            if (!method.getName().equals(string) || !method.getSignature().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public AnnotationEntryGen[] getAnnotationEntries() {
        return this.annotationList.toArray(AnnotationEntryGen.EMPTY_ARRAY);
    }

    public Attribute[] getAttributes() {
        return this.attributeList.toArray(Attribute.EMPTY_ARRAY);
    }

    public String getClassName() {
        return this.className;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public Field[] getFields() {
        return this.fieldList.toArray(Field.EMPTY_ARRAY);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceList.toArray(Const.EMPTY_STRING_ARRAY);
    }

    public int[] getInterfaces() {
        int n = this.interfaceList.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.cp.addClass(this.interfaceList.get(i));
        }
        return nArray;
    }

    public JavaClass getJavaClass() {
        Object object;
        int[] nArray = this.getInterfaces();
        Field[] fieldArray = this.getFields();
        Method[] methodArray = this.getMethods();
        Attribute[] attributeArray = null;
        if (this.annotationList.isEmpty()) {
            attributeArray = this.getAttributes();
        } else {
            object = AnnotationEntryGen.getAnnotationAttributes(this.cp, this.getAnnotationEntries());
            attributeArray = new Attribute[this.attributeList.size() + ((Attribute[])object).length];
            this.attributeList.toArray(attributeArray);
            System.arraycopy(object, 0, attributeArray, this.attributeList.size(), ((Attribute[])object).length);
        }
        object = this.cp.getFinalConstantPool();
        return new JavaClass(this.classNameIndex, this.superclassNameIndex, this.fileName, this.major, this.minor, super.getAccessFlags(), (ConstantPool)object, nArray, fieldArray, methodArray, attributeArray);
    }

    public int getMajor() {
        return this.major;
    }

    public Method getMethodAt(int n) {
        return this.methodList.get(n);
    }

    public Method[] getMethods() {
        return this.methodList.toArray(Method.EMPTY_ARRAY);
    }

    public int getMinor() {
        return this.minor;
    }

    public String getSuperclassName() {
        return this.superClassName;
    }

    public int getSuperclassNameIndex() {
        return this.superclassNameIndex;
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    public void removeAttribute(Attribute attribute) {
        this.attributeList.remove(attribute);
    }

    public void removeField(Field field) {
        this.fieldList.remove(field);
    }

    public void removeInterface(String string) {
        this.interfaceList.remove(string);
    }

    public void removeMethod(Method method) {
        this.methodList.remove(method);
    }

    public void removeObserver(ClassObserver classObserver) {
        if (this.observers != null) {
            this.observers.remove(classObserver);
        }
    }

    public void replaceField(Field field, Field field2) {
        if (field2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.fieldList.indexOf(field);
        if (n < 0) {
            this.fieldList.add(field2);
        } else {
            this.fieldList.set(n, field2);
        }
    }

    public void replaceMethod(Method method, Method method2) {
        if (method2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.methodList.indexOf(method);
        if (n < 0) {
            this.methodList.add(method2);
        } else {
            this.methodList.set(n, method2);
        }
    }

    public void setClassName(String string) {
        this.className = Utility.pathToPackage(string);
        this.classNameIndex = this.cp.addClass(string);
    }

    public void setClassNameIndex(int n) {
        this.classNameIndex = n;
        this.className = Utility.pathToPackage(this.cp.getConstantPool().getConstantString(n, (byte)7));
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMethodAt(Method method, int n) {
        this.methodList.set(n, method);
    }

    public void setMethods(Method[] methodArray) {
        this.methodList.clear();
        Collections.addAll(this.methodList, methodArray);
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public void setSuperclassName(String string) {
        this.superClassName = Utility.pathToPackage(string);
        this.superclassNameIndex = this.cp.addClass(string);
    }

    public void setSuperclassNameIndex(int n) {
        this.superclassNameIndex = n;
        this.superClassName = Utility.pathToPackage(this.cp.getConstantPool().getConstantString(n, (byte)7));
    }

    private AnnotationEntryGen[] unpackAnnotations(Attribute[] attributeArray) {
        ArrayList<AnnotationEntryGen> arrayList = new ArrayList<AnnotationEntryGen>();
        for (Attribute attribute : attributeArray) {
            AnnotationEntry[] annotationEntryArray;
            Annotations annotations;
            if (attribute instanceof RuntimeVisibleAnnotations) {
                annotations = (RuntimeVisibleAnnotations)attribute;
                for (AnnotationEntry annotationEntry : annotationEntryArray = annotations.getAnnotationEntries()) {
                    arrayList.add(new AnnotationEntryGen(annotationEntry, this.getConstantPool(), false));
                }
                continue;
            }
            if (!(attribute instanceof RuntimeInvisibleAnnotations)) continue;
            annotations = (RuntimeInvisibleAnnotations)attribute;
            for (AnnotationEntry annotationEntry : annotationEntryArray = annotations.getAnnotationEntries()) {
                arrayList.add(new AnnotationEntryGen(annotationEntry, this.getConstantPool(), false));
            }
        }
        return arrayList.toArray(AnnotationEntryGen.EMPTY_ARRAY);
    }

    public void update() {
        if (this.observers != null) {
            for (ClassObserver classObserver : this.observers) {
                classObserver.notify(this);
            }
        }
    }
}

