/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public final class Unknown
extends Attribute {
    private byte[] bytes;
    private final String name;

    public Unknown(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)-1, n, n2, constantPool);
        this.bytes = byArray;
        this.name = constantPool.getConstantUtf8(n).getBytes();
    }

    Unknown(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInput.readFully(this.bytes);
        }
    }

    public Unknown(Unknown unknown) {
        this(unknown.getNameIndex(), unknown.getLength(), unknown.getBytes(), unknown.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitUnknown(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Unknown unknown = (Unknown)this.clone();
        if (this.bytes != null) {
            unknown.bytes = (byte[])this.bytes.clone();
        }
        unknown.setConstantPool(constantPool);
        return unknown;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (super.getLength() > 0) {
            dataOutputStream.write(this.bytes, 0, super.getLength());
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public String toString() {
        String string;
        if (super.getLength() == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        int n = 10;
        if (super.getLength() > 10) {
            byte[] byArray = Arrays.copyOf(this.bytes, 10);
            string = Utility.toHexString(byArray) + "... (truncated)";
        } else {
            string = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + string + ")";
    }
}

