/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapType
implements Cloneable {
    public static final StackMapType[] EMPTY_ARRAY = new StackMapType[0];
    private byte type;
    private int index = -1;
    private ConstantPool constantPool;

    public StackMapType(byte by, int n, ConstantPool constantPool) {
        this.type = this.checkType(by);
        this.index = n;
        this.constantPool = constantPool;
    }

    StackMapType(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readByte(), -1, constantPool);
        if (this.hasIndex()) {
            this.index = dataInput.readUnsignedShort();
        }
        this.constantPool = constantPool;
    }

    private byte checkType(byte by) {
        if (by < 0 || by > 8) {
            throw new ClassFormatException("Illegal type for StackMapType: " + by);
        }
        return by;
    }

    public StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        if (this.hasIndex()) {
            dataOutputStream.writeShort(this.getIndex());
        }
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getIndex() {
        return this.index;
    }

    public byte getType() {
        return this.type;
    }

    public boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constantPool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setType(byte by) {
        this.type = this.checkType(by);
    }

    public String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }
}

