/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.MethodParameter;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class MethodParameters
extends Attribute
implements Iterable<MethodParameter> {
    private static final MethodParameter[] EMPTY_METHOD_PARAMETER_ARRAY = new MethodParameter[0];
    private MethodParameter[] parameters = EMPTY_METHOD_PARAMETER_ARRAY;

    MethodParameters(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        super((byte)21, n, n2, constantPool);
        int n3 = dataInput.readUnsignedByte();
        this.parameters = new MethodParameter[n3];
        for (int i = 0; i < n3; ++i) {
            this.parameters[i] = new MethodParameter(dataInput);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMethodParameters(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        MethodParameters methodParameters = (MethodParameters)this.clone();
        methodParameters.parameters = new MethodParameter[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            methodParameters.parameters[i] = this.parameters[i].copy();
        }
        methodParameters.setConstantPool(constantPool);
        return methodParameters;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeByte(this.parameters.length);
        for (MethodParameter methodParameter : this.parameters) {
            methodParameter.dump(dataOutputStream);
        }
    }

    public MethodParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public Iterator<MethodParameter> iterator() {
        return Arrays.asList(this.parameters).iterator();
    }

    public void setParameters(MethodParameter[] methodParameterArray) {
        this.parameters = methodParameterArray;
    }
}

