/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantModule;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPackage;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class ConstantPool
implements Cloneable,
Node,
Iterable<Constant> {
    private Constant[] constantPool;

    private static String escape(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 5);
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuilder.append(cArray[i]);
                }
            }
        }
        return stringBuilder.toString();
    }

    public ConstantPool(Constant[] constantArray) {
        this.constantPool = constantArray;
    }

    public ConstantPool(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        this.constantPool = new Constant[n];
        for (int i = 1; i < n; ++i) {
            this.constantPool[i] = Constant.readConstant(dataInput);
            byte by = this.constantPool[i].getTag();
            if (by != 6 && by != 5) continue;
            ++i;
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) throws IllegalArgumentException {
        String string;
        byte by = constant.getTag();
        switch (by) {
            case 7: {
                int n = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstantUtf8(n);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.getConstantUtf8(n);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string = String.valueOf(((ConstantDouble)constant).getBytes());
                break;
            }
            case 4: {
                string = String.valueOf(((ConstantFloat)constant).getBytes());
                break;
            }
            case 5: {
                string = String.valueOf(((ConstantLong)constant).getBytes());
                break;
            }
            case 3: {
                string = String.valueOf(((ConstantInteger)constant).getBytes());
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 15: {
                ConstantMethodHandle constantMethodHandle = (ConstantMethodHandle)constant;
                string = Const.getMethodHandleName(constantMethodHandle.getReferenceKind()) + " " + this.constantToString(constantMethodHandle.getReferenceIndex(), ((Constant)this.getConstant(constantMethodHandle.getReferenceIndex())).getTag());
                break;
            }
            case 16: {
                ConstantMethodType constantMethodType = (ConstantMethodType)constant;
                string = this.constantToString(constantMethodType.getDescriptorIndex(), (byte)1);
                break;
            }
            case 18: {
                ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)constant;
                string = constantInvokeDynamic.getBootstrapMethodAttrIndex() + ":" + this.constantToString(constantInvokeDynamic.getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 17: {
                ConstantDynamic constantDynamic = (ConstantDynamic)constant;
                string = constantDynamic.getBootstrapMethodAttrIndex() + ":" + this.constantToString(constantDynamic.getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 19: {
                int n = ((ConstantModule)constant).getNameIndex();
                constant = this.getConstantUtf8(n);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 20: {
                int n = ((ConstantPackage)constant).getNameIndex();
                constant = this.getConstantUtf8(n);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown constant type " + by);
            }
        }
        return string;
    }

    public String constantToString(int n, byte by) {
        return this.constantToString((Constant)this.getConstant(n, by));
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
            constantPool.constantPool = new Constant[this.constantPool.length];
            for (int i = 1; i < this.constantPool.length; ++i) {
                if (this.constantPool[i] == null) continue;
                constantPool.constantPool[i] = this.constantPool[i].copy();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return constantPool;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n = Math.min(this.constantPool.length, 65535);
        dataOutputStream.writeShort(n);
        for (int i = 1; i < n; ++i) {
            if (this.constantPool[i] == null) continue;
            this.constantPool[i].dump(dataOutputStream);
        }
    }

    public <T extends Constant> T getConstant(int n) throws ClassFormatException {
        return (T)this.getConstant(n, Constant.class);
    }

    public <T extends Constant> T getConstant(int n, byte by) throws ClassFormatException {
        return (T)this.getConstant(n, by, Constant.class);
    }

    public <T extends Constant> T getConstant(int n, byte by, Class<T> clazz) throws ClassFormatException {
        T t = this.getConstant(n);
        if (((Constant)t).getTag() != by) {
            throw new ClassFormatException("Expected class '" + Const.getConstantName(by) + "' at index " + n + " and got " + t);
        }
        return t;
    }

    public <T extends Constant> T getConstant(int n, Class<T> clazz) throws ClassFormatException {
        Constant constant;
        if (n >= this.constantPool.length || n < 0) {
            throw new ClassFormatException("Invalid constant pool reference using index: " + n + ". Constant pool size is: " + this.constantPool.length);
        }
        if (this.constantPool[n] != null && !clazz.isAssignableFrom(this.constantPool[n].getClass())) {
            throw new ClassFormatException("Invalid constant pool reference at index: " + n + ". Expected " + clazz + " but was " + this.constantPool[n].getClass());
        }
        Constant constant2 = (Constant)clazz.cast(this.constantPool[n]);
        if (constant2 == null && n != 0 && ((constant = this.constantPool[n - 1]) == null || constant.getTag() != 6 && constant.getTag() != 5)) {
            throw new ClassFormatException("Constant pool at index " + n + " is null.");
        }
        return (T)constant2;
    }

    public ConstantInteger getConstantInteger(int n) {
        return this.getConstant(n, (byte)3, ConstantInteger.class);
    }

    public Constant[] getConstantPool() {
        return this.constantPool;
    }

    public String getConstantString(int n, byte by) throws IllegalArgumentException {
        int n2;
        switch (by) {
            case 7: {
                n2 = this.getConstant(n, ConstantClass.class).getNameIndex();
                break;
            }
            case 8: {
                n2 = this.getConstant(n, ConstantString.class).getStringIndex();
                break;
            }
            case 19: {
                n2 = this.getConstant(n, ConstantModule.class).getNameIndex();
                break;
            }
            case 20: {
                n2 = this.getConstant(n, ConstantPackage.class).getNameIndex();
                break;
            }
            case 1: {
                return this.getConstantUtf8(n).getBytes();
            }
            default: {
                throw new IllegalArgumentException("getConstantString called with illegal tag " + by);
            }
        }
        return this.getConstantUtf8(n2).getBytes();
    }

    public ConstantUtf8 getConstantUtf8(int n) throws ClassFormatException {
        return this.getConstant(n, (byte)1, ConstantUtf8.class);
    }

    public int getLength() {
        return this.constantPool == null ? 0 : this.constantPool.length;
    }

    @Override
    public Iterator<Constant> iterator() {
        return Arrays.asList(this.constantPool).iterator();
    }

    public void setConstant(int n, Constant constant) {
        this.constantPool[n] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constantPool = constantArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < this.constantPool.length; ++i) {
            stringBuilder.append(i).append(")").append(this.constantPool[i]).append("\n");
        }
        return stringBuilder.toString();
    }
}

