/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayElementValue
extends ElementValue {
    private final ElementValue[] elementValues;

    public ArrayElementValue(int n, ElementValue[] elementValueArray, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 91) {
            throw new ClassFormatException("Only element values of type array can be built with this ctor - type specified: " + n);
        }
        this.elementValues = elementValueArray;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getType());
        dataOutputStream.writeShort(this.elementValues.length);
        for (ElementValue elementValue : this.elementValues) {
            elementValue.dump(dataOutputStream);
        }
    }

    public ElementValue[] getElementValuesArray() {
        return this.elementValues;
    }

    public int getElementValuesArraySize() {
        return this.elementValues.length;
    }

    @Override
    public String stringifyValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.elementValues.length; ++i) {
            stringBuilder.append(this.elementValues[i].stringifyValue());
            if (i + 1 >= this.elementValues.length) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < this.elementValues.length; ++i) {
            stringBuilder.append(this.elementValues[i]);
            if (i + 1 >= this.elementValues.length) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

