/*
 * Decompiled with CFR 0.152.
 */
package com.nubosolutions.pkcs11helper;

import com.nubosolutions.pkcs11helper.Utilities;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PCSCHelper {
    private static Logger a = LogManager.getLogger((String)PCSCHelper.class.getName());
    public byte currentCardType;
    public int index = -1;
    public Card card;
    public CardChannel channel;
    public List<CardTerminal> terminals;
    public final ArrayList<Card> cards = new ArrayList();
    public ArrayList<Byte> cardType;
    private ArrayList<CardTerminal> b;

    public PCSCHelper() {
        a.debug("INICIO PCSCHelper");
        String string = System.getProperty("os.name").toLowerCase();
        a.debug("OS: " + string);
        String string2 = System.getProperty("os.arch").toLowerCase();
        a.debug("Arch: " + string2);
        System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
        if (string.contains("mac")) {
            System.setProperty("sun.security.smartcardio.library", "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC");
        }
        if (string.contains("linux")) {
            System.out.println("sistemaOperativo: " + string);
            Utilities.isLinux = true;
            string = Utilities.getLinuxDistribution().toLowerCase();
            System.out.println("getLinuxDistribution: " + string);
            if (string.contains("ubuntu")) {
                if (!new File("/lib/libpcsclite.so.1").isFile()) {
                    if (string2.contains("64")) {
                        if (new File("/lib/x86_64-linux-gnu/libpcsclite.so.1").isFile()) {
                            System.setProperty("sun.security.smartcardio.library", "/lib/x86_64-linux-gnu/libpcsclite.so.1");
                        } else {
                            System.setProperty("sun.security.smartcardio.library", "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1");
                        }
                    } else if (new File("/lib/i386-linux-gnu/libpcsclite.so.1").isFile()) {
                        System.setProperty("sun.security.smartcardio.library", "/lib/i386-linux-gnu/libpcsclite.so.1");
                    } else {
                        System.setProperty("sun.security.smartcardio.library", "/usr/lib/i386-linux-gnu/libpcsclite.so.1");
                    }
                }
            } else if (string.contains("debian")) {
                if (!new File("/usr/lib/libpcsclite.so.1").isFile()) {
                    if (string2.contains("64")) {
                        System.setProperty("sun.security.smartcardio.library", "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1");
                    } else {
                        System.setProperty("sun.security.smartcardio.library", "/usr/lib/i386-linux-gnu/libpcsclite.so.1");
                    }
                }
            } else if (!string.contains("fedora")) {
                string.contains("openSUSE");
            }
        } else if (string.contains("mac")) {
            Utilities.isMac = true;
        }
        a.debug("FIN PCSCHelper");
    }

    public byte[] toByteArray(ArrayList<Byte> arrayList) {
        byte[] byArray = new byte[arrayList.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = arrayList.get(i2);
        }
        return byArray;
    }

    public int[] toIntArray(ArrayList<Integer> arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = arrayList.get(i2);
        }
        return nArray;
    }

    public ArrayList<Byte> toListByte(char[] cArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            arrayList.add((byte)cArray[i2]);
        }
        return arrayList;
    }

    public ArrayList<Byte> toListByte(byte[] byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            arrayList.add(byArray[i2]);
        }
        return arrayList;
    }

    public ArrayList<CardTerminal> listReaders(byte by) {
        a.debug("INICIO listReaders type=" + by);
        this.b = new ArrayList();
        a.debug("TerminalFactory.getDefault()");
        TerminalFactory terminalFactory = TerminalFactory.getDefault();
        try {
            a.debug("list()");
            this.terminals = terminalFactory.terminals().list();
        }
        catch (CardException cardException) {
            a.error("Exception:", (Throwable)cardException);
            return null;
        }
        this.cardType = new ArrayList();
        for (CardTerminal cardTerminal : this.terminals) {
            try {
                if (!cardTerminal.isCardPresent()) continue;
                a.debug("connect()");
                Card card = cardTerminal.connect("*");
                if (!this.a(card.getATR(), by)) continue;
                this.b.add(cardTerminal);
                this.cards.add(card);
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
            }
        }
        a.debug("FIN listReaders");
        return this.b;
    }

    private boolean a(ATR object, byte by) {
        a.debug("INICIO checkFNMT type: " + by + " ATR: " + Utilities.bytesToHex(((ATR)object).getBytes()));
        boolean bl = true;
        try {
            byte[] byArray = ((ATR)object).getBytes();
            object = byArray;
            short s2 = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getShort(1);
            byte[] byArray2 = new byte[]{67, 69, 82, 69, 83};
            byte[] byArray3 = new byte[]{70, 78, 77, 84};
            byte[] byArray4 = new byte[]{84, 73, 70};
            byte[] byArray5 = new byte[]{68, 78, 73};
            if (s2 == -4352) {
                byte[] byArray6 = new byte[21];
                s2 = ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).getShort(16);
                ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).get(byArray6);
                object = Arrays.copyOfRange(byArray6, 8, 13);
            } else {
                byte[] byArray7 = new byte[20];
                s2 = ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).getShort(15);
                ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).get(byArray7);
                object = Arrays.copyOfRange(byArray7, 7, 12);
            }
            if (Arrays.equals((byte[])object, byArray2) || Arrays.equals(Arrays.copyOf((byte[])object, 4), byArray3)) {
                if (s2 == 1072) {
                    this.cardType.add((byte)2);
                } else if (s2 == 1280) {
                    this.cardType.add((byte)2);
                } else if (s2 == 1376 || s2 == 1381 || s2 == 1382 || s2 == 1392 || s2 == 1393 || s2 == 1408) {
                    this.cardType.add((byte)5);
                } else {
                    this.cardType.add((byte)1);
                }
            } else if (by == 1 && Arrays.equals(Arrays.copyOf((byte[])object, 3), byArray4)) {
                this.cardType.add((byte)3);
            } else if (by == 1 && Arrays.equals(Arrays.copyOf((byte[])object, 3), byArray5)) {
                this.cardType.add((byte)4);
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            a.debug("FIN checkFNMT result = " + exception.toString());
            return false;
        }
        a.debug("FIN checkFNMT result = " + bl);
        return bl;
    }

    public boolean conectar() {
        a.debug("INICIO conectar");
        this.currentCardType = this.cardType.get(this.index);
        try {
            this.card = this.cards.get(this.index);
            a.debug("disconnect");
            this.card.disconnect(true);
            a.debug("connect");
            this.card = this.b.get(this.index).connect("*");
        }
        catch (CardException cardException) {
            a.error("Exception:", (Throwable)cardException);
            return false;
        }
        this.channel = this.card.getBasicChannel();
        a.debug("FIN conectar");
        return this.channel != null;
    }

    public void disconnect() {
        a.debug("INICIO disconnect");
        this.cards.stream().forEach(card -> {
            try {
                card.disconnect(true);
                return;
            }
            catch (CardException cardException) {
                return;
            }
        });
        a.debug("FIN disconnect");
    }

    private byte[] a(short s2) {
        ResponseAPDU responseAPDU;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        byte[] byArray = new byte[]{0, -64, 0, 0, 0};
        arrayList.clear();
        do {
            try {
                byArray[4] = (byte)s2;
                responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
                return null;
            }
            byte[] byArray2 = responseAPDU.getData();
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                arrayList.add(byArray2[i2]);
            }
            s2 = (short)responseAPDU.getSW();
        } while ((short)((short)responseAPDU.getSW() & 0xFF00) == 24832);
        return this.toByteArray(arrayList);
    }

    public short sendAPDU(byte[] byArray, boolean bl) {
        ResponseAPDU responseAPDU;
        block13: {
            a.debug("INICIO sendAPDU");
            a.debug(Utilities.bytesToHex(byArray));
            responseAPDU = null;
            try {
                responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
                if (!this.conectar()) break block13;
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException2) {
                    a.error("Exception:", (Throwable)cardException2);
                    return -1;
                }
            }
        }
        if (responseAPDU == null) {
            return -1;
        }
        if (bl && (short)((short)responseAPDU.getSW() & 0xFF00) != 24832 && (short)responseAPDU.getSW() != -28672) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                a.error("Exception:", (Throwable)interruptedException);
            }
            if (this.conectar()) {
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException) {
                    a.error("Exception:", (Throwable)cardException);
                    return -1;
                }
            }
        }
        if ((short)((short)responseAPDU.getSW() & 0xFF00) != 24832) {
            return (short)responseAPDU.getSW();
        }
        byArray = this.a((short)responseAPDU.getSW());
        if (byArray != null) {
            return -28672;
        }
        return 28416;
    }

    public byte[] sendAPDU_Get(byte[] byArray) {
        ResponseAPDU responseAPDU;
        block13: {
            a.debug("INICIO sendAPDU_Get");
            a.debug(Utilities.bytesToHex(byArray));
            responseAPDU = null;
            try {
                responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
                if (!this.conectar()) break block13;
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException2) {
                    a.error("Exception:", (Throwable)cardException2);
                    return null;
                }
            }
        }
        if (responseAPDU == null) {
            return null;
        }
        if ((short)((short)responseAPDU.getSW() & 0xFF00) != 24832 && (short)responseAPDU.getSW() != -28672) {
            a.debug(String.format("0x%08X", (short)responseAPDU.getSW()));
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                a.error("Exception:", (Throwable)interruptedException);
            }
            if (this.conectar()) {
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException) {
                    a.error("Exception:", (Throwable)cardException);
                    return null;
                }
            }
        }
        if ((short)((short)responseAPDU.getSW() & 0xFF00) == 24832) {
            return this.a((short)responseAPDU.getSW());
        }
        if ((short)responseAPDU.getSW() != -28672) {
            a.debug(String.format("0x%08X", (short)responseAPDU.getSW()));
            return null;
        }
        return responseAPDU.getData();
    }
}

