/*
 * Decompiled with CFR 0.152.
 */
package com.nubosolutions.pkcs11helper;

import com.nubosolutions.pkcs11helper.CeresCommand;
import com.nubosolutions.pkcs11helper.PCSCHelper;
import com.nubosolutions.pkcs11helper.PasswordDialogRunnable;
import com.nubosolutions.pkcs11helper.Utilities;
import java.awt.Frame;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.smartcardio.CardException;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class CeresCommand_v5
extends CeresCommand {
    private a n = new a(this, "7F2181D57F4E818E5F290100420865735443416201187F494F060A04007F000702020202038641040C686D486AF488A25D75E5D8DE627E683FB30380CC2FFE70F0C0805CD18DFD802A976CDE36C699912A3A986BE8C059B529ACF9FCA387FE96C1A30C30622C066C5F2008657344565F4348527F4C0E060904007F0007030102035301835F25060200000103005F24060201000102095F37401D6F426A58326206579B766A6380CFF1F1DBEDD37E86DC8525B13F1180EF5C7C403AA04FD65D9970E887CC9DC3D85248A64A20ED50D998B4F6CA5D6D2EDB4018", "6573544341620118", "7F2181D97F4E81925F2901004208657344565F4348527F494F060A04007F000702020202038641040B2279B59ED4924AEB37D6B57D1643D1963244901B267894D9E757326F2467D72DF2F687AB1C23A53B1FF18E224CA95A058F9E841AA1482ACDA0678C5D54F7085F200C0000000011223344556677887F4C0E060904007F0007030102035301025F25060200000201025F24060201000201015F3740477539FFDF2AE2DD31E2CD91BB5E97A42F82B919598C7E5B04C2F218DAC29B9823E6A5C303CFCC90AEEC777B18DD4E550A52A89069A8E6AE01209D299EBAE3F7", "308201610201003081EC06072A8648CE3D02013081E0020101302C06072A8648CE3D0101022100A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377304404207D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9042026DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B60441048BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997022100A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7020101046D306B020101042023FEB7CB93B85705049B07BB11C3C634FB59443C7D00AFBBBB1A952723E4A849A144034200040B2279B59ED4924AEB37D6B57D1643D1963244901B267894D9E757326F2467D72DF2F687AB1C23A53B1FF18E224CA95A058F9E841AA1482ACDA0678C5D54F708", "657344565F434852", "000000001122334455667788");
    private a o = new a(this, "7f2181df7f4e81985f290100420d657343415f444e4946536601247f494f060a04007f00070202020203864104f073b92829898a2a3dd27a4e441944d499b86f49305a91e55ac7eed31566eb41af90fe11c76808ccfd7190605d36dd52f700f7a5eb9bae9a6d457b4287a2f28b5f200d657344565f444e4946536600247f4c0e060904007f00070301020353017f5f25060204000501045f24060205000501045f3740c10fe5cd25e41a56089b67c69963ae550f5aafa85f4f2cc61d10f0494e61a6ee31b54c92cd77d18ca4110d469286648472e0b5587d09399dd6cae6175940c095", "657343415f444e494653660124", "7f2181de7f4e81975f290100420d657344565f444e4946536600247f494f060a04007f00070202020203864104b9fa296f0119a35232fdccd40ce00c5ce2a1cdbcecb12a58a7b5bbb741cbf8558850fee0d63ecde063a6fd62dcefaa958d755be58738980e83c4ab2568614c155f200c0000000011223344556677887f4c0e060904007f00070301020353013f5f25060204000501045f24060205000501045f3740a234b4cc13a7186ce642ca4a67b21805fd72ff03d9aba568e853e3a54e3fbebbd891af493274779585eb8fea97e32c2dad2b7659bf45ef3b74971ef242d657d2", "308201790201003082010306072a8648ce3d02013081f7020101302c06072a8648ce3d0101022100ffffffff00000001000000000000000000000000ffffffffffffffffffffffff305b0420ffffffff00000001000000000000000000000000fffffffffffffffffffffffc04205ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b031500c49d360886e704936a6678e1139d26b7819f7e900441046b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c2964fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5022100ffffffff00000000ffffffffffffffffbce6faada7179e84f3b9cac2fc632551020101046d306b0201010420293c4e54e79ca2d6d3d5e6cec05a5e9753042e1c225f9732a113696584f67ae8a14403420004b9fa296f0119a35232fdccd40ce00c5ce2a1cdbcecb12a58a7b5bbb741cbf8558850fee0d63ecde063a6fd62dcefaa958d755be58738980e83c4ab2568614c15", "657344565f444e494653660024", "000000001122334455667788");
    private a p = new a(this, "7f2181e37f4e819c5f290100420f455343414453464e4d5445533030307f494f060a04007f000702020202038641048015917f3bf0d3899841bec9a9804257842e91389123c17b9f3fedcd29ece99779bdef63e10df4d00a8b57bd800be900d9b74626422235822634cef90e559a0b5f200f455344564453464e4d5445533030307f4c0e060904007f0007030102035301835f25060204010001055f24060409010000035f3740d1340cc36d501674f1c4abc9c88603e5b803789c40144183d683e9e9434c9e0ce3a4e32b00e8697442b813f76c508dd46dfd5794acf1822b2d5279b1d5804bf6", "455343414453464e4d544553303030", "7f2181e37f4e819c5f290100420f455344564453464e4d5445533030307f494f060a04007f000702020202038641044003ac0b87a0266440e591a4bb3be6ba759e7664258fe64f5b525bc539752f2db6f4b6e2a7cae3fd50abf7988d1c6a67528cdf6cdb1bfd6fc686bba6761bd25f5f200f455353545443464e4d5430303030317f4c0e060904007f0007030102035301025f25060204010001055f24060404010001005f3740d1eca93216be7e79dfedc7a34f2a6e3dd80e13b44ef6b217818048b802cc25e2cb3c8569e833222557ce44944bd89e257e4207296bf58916607cadf2742a1290", "308193020100301306072a8648ce3d020106082a8648ce3d030107047930770201010420eaec9830b5dd1a27a03ffe0c3a7b807fe9a1d0f896786620b228f8f6f3b2f382a00a06082a8648ce3d030107a144034200044003ac0b87a0266440e591a4bb3be6ba759e7664258fe64f5b525bc539752f2db6f4b6e2a7cae3fd50abf7988d1c6a67528cdf6cdb1bfd6fc686bba6761bd25f", "455344564453464e4d544553303030", "455353545443464e4d543030303031");
    private int q = r;
    private static int r = 2;
    private static int s = 3;
    private byte[] t = new byte[]{127, 76, 14, 6, 9, 4, 0, 127, 0, 7, 3, 1, 2, 3, 83, 1, 2};
    private byte[] u = new byte[]{127, 76, 18, 6, 9, 4, 0, 127, 0, 7, 3, 1, 2, 2, 83, 5, 63, -1, -1, -1, -1};
    private byte[] v;
    private byte w = (byte)12;
    private byte x = (byte)12;
    private int y = 8;
    private boolean z;
    private byte[] A;
    private byte[] B;
    private byte[] C;
    private byte[] D = new byte[]{-128, 10, 4, 0, 127, 0, 7, 2, 2, 4, 2, 3};
    private byte[] E = new byte[]{-128, 10, 4, 0, 127, 0, 7, 2, 2, 3, 2, 3};
    private byte[] F;

    public CeresCommand_v5(PCSCHelper pCSCHelper) {
        super(pCSCHelper);
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static byte[] hexStringToByteArray(String string) {
        string = string.replaceAll("\\s+", "");
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            int n3 = i2;
            String string2 = string.substring(n3, n3 + 2);
            byArray[i2 / 2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    @Override
    public byte[] getNumSerie() {
        byte[] byArray = new byte[]{-128, -72, 0, 0, 7};
        this.m[9] = 0;
        a.debug("secChannelEncodeAPDU(commandCanal)");
        CeresCommand_v5 ceresCommand_v5 = this;
        byte[] byArray2 = ceresCommand_v5.c(ceresCommand_v5.b.toListByte(this.m));
        a.debug("sendAPDU_Get");
        byArray2 = this.b.sendAPDU_Get(byArray2);
        a.debug("secChannelDecodeResponse");
        short s2 = this.g(byArray2);
        if (s2 != -28672) {
            return null;
        }
        this.b();
        a.debug("secChannelEncodeAPDU(commandCanal)");
        CeresCommand_v5 ceresCommand_v52 = this;
        byte[] byArray3 = ceresCommand_v52.c(ceresCommand_v52.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        byArray3 = this.b.sendAPDU_Get(byArray3);
        a.debug("secChannelDecodeResponse");
        short s3 = this.g(byArray3);
        this.F = this.b.toByteArray(this.c);
        a.debug(Integer.toHexString(s3));
        if (s3 != -28672) {
            return null;
        }
        this.m[9] = 1;
        a.debug("secChannelEncodeAPDU(commandCanal)");
        CeresCommand_v5 ceresCommand_v53 = this;
        byte[] byArray4 = ceresCommand_v53.c(ceresCommand_v53.b.toListByte(this.m));
        a.debug("sendAPDU_Get");
        byArray4 = this.b.sendAPDU_Get(byArray4);
        a.debug("secChannelDecodeResponse");
        short s4 = this.g(byArray4);
        if (s4 != -28672) {
            return null;
        }
        this.b();
        return this.F;
    }

    @Override
    public byte[] leerEventos() {
        byte[] byArray = new byte[]{-128, 24, 0, 0, 1};
        a.debug("secChannelEncodeAPDU(commandCanal)");
        CeresCommand_v5 ceresCommand_v5 = this;
        byArray = ceresCommand_v5.c(ceresCommand_v5.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        byArray = this.b.sendAPDU_Get(byArray);
        a.debug("secChannelDecodeResponse");
        short s2 = this.g(byArray);
        if (s2 != -28672) {
            return null;
        }
        return this.b.toByteArray(this.c);
    }

    @Override
    public int sendCommandsPinChange(char[] cArray, char[] cArray2) {
        int n2;
        a.debug("INICIO sendCommandsPinChange");
        a.debug("sendAPDU commandSelectMaster");
        short s2 = this.selectMF();
        if (s2 != -28672) {
            a.debug("FIN sendCommandsPinChange");
            return 2;
        }
        if (!this.a()) {
            a.debug("FIN sendCommandsPinChange");
            return 2;
        }
        a.debug("sendAPDU commandSelectPin");
        CeresCommand_v5 ceresCommand_v5 = this;
        ArrayList<Byte> arrayList = this.b.toListByte(ceresCommand_v5.c(ceresCommand_v5.b.toListByte(this.j)));
        CeresCommand_v5 ceresCommand_v52 = this;
        s2 = ceresCommand_v52.g(ceresCommand_v52.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        if (s2 != -28672) {
            a.debug("FIN sendCommandsPinChange");
            return 2;
        }
        arrayList.clear();
        a.debug("sendAPDU commandUnlockPin");
        this.k[0] = -128;
        byte[] byArray = this.k;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte by = byArray[i2];
            arrayList.add(by);
        }
        arrayList.add((byte)(3 + cArray.length + cArray2.length));
        arrayList.add((byte)1);
        arrayList.add((byte)cArray.length);
        for (n2 = 0; n2 < cArray.length; ++n2) {
            arrayList.add((byte)cArray[n2]);
        }
        arrayList.add((byte)cArray2.length);
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            arrayList.add((byte)cArray2[n2]);
        }
        arrayList = this.b.toListByte(this.c(arrayList));
        CeresCommand_v5 ceresCommand_v53 = this;
        short s3 = ceresCommand_v53.g(ceresCommand_v53.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        n2 = s3;
        if (s3 != -28672) {
            a.debug("FIN sendCommandsPinChange");
            return 2;
        }
        a.debug("FIN sendCommandsPinChange");
        return 0;
    }

    @Override
    public int cambiarPIN(Frame object) {
        a.debug("INICIO cambiarPIN");
        Object object2 = new PasswordDialogRunnable((Frame)object, 5, false);
        ((PasswordDialogRunnable)object2).run();
        KeyStore.PasswordProtection passwordProtection = ((PasswordDialogRunnable)object2).getPasswordProtection();
        if (passwordProtection != null) {
            object2 = new PasswordDialogRunnable((Frame)object, 6, true);
            ((PasswordDialogRunnable)object2).run();
            object2 = ((PasswordDialogRunnable)object2).getPasswordProtection();
            if (object2 != null) {
                object = passwordProtection.getPassword();
                object2 = ((KeyStore.PasswordProtection)object2).getPassword();
                int n2 = this.sendCommandsPinChange((char[])object, (char[])object2);
                a.debug("FIN cambiarPIN");
                return n2;
            }
            a.debug("newPasswordProtection = NULL");
            a.debug("FIN cambiarPIN");
            return 1;
        }
        a.debug("passwordProtection = NULL");
        a.debug("FIN cambiarPIN");
        return 1;
    }

    @Override
    public short desbloquearTarjeta(char[] cArray, char[] cArray2) {
        short s2;
        a.debug("INICIO desbloquearTarjeta");
        a.debug("sendAPDU commandSelectMaster");
        short s3 = this.selectMF();
        if (s3 != -28672) {
            a.debug("FIN desbloquearTarjeta");
            return s3;
        }
        if (!this.a()) {
            a.debug("FIN sendCommandsPinChange");
            return s3;
        }
        a.debug("sendAPDU commandSelectPin");
        CeresCommand_v5 ceresCommand_v5 = this;
        ArrayList<Byte> arrayList = this.b.toListByte(ceresCommand_v5.c(ceresCommand_v5.b.toListByte(this.j)));
        CeresCommand_v5 ceresCommand_v52 = this;
        s3 = ceresCommand_v52.g(ceresCommand_v52.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        if (s3 != -28672) {
            a.debug("FIN desbloquearTarjeta");
            return s3;
        }
        arrayList.clear();
        a.debug("sendAPDU commandUnlockCard");
        this.l[0] = -128;
        this.l[2] = 1;
        byte[] byArray = this.l;
        for (int i2 = 0; i2 < 4; ++i2) {
            byte by = byArray[i2];
            arrayList.add(by);
        }
        arrayList.add((byte)(17 + cArray.length));
        for (s2 = 0; s2 < cArray2.length; ++s2) {
            arrayList.add((byte)cArray2[s2]);
        }
        arrayList.add((byte)cArray.length);
        for (s2 = 0; s2 < cArray.length; ++s2) {
            arrayList.add((byte)cArray[s2]);
        }
        a.debug(Utilities.bytesToHex(this.b.toByteArray(arrayList)));
        arrayList = this.b.toListByte(this.c(arrayList));
        CeresCommand_v5 ceresCommand_v53 = this;
        short s4 = ceresCommand_v53.g(ceresCommand_v53.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        s2 = s4;
        if (s4 != -28672) {
            a.debug("FIN desbloquearTarjeta NO OK");
            return s2;
        }
        a.debug("FIN desbloquearTarjeta OK");
        return s2;
    }

    @Override
    public int desbloquearPIN(Frame object) {
        int n2;
        a.debug("INICIO desbloquearPIN");
        PasswordDialogRunnable passwordDialogRunnable = new PasswordDialogRunnable((Frame)object, 2, false);
        passwordDialogRunnable.run();
        KeyStore.PasswordProtection passwordProtection = passwordDialogRunnable.getPasswordProtection();
        if (passwordProtection != null) {
            passwordDialogRunnable = new PasswordDialogRunnable((Frame)object, 6, true);
            passwordDialogRunnable.run();
            object = passwordDialogRunnable.getPasswordProtection();
            n2 = object != null ? (this.desbloquearTarjeta(((KeyStore.PasswordProtection)object).getPassword(), passwordProtection.getPassword()) == -28672 ? 0 : 2) : 1;
        } else {
            n2 = 1;
        }
        a.debug("FIN desbloquearPIN result = " + n2);
        return n2;
    }

    @Override
    public short verifyPIN(KeyStore.PasswordProtection object, byte by) {
        by = 0;
        byte[] byArray = new byte[]{0, 32, 0, -128};
        if (!this.z) {
            this.setEAC2Channel();
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < 4; ++i2) {
            arrayList.add(byArray[i2]);
        }
        char[] cArray = ((KeyStore.PasswordProtection)object).getPassword();
        arrayList.add((byte)cArray.length);
        for (int i3 = 0; i3 < ((KeyStore.PasswordProtection)object).getPassword().length; ++i3) {
            arrayList.add((byte)cArray[i3]);
        }
        if (this.z) {
            this.m[9] = 0;
            a.debug("secChannelEncodeAPDU(commandCanal)");
            CeresCommand_v5 ceresCommand_v5 = this;
            byte[] byArray2 = ceresCommand_v5.c(ceresCommand_v5.b.toListByte(this.m));
            a.debug("sendAPDU_Get");
            object = this.b.sendAPDU_Get(byArray2);
            a.debug("secChannelDecodeResponse");
            short s2 = this.g((byte[])object);
            by = (byte)s2;
            if (s2 != -28672) {
                return -1;
            }
            this.b();
            if (!this.a()) {
                return -1;
            }
            a.debug("secChannelEncodeAPDU(commandVerify)");
            byArray2 = this.c(arrayList);
            a.debug("sendAPDU_Get");
            object = this.b.sendAPDU_Get(byArray2);
            a.debug("secChannelDecodeResponse");
            short s3 = this.g((byte[])object);
            by = (byte)s3;
            if (s3 != -28672) {
                return -1;
            }
            this.m[9] = 1;
            CeresCommand_v5 ceresCommand_v52 = this;
            byArray2 = ceresCommand_v52.c(ceresCommand_v52.b.toListByte(this.m));
            a.debug("sendAPDU_Get");
            object = this.b.sendAPDU_Get(byArray2);
            a.debug("secChannelDecodeResponse");
            short s4 = this.g((byte[])object);
            by = (byte)s4;
            if (s4 != -28672) {
                return -1;
            }
            this.b();
            if (!this.a()) {
                return -1;
            }
        }
        return by;
    }

    @Override
    public short verifyPUK(KeyStore.PasswordProtection passwordProtection, KeyStore.PasswordProtection passwordProtection2, byte by) {
        int n2;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        short s2 = this.selectMF();
        if (s2 != -28672) {
            a.debug("FIN verifyPUK");
            return 2;
        }
        arrayList.clear();
        a.debug("sendAPDU commandSelectPin");
        byte[] byArray = this.j;
        for (n2 = 0; n2 < 7; ++n2) {
            byte by2 = byArray[n2];
            arrayList.add(by2);
        }
        int n3 = this.b.sendAPDU(this.b.toByteArray(arrayList), true);
        if (n3 != -28672) {
            a.debug("FIN verifyPUK");
            return 2;
        }
        arrayList.clear();
        a.debug("sendAPDU commandUnlockCard");
        this.l[0] = -128;
        this.l[2] = 1;
        for (n3 = 0; n3 < 4; ++n3) {
            arrayList.add(this.l[n3]);
        }
        char[] cArray = passwordProtection.getPassword();
        char[] cArray2 = passwordProtection2.getPassword();
        arrayList.add((byte)((byte)cArray.length + 1 + (byte)cArray2.length));
        for (n2 = 0; n2 < passwordProtection.getPassword().length; ++n2) {
            arrayList.add((byte)cArray[n2]);
        }
        arrayList.add((byte)cArray2.length);
        for (n2 = 0; n2 < passwordProtection2.getPassword().length; ++n2) {
            arrayList.add((byte)cArray2[n2]);
        }
        arrayList = this.b.toListByte(this.c(arrayList));
        CeresCommand_v5 ceresCommand_v5 = this;
        short s3 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        a.debug("FIN verifyPUK");
        return s3;
    }

    @Override
    public short verifyInCryptoDF(byte by) {
        short s2 = -1;
        byte[] byArray = new byte[]{0, 32, 0, -128, 0};
        if (!this.z) {
            this.setEAC2Channel();
        }
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < 5; ++i2) {
            arrayList.add(byArray[i2]);
        }
        if (this.z) {
            short s3;
            this.m[9] = 0;
            a.debug("secChannelEncodeAPDU(commandCanal)");
            CeresCommand_v5 ceresCommand_v5 = this;
            byte[] byArray2 = ceresCommand_v5.c(ceresCommand_v5.b.toListByte(this.m));
            a.debug("sendAPDU_Get");
            byArray = this.b.sendAPDU_Get(byArray2);
            a.debug("secChannelDecodeResponse");
            short s4 = this.g(byArray);
            if (s4 != -28672) {
                return -1;
            }
            this.b();
            if (!this.a()) {
                return -1;
            }
            a.debug("secChannelEncodeAPDU(commandVerify)");
            byArray2 = this.c(arrayList);
            a.debug("sendAPDU_Get");
            byte[] byArray3 = this.b.sendAPDU_Get(byArray2);
            a.debug("secChannelDecodeResponse");
            s2 = s3 = this.g(byArray3);
            this.m[9] = 1;
            CeresCommand_v5 ceresCommand_v52 = this;
            byArray2 = ceresCommand_v52.c(ceresCommand_v52.b.toListByte(this.m));
            a.debug("sendAPDU_Get");
            byte[] byArray4 = this.b.sendAPDU_Get(byArray2);
            a.debug("secChannelDecodeResponse");
            short s5 = this.g(byArray4);
            if (s5 != -28672) {
                return -1;
            }
            this.b();
            if (!this.a()) {
                return -1;
            }
        }
        return s2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean trashComposeTC(Frame serializable, KeyStore.PasswordProtection object) {
        int n2;
        a.debug("INICIO trashComposeTC");
        serializable = new ArrayList();
        byte[] byArray = new byte[]{0, -92, 4, 0, 11, 77, 97, 115, 116, 101, 114, 46, 70, 105, 108, 101};
        byte[] byArray2 = new byte[]{0, -92, 0, 0, 2, 96, 97};
        byte[] byArray3 = new byte[]{0, -92, 0, 0, 2, 112, 1};
        byte[] byArray4 = new byte[]{0, -92, 0, 0, 2, 80, 21};
        byte[] byArray5 = new byte[]{0, -92, 0, 0, 2, 80, 51};
        this.verifyPIN((KeyStore.PasswordProtection)object, (byte)0);
        a.debug("sendAPDU selectMF");
        CeresCommand_v5 ceresCommand_v5 = this;
        object = ceresCommand_v5.c(ceresCommand_v5.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        object = this.b.sendAPDU_Get((byte[])object);
        a.debug("secChannelDecodeResponse");
        short s2 = this.g((byte[])object);
        if (s2 != -28672) {
            a.debug("FIN trashComposeTC MO OK");
            return false;
        }
        a.debug("sendAPDU selectGeneralPub");
        CeresCommand_v5 ceresCommand_v52 = this;
        byte[] byArray6 = ceresCommand_v52.c(ceresCommand_v52.b.toListByte(byArray2));
        a.debug("sendAPDU_Get");
        byArray6 = this.b.sendAPDU_Get(byArray6);
        a.debug("secChannelDecodeResponse");
        short s3 = this.g(byArray6);
        if (s3 != -28672) {
            a.debug("FIN trashComposeTC NO OK");
            return false;
        }
        a.debug("sendAPDU_Get selectFiles");
        CeresCommand_v5 ceresCommand_v53 = this;
        byte[] byArray7 = ceresCommand_v53.c(ceresCommand_v53.b.toListByte(byArray3));
        a.debug("sendAPDU_Get");
        byArray7 = this.b.sendAPDU_Get(byArray7);
        a.debug("secChannelDecodeResponse");
        this.g(byArray7);
        if (this.b.currentCardType == 2) {
            while (byArray7 != null && byArray7.length > 0) {
                this.i[8] = byArray3[5];
                this.i[9] = byArray3[6];
                this.i[15] = byArray7[7];
                this.i[16] = byArray7[8];
                for (int i2 = 0; i2 < this.i.length; ++i2) {
                    ((ArrayList)serializable).add(this.i[i2]);
                }
                byArray3[6] = (byte)(byArray3[6] + 1);
                a.debug("sendAPDU_Get selectFiles");
                CeresCommand_v5 ceresCommand_v54 = this;
                byArray7 = ceresCommand_v54.c(ceresCommand_v54.b.toListByte(byArray3));
                a.debug("sendAPDU_Get");
                byArray7 = this.b.sendAPDU_Get(byArray7);
                a.debug("secChannelDecodeResponse");
                this.g(byArray7);
            }
        } else {
            while (byArray7 != null && byArray7.length > 0) {
                byte by = this.h[16];
                this.h[12] = (byte)(((byArray3[5] & 0xF0) >> 4) + 48);
                this.h[13] = (byte)((byArray3[5] & 0xF) + 48);
                this.h[14] = (byte)(((byArray3[6] & 0xF0) >> 4) + 48);
                this.h[15] = (byte)(byArray3[6] & 0xF);
                this.h[15] = this.h[15] < 10 ? (byte)(this.h[15] + 48) : (byte)(this.h[15] + 55);
                this.h[16] = by;
                this.h[21] = byArray7[7];
                this.h[22] = byArray7[8];
                for (n2 = 0; n2 < this.h.length; ++n2) {
                    ((ArrayList)serializable).add(this.h[n2]);
                }
                byArray3[6] = (byte)(byArray3[6] + 1);
                a.debug("sendAPDU_Get selectFiles");
                CeresCommand_v5 ceresCommand_v55 = this;
                byArray7 = ceresCommand_v55.c(ceresCommand_v55.b.toListByte(byArray3));
                a.debug("sendAPDU_Get");
                byArray7 = this.b.sendAPDU_Get(byArray7);
                a.debug("secChannelDecodeResponse");
                this.g(byArray7);
            }
        }
        ((ArrayList)serializable).add((byte)0);
        a.debug("sendAPDU selectMF");
        CeresCommand_v5 ceresCommand_v56 = this;
        byArray7 = ceresCommand_v56.c(ceresCommand_v56.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        byArray7 = this.b.sendAPDU_Get(byArray7);
        a.debug("secChannelDecodeResponse");
        short s4 = this.g(byArray7);
        if (s4 == -28672) {
            a.debug("sendAPDU selectPKCS15");
            CeresCommand_v5 ceresCommand_v57 = this;
            byte[] byArray8 = ceresCommand_v57.c(ceresCommand_v57.b.toListByte(byArray4));
            a.debug("sendAPDU_Get");
            byArray8 = this.b.sendAPDU_Get(byArray8);
            a.debug("secChannelDecodeResponse");
            short s5 = this.g(byArray8);
            if (s5 == -28672) {
                a.debug("sendAPDU selectThrash");
                CeresCommand_v5 ceresCommand_v58 = this;
                byte[] byArray9 = ceresCommand_v58.c(ceresCommand_v58.b.toListByte(byArray5));
                a.debug("sendAPDU_Get");
                byArray9 = this.b.sendAPDU_Get(byArray9);
                a.debug("secChannelDecodeResponse");
                int n3 = this.g(byArray9);
                if (n3 == -28672) {
                    n2 = 0;
                    int n4 = ((ArrayList)serializable).size();
                    while (n2 < n4) {
                        int n5 = n4 - n2;
                        if (256 < n4 - n2) {
                            n5 = 255;
                        }
                        byte[] byArray10 = new byte[n5 + 5];
                        byArray2 = byArray10;
                        byArray10[0] = 0;
                        byArray2[1] = -42;
                        byArray2[2] = (byte)(n2 >> 8 & 0xFF);
                        byArray2[3] = (byte)n2;
                        byArray2[4] = (byte)n5;
                        for (n3 = 0; n3 < n5; ++n3) {
                            byArray2[n3 + 5] = (Byte)((ArrayList)serializable).get(n2 + n3);
                        }
                        a.debug("sendAPDU writeCode");
                        CeresCommand_v5 ceresCommand_v59 = this;
                        byte[] byArray11 = ceresCommand_v59.c(ceresCommand_v59.b.toListByte(byArray2));
                        a.debug("sendAPDU_Get");
                        byArray11 = this.b.sendAPDU_Get(byArray11);
                        a.debug("secChannelDecodeResponse");
                        short s6 = this.g(byArray11);
                        n3 = s6;
                        if (s6 != -28672) {
                            a.debug("FIN trashComposeTC NO OK");
                            return false;
                        }
                        n2 = (short)(n2 + n5);
                    }
                }
            }
        }
        a.debug("FIN trashComposeTC OK");
        return true;
    }

    @Override
    public byte[] LoadDF(short s2) {
        short s3 = 0;
        ArrayList<Byte> arrayList = null;
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        ArrayList<Byte> arrayList3 = null;
        if (this.selectMF() == -28672 && this.a() && this.a(s2)) {
            do {
                try {
                    arrayList = this.a(s3, (short)4);
                }
                catch (CardException cardException) {
                    a.error("Exception:", (Throwable)cardException);
                }
                if (arrayList == null || arrayList.isEmpty() || arrayList.get(0) != 48 && (arrayList.get(0) & 0xF0) != 160) continue;
                s2 = CeresCommand_v5.b(arrayList);
                try {
                    arrayList3 = this.a(s3, s2);
                }
                catch (CardException cardException) {
                    a.error("Exception:", (Throwable)cardException);
                }
                arrayList2.addAll(arrayList3);
                s3 = (short)(s3 + s2);
            } while (arrayList.get(0) == 48 || (arrayList.get(0) & 0xF0) == 160);
        }
        return this.b.toByteArray(arrayList2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean erasePKCS15() {
        a.debug("INICIO erasePKCS15");
        byte[] byArray = new byte[]{0, -92, 4, 0, 11, 77, 97, 115, 116, 101, 114, 46, 70, 105, 108, 101};
        byte[] byArray2 = new byte[]{0, -92, 0, 0, 2, 80, 21};
        byte[] byArray3 = new byte[]{0, -92, 0, 0, 2, 96, 1};
        byte[] byArray4 = new byte[]{0, -92, 0, 0, 2, 96, 2};
        byte[] byArray5 = new byte[]{0, -92, 0, 0, 2, 96, 4};
        byte[] byArray6 = new byte[]{0, -42, 0, 0, 2, 0, 0};
        a.debug("sendAPDU selectMF");
        CeresCommand_v5 ceresCommand_v5 = this;
        byte[] byArray7 = ceresCommand_v5.c(ceresCommand_v5.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        byArray7 = this.b.sendAPDU_Get(byArray7);
        a.debug("secChannelDecodeResponse");
        short s2 = this.g(byArray7);
        if (s2 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU selectPKCS15");
        CeresCommand_v5 ceresCommand_v52 = this;
        byte[] byArray8 = ceresCommand_v52.c(ceresCommand_v52.b.toListByte(byArray2));
        a.debug("sendAPDU_Get");
        byArray8 = this.b.sendAPDU_Get(byArray8);
        a.debug("secChannelDecodeResponse");
        short s3 = this.g(byArray8);
        if (s3 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU selectPrKDF");
        CeresCommand_v5 ceresCommand_v53 = this;
        byte[] byArray9 = ceresCommand_v53.c(ceresCommand_v53.b.toListByte(byArray3));
        a.debug("sendAPDU_Get");
        byArray9 = this.b.sendAPDU_Get(byArray9);
        a.debug("secChannelDecodeResponse");
        short s4 = this.g(byArray9);
        if (s4 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU updateBinary");
        CeresCommand_v5 ceresCommand_v54 = this;
        byte[] byArray10 = ceresCommand_v54.c(ceresCommand_v54.b.toListByte(byArray6));
        a.debug("sendAPDU_Get");
        byArray10 = this.b.sendAPDU_Get(byArray10);
        a.debug("secChannelDecodeResponse");
        short s5 = this.g(byArray10);
        if (s5 != -28672) {
            a.debug("FIN erasePKCS15");
            return false;
        }
        a.debug("sendAPDU selectMF");
        CeresCommand_v5 ceresCommand_v55 = this;
        byte[] byArray11 = ceresCommand_v55.c(ceresCommand_v55.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        byArray11 = this.b.sendAPDU_Get(byArray11);
        a.debug("secChannelDecodeResponse");
        short s6 = this.g(byArray11);
        if (s6 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU selectPKCS15");
        CeresCommand_v5 ceresCommand_v56 = this;
        byte[] byArray12 = ceresCommand_v56.c(ceresCommand_v56.b.toListByte(byArray2));
        a.debug("sendAPDU_Get");
        byArray12 = this.b.sendAPDU_Get(byArray12);
        a.debug("secChannelDecodeResponse");
        short s7 = this.g(byArray12);
        if (s7 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU selectPuKDF");
        CeresCommand_v5 ceresCommand_v57 = this;
        byte[] byArray13 = ceresCommand_v57.c(ceresCommand_v57.b.toListByte(byArray4));
        a.debug("sendAPDU_Get");
        byArray13 = this.b.sendAPDU_Get(byArray13);
        a.debug("secChannelDecodeResponse");
        short s8 = this.g(byArray13);
        if (s8 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU updateBinary");
        CeresCommand_v5 ceresCommand_v58 = this;
        byte[] byArray14 = ceresCommand_v58.c(ceresCommand_v58.b.toListByte(byArray6));
        a.debug("sendAPDU_Get");
        byArray14 = this.b.sendAPDU_Get(byArray14);
        a.debug("secChannelDecodeResponse");
        short s9 = this.g(byArray14);
        if (s9 != -28672) {
            a.debug("FIN erasePKCS15");
            return false;
        }
        a.debug("sendAPDU selectMF");
        CeresCommand_v5 ceresCommand_v59 = this;
        byte[] byArray15 = ceresCommand_v59.c(ceresCommand_v59.b.toListByte(byArray));
        a.debug("sendAPDU_Get");
        byArray15 = this.b.sendAPDU_Get(byArray15);
        a.debug("secChannelDecodeResponse");
        short s10 = this.g(byArray15);
        if (s10 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU selectPKCS15");
        CeresCommand_v5 ceresCommand_v510 = this;
        byte[] byArray16 = ceresCommand_v510.c(ceresCommand_v510.b.toListByte(byArray2));
        a.debug("sendAPDU_Get");
        byArray16 = this.b.sendAPDU_Get(byArray16);
        a.debug("secChannelDecodeResponse");
        short s11 = this.g(byArray16);
        if (s11 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU selectCDF");
        CeresCommand_v5 ceresCommand_v511 = this;
        byte[] byArray17 = ceresCommand_v511.c(ceresCommand_v511.b.toListByte(byArray5));
        a.debug("sendAPDU_Get");
        byArray17 = this.b.sendAPDU_Get(byArray17);
        a.debug("secChannelDecodeResponse");
        short s12 = this.g(byArray17);
        if (s12 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("sendAPDU updateBinary");
        CeresCommand_v5 ceresCommand_v512 = this;
        byte[] byArray18 = ceresCommand_v512.c(ceresCommand_v512.b.toListByte(byArray6));
        a.debug("sendAPDU_Get");
        byArray18 = this.b.sendAPDU_Get(byArray18);
        a.debug("secChannelDecodeResponse");
        short s13 = this.g(byArray18);
        if (s13 != -28672) {
            a.debug("FIN erasePKCS15 NO OK");
            return false;
        }
        a.debug("FIN erasePKCS15 OK");
        return true;
    }

    @Override
    public int deleteKeyFilesUnused(Frame arrayList, KeyStore.PasswordProtection object) {
        a.debug("INICIO deleteKeyFilesUnused");
        int n2 = -1;
        byte[] byArray2 = new byte[]{0, 32, 0, -128};
        byte[] byArray3 = new byte[]{0, -92, 0, 0, 2, 1, 0};
        byte[] byArray4 = new byte[]{-112, 84, -128, 1, 0};
        byte[] byArray5 = new byte[]{-112, 86, -128, 0, 1, 18};
        Object object2 = new byte[]{0, 34, 1, -92, 5, -31, 3, -127, 1, 0};
        ArrayList arrayList2 = new ArrayList();
        try {
            a.debug("getPrKDFInfo");
            ArrayList<CeresCommand.InfoObject> arrayList3 = this.getPrKDFInfo();
            if (arrayList3 != null) {
                arrayList3.stream().map(infoObject -> infoObject.getItem(119)).forEach(byArray -> arrayList2.add(byArray[0]));
            }
            if (object == null) {
                arrayList = new PasswordDialogRunnable((Frame)((Object)arrayList), 5, false);
                ((PasswordDialogRunnable)((Object)arrayList)).run();
                object = ((PasswordDialogRunnable)((Object)arrayList)).getPasswordProtection();
            }
            if (object != null) {
                int n3;
                n2 = 0;
                arrayList = new ArrayList<Byte>();
                for (int i2 = 0; i2 < 4; ++i2) {
                    arrayList.add(byArray2[i2]);
                }
                char[] cArray = ((KeyStore.PasswordProtection)object).getPassword();
                arrayList.add((byte)cArray.length);
                for (n3 = 0; n3 < ((KeyStore.PasswordProtection)object).getPassword().length; ++n3) {
                    arrayList.add((byte)cArray[n3]);
                }
                this.b.conectar();
                a.debug("secChannelEncodeAPDU(commandCanal)");
                CeresCommand_v5 ceresCommand_v5 = this;
                object = ceresCommand_v5.c(ceresCommand_v5.b.toListByte((byte[])object2));
                a.debug("sendAPDU_Get");
                object = this.b.sendAPDU_Get((byte[])object);
                a.debug("secChannelDecodeResponse");
                short s2 = this.g((byte[])object);
                if (s2 != -28672) {
                    return -1;
                }
                this.b();
                if (!this.a()) {
                    return -1;
                }
                a.debug("secChannelEncodeAPDU(commandVerify)");
                byte[] byArray6 = this.c(arrayList);
                a.debug("sendAPDU_Get");
                byArray6 = this.b.sendAPDU_Get(byArray6);
                a.debug("secChannelDecodeResponse");
                this.g(byArray6);
                object2[9] = 1;
                CeresCommand_v5 ceresCommand_v52 = this;
                byArray6 = ceresCommand_v52.c(ceresCommand_v52.b.toListByte((byte[])object2));
                a.debug("sendAPDU_Get");
                byArray6 = this.b.sendAPDU_Get(byArray6);
                a.debug("secChannelDecodeResponse");
                short s3 = this.g(byArray6);
                if (s3 != -28672) {
                    return -1;
                }
                this.b();
                if (!this.a()) {
                    return -1;
                }
                if (s3 == -28672 && s3 == -28672) {
                    for (n3 = 1; n3 < 32; n3 = (int)((byte)(n3 + 1))) {
                        boolean bl = false;
                        for (Byte by : arrayList2) {
                            object2 = by;
                            if (by != n3) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                        byArray4[3] = n3;
                        byArray3[6] = n3;
                        byArray5[3] = n3;
                        a.debug("secChannelEncodeAPDU(selectFileID)");
                        CeresCommand_v5 ceresCommand_v53 = this;
                        Object object3 = ceresCommand_v53.c(ceresCommand_v53.b.toListByte(byArray3));
                        a.debug("sendAPDU_Get");
                        object3 = this.b.sendAPDU_Get((byte[])object3);
                        a.debug("secChannelDecodeResponse");
                        short s4 = this.g((byte[])object3);
                        if (s4 != -28672) continue;
                        a.debug("secChannelEncodeAPDU(getPublicKey)");
                        CeresCommand_v5 ceresCommand_v54 = this;
                        byte[] byArray7 = ceresCommand_v54.c(ceresCommand_v54.b.toListByte(byArray5));
                        a.debug("sendAPDU_Get");
                        byArray7 = this.b.sendAPDU_Get(byArray7);
                        a.debug("secChannelDecodeResponse");
                        short s5 = this.g(byArray7);
                        if (s5 != 27904 && s5 != -28672) continue;
                        a.debug("secChannelEncodeAPDU(commandDeleteKey)");
                        CeresCommand_v5 ceresCommand_v55 = this;
                        byte[] byArray8 = ceresCommand_v55.c(ceresCommand_v55.b.toListByte(byArray4));
                        a.debug("sendAPDU_Get");
                        byArray8 = this.b.sendAPDU_Get(byArray8);
                        a.debug("secChannelDecodeResponse");
                        short s6 = this.g(byArray8);
                        if (s6 != -28672) continue;
                        ++n2;
                    }
                }
            }
        }
        catch (CardException cardException) {
            a.error("Exception:", (Throwable)cardException);
            a.debug("INICIO deleteKeyFilesUnused NO OK");
        }
        a.debug("INICIO deleteKeyFilesUnused OK");
        return n2;
    }

    private boolean a() {
        int n2;
        byte[] byArray = new byte[]{0, -92, 4, 0, 10, -96, 0, 0, 1, 103, 69, 83, 73, 71, 78};
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (n2 = 0; n2 < 15; ++n2) {
            arrayList.add(byArray[n2]);
        }
        if (this.z) {
            arrayList = this.b.toListByte(this.c(arrayList));
            CeresCommand_v5 ceresCommand_v5 = this;
            n2 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        } else {
            n2 = this.b.sendAPDU(this.b.toByteArray(arrayList), false);
        }
        return n2 == -28672;
    }

    @Override
    public short selectMF() {
        short s2;
        byte[] byArray = new byte[]{0, -92, 4, 0, 11, 77, 97, 115, 116, 101, 114, 46, 70, 105, 108, 101};
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (s2 = 0; s2 < 16; ++s2) {
            arrayList.add(byArray[s2]);
        }
        if (this.z) {
            arrayList = this.b.toListByte(this.c(arrayList));
            CeresCommand_v5 ceresCommand_v5 = this;
            s2 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        } else {
            s2 = this.b.sendAPDU(this.b.toByteArray(arrayList), false);
        }
        return s2;
    }

    @Override
    final boolean a(short s2) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        arrayList.add((byte)0);
        arrayList.add((byte)-92);
        arrayList.add((byte)0);
        arrayList.add((byte)0);
        arrayList.add((byte)2);
        arrayList.add((byte)(s2 >> 8 & 0xFF));
        arrayList.add((byte)s2);
        if (this.z) {
            arrayList = this.b.toListByte(this.c(arrayList));
            CeresCommand_v5 ceresCommand_v5 = this;
            s2 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
        } else {
            s2 = this.b.sendAPDU(this.b.toByteArray(arrayList), false);
        }
        return s2 == -28672;
    }

    private boolean a(short s2, byte[] byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        short s3 = (short)byArray.length;
        int n2 = 0;
        do {
            int n3;
            arrayList.clear();
            arrayList.add((byte)0);
            arrayList.add((byte)-42);
            arrayList.add((byte)(s2 >> 8 & 0xFF));
            arrayList.add((byte)s2);
            arrayList.add((byte)(s3 > 231 ? 231 : (int)s3));
            for (n3 = n2; n3 < n2 + ((Byte)arrayList.get(4) & 0xFF); ++n3) {
                arrayList.add(byArray[n3]);
            }
            s3 = (short)(s3 - ((short)((Byte)arrayList.get(4)).byteValue() & 0xFF));
            s2 = (short)(s2 + ((short)((Byte)arrayList.get(4)).byteValue() & 0xFF));
            n2 = (short)(n2 + ((short)((Byte)arrayList.get(4)).byteValue() & 0xFF));
            if (!this.z) {
                n3 = this.b.sendAPDU(this.b.toByteArray(arrayList), true);
            } else {
                arrayList = this.b.toListByte(this.c(arrayList));
                CeresCommand_v5 ceresCommand_v5 = this;
                n3 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList)));
            }
            if (n3 == -28672) continue;
            return false;
        } while (s3 > 0);
        return true;
    }

    @Override
    final ArrayList<Byte> a(short s2, short s3) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        do {
            byte[] byArray;
            arrayList2.clear();
            arrayList2.add((byte)0);
            arrayList2.add((byte)-80);
            arrayList2.add((byte)(s2 >> 8 & 0xFF));
            arrayList2.add((byte)s2);
            arrayList2.add((byte)(s3 > 224 ? 224 : (int)s3));
            if (!this.z) {
                byArray = this.b.sendAPDU_Get(this.b.toByteArray(arrayList2));
            } else {
                arrayList2 = this.b.toListByte(this.c(arrayList2));
                CeresCommand_v5 ceresCommand_v5 = this;
                short s4 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList2)));
                if (s4 != -28672) {
                    return null;
                }
                byArray = Arrays.copyOf(this.b.toByteArray(this.c), this.c.size());
            }
            if (byArray == null) {
                return null;
            }
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                arrayList.add(byArray[i2]);
            }
            s3 = (short)(s3 - (short)byArray.length);
            s2 = (short)(s2 + (short)byArray.length);
        } while (s3 > 0);
        return arrayList;
    }

    @Override
    public byte[] readPKCS15File(short s2) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        short s3 = s2;
        Object object = this;
        if (((CeresCommand_v5)object).a((short)20501) && ((CeresCommand_v5)object).a(s3)) {
            int n2 = 0;
            object = this.b.toByteArray(this.a((short)0, (short)4));
            while (object[0] == 48 || object[0] == -96) {
                CeresCommand.b b2 = this.b((byte[])object);
                int n3 = CeresCommand_v5.c((byte[])object);
                if (n2 + b2.a + n3 > 9216) {
                    n2 = 9216;
                    break;
                }
                object = this.b.toByteArray(this.a((short)(n2 += b2.a + n3), (short)4));
            }
            if (n2 > 0) {
                arrayList = this.a((short)0, (short)n2);
            }
        }
        return this.b.toByteArray(arrayList);
    }

    @Override
    public ArrayList<CeresCommand.InfoObject> getPuKDFInfo() {
        ArrayList<CeresCommand.InfoObject> arrayList = null;
        byte[] byArray = this.readPKCS15File((short)24578);
        if (byArray != null) {
            arrayList = this.e(byArray);
        }
        return arrayList;
    }

    @Override
    public ArrayList<CeresCommand.InfoObject> getPrKDFInfo() {
        ArrayList<CeresCommand.InfoObject> arrayList = null;
        byte[] byArray = this.readPKCS15File((short)24577);
        if (byArray != null) {
            arrayList = this.f(byArray);
        }
        return arrayList;
    }

    @Override
    public ArrayList<CeresCommand.InfoObject> getCDFInfo() {
        ArrayList<CeresCommand.InfoObject> arrayList = null;
        this.readPKCS15File((short)20529);
        byte[] byArray = this.readPKCS15File((short)24580);
        if (byArray != null) {
            arrayList = this.d(byArray);
        }
        return arrayList;
    }

    @Override
    public boolean updateBinaryPKCS15File(ArrayList<CeresCommand.InfoObject> object) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        Iterator<CeresCommand.InfoObject> iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            object = ((CeresCommand.InfoObject)object).a;
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((byte)object[i2]);
            }
        }
        arrayList.add((byte)0);
        this.a((short)0, this.b.toByteArray(arrayList));
        return true;
    }

    private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        AESEngine aESEngine = new AESEngine();
        aESEngine = new CMac((BlockCipher)aESEngine);
        aESEngine.init((CipherParameters)new KeyParameter(byArray2));
        if (byArray3 != null) {
            aESEngine.update(byArray3, 0, byArray3.length);
        }
        aESEngine.update(byArray, 0, byArray.length);
        byArray = new byte[aESEngine.getMacSize()];
        aESEngine.doFinal(byArray, 0);
        return Arrays.copyOf(byArray, this.y);
    }

    private byte[] a(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[16];
        Arrays.fill(byArray3, (byte)0);
        if (byArray2.length != 16 && byArray2.length != 24) {
            return null;
        }
        return CeresCommand_v5.b(byArray, byArray2, byArray3);
    }

    private static byte[] b(byte[] byArray, byte[] object, byte[] object2) {
        try {
            object2 = new IvParameterSpec((byte[])object2);
            object = new SecretKeySpec((byte[])object, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(1, (Key)object, (AlgorithmParameterSpec)object2);
            return cipher.doFinal(byArray);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            a.error("Exception: ", (Throwable)generalSecurityException);
            return null;
        }
    }

    private static byte[] c(byte[] byArray, byte[] object, byte[] object2) {
        try {
            object2 = new IvParameterSpec((byte[])object2);
            object = new SecretKeySpec((byte[])object, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)object, (AlgorithmParameterSpec)object2);
            return cipher.doFinal(byArray);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            a.error("Exception: ", (Throwable)generalSecurityException);
            return null;
        }
    }

    private byte[] c(ArrayList<Byte> arrayList) {
        Object object;
        a.debug("INICIO secChannelEncodeAPDU");
        a.debug(Utilities.bytesToHex(this.b.toByteArray(arrayList)));
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        this.c = this.b.toListByte(Arrays.copyOfRange(this.b.toByteArray(arrayList), 5, arrayList.size()));
        this.d = new ArrayList();
        int n2 = new BigInteger(this.g).intValue();
        byte[] byArray = BigInteger.valueOf(++n2).toByteArray();
        System.arraycopy(byArray, 0, this.g, this.g.length - byArray.length, byArray.length);
        int n3 = arrayList.get(4) & 0xFF;
        if (!this.c.isEmpty()) {
            if (n3 != this.c.size()) {
                int n4 = ((Byte)this.c.get(0) << 8) + (Byte)this.c.get(1);
                if (n3 != 0 || this.c.size() <= 2 || n4 != this.c.size() - 2) {
                    return null;
                }
                this.c.remove(0);
                this.c.remove(0);
                this.c.remove(0);
            }
            CeresCommand_v5.a((ArrayList<Byte>)this.c, 16);
            object = new byte[this.g.length];
            for (n3 = 0; n3 < this.g.length; ++n3) {
                object[n3] = this.g[n3];
            }
            object = this.a((byte[])object, this.e);
            this.c = this.b.toListByte(CeresCommand_v5.b(this.b.toByteArray(this.c), this.e, (byte[])object));
            if (arrayList.get(1) % 2 != 0) {
                CeresCommand_v5.a((byte)-123, this.c);
            } else {
                this.c.add(0, (byte)1);
                CeresCommand_v5.a((byte)-121, this.c);
            }
        } else if (n3 > 0) {
            this.c.add((byte)n3);
            CeresCommand_v5.a((byte)-105, this.c);
        }
        object = new ArrayList<Byte>();
        ((ArrayList)object).add((byte)(arrayList.get(0) | 0xC));
        for (n3 = 1; n3 < 4; ++n3) {
            ((ArrayList)object).add(arrayList.get(n3));
        }
        CeresCommand_v5.a((ArrayList<Byte>)object, 16);
        if (!this.c.isEmpty()) {
            this.c.stream().forEach(arg_0 -> CeresCommand_v5.c((ArrayList)object, arg_0));
            CeresCommand_v5.a((ArrayList<Byte>)object, 16);
        }
        CeresCommand_v5 ceresCommand_v5 = this;
        this.d = this.b.toListByte(ceresCommand_v5.a(ceresCommand_v5.b.toByteArray((ArrayList<Byte>)object), this.f, this.g));
        CeresCommand_v5.a((byte)-114, this.d);
        arrayList2.add((byte)(arrayList.get(0) | 0xC));
        for (n3 = 1; n3 < 4; ++n3) {
            arrayList2.add(arrayList.get(n3));
        }
        if (this.c.size() + this.d.size() < 256) {
            arrayList2.add((byte)(this.c.size() + this.d.size()));
        } else {
            arrayList2.add((byte)0);
            arrayList2.add((byte)(this.c.size() + this.d.size() >> 8));
            arrayList2.add((byte)(this.c.size() + this.d.size()));
        }
        this.c.stream().forEach(by -> arrayList2.add(Byte.valueOf(by)));
        this.d.stream().forEach(by -> arrayList2.add(Byte.valueOf(by)));
        return this.b.toByteArray(arrayList2);
    }

    private short g(byte[] byArray) {
        CeresCommand.b b2;
        try {
            b2 = this.a(byArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception: ", (Throwable)pKCS11Exception);
            return -1;
        }
        int n2 = b2.b;
        int n3 = b2.a;
        byte by = b2.c;
        this.c.clear();
        if (by == -121 || by == -123) {
            if (by == -121) {
                if (n3 % 16 != 1 || byArray[n2] != 1) {
                    return -1;
                }
                this.c = this.b.toListByte(Arrays.copyOfRange(byArray, n2 + 1, n2 + n3));
            } else {
                if (n3 % 16 != 0) {
                    return -1;
                }
                int n4 = n2;
                this.c = this.b.toListByte(Arrays.copyOfRange(byArray, n4, n4 + n3));
            }
            n2 += n3;
            try {
                b2 = this.a(Arrays.copyOfRange(byArray, n2, byArray.length));
            }
            catch (PKCS11Exception pKCS11Exception) {
                a.error("Exception: ", (Throwable)pKCS11Exception);
            }
            n2 += b2.b;
            n3 = b2.a;
            by = b2.c;
        }
        if (by != -103) {
            return -1;
        }
        if (n3 != 2) {
            return -1;
        }
        short s2 = (short)((short)(byArray[n2] << 8) & 0xFF00);
        s2 = (short)(s2 + ((short)byArray[n2 + 1] & 0xFF));
        ArrayList<Byte> arrayList = this.b.toListByte(Arrays.copyOfRange(byArray, 0, n2 += n3));
        CeresCommand_v5.a(arrayList, 16);
        try {
            b2 = this.a(Arrays.copyOfRange(byArray, n2, byArray.length));
        }
        catch (PKCS11Exception pKCS11Exception) {
            a.error("Exception: ", (Throwable)pKCS11Exception);
        }
        n2 += b2.b;
        n3 = b2.a;
        int n5 = b2.c;
        if (n5 != -114) {
            return -1;
        }
        if (n3 != 8) {
            return -1;
        }
        n5 = new BigInteger(this.g).intValue();
        byte[] byArray2 = BigInteger.valueOf(++n5).toByteArray();
        System.arraycopy(byArray2, 0, this.g, this.g.length - byArray2.length, byArray2.length);
        CeresCommand_v5 ceresCommand_v5 = this;
        this.d = this.b.toListByte(ceresCommand_v5.a(ceresCommand_v5.b.toByteArray(arrayList), this.f, this.g));
        if (!Arrays.equals(this.b.toByteArray(this.d), Arrays.copyOfRange(byArray, n2, byArray.length))) {
            return -1;
        }
        if (this.c != null && !this.c.isEmpty()) {
            byArray = new byte[this.g.length];
            for (int i2 = 0; i2 < this.g.length; ++i2) {
                byArray[i2] = this.g[i2];
            }
            byArray = this.a(byArray, this.e);
            this.c = this.b.toListByte(CeresCommand_v5.c(this.b.toByteArray(this.c), this.e, byArray));
            this.c = this.a(this.c);
        } else {
            this.c.clear();
        }
        return s2;
    }

    private void b() {
        byte[] byArray = this.e;
        byte[] byArray2 = this.f;
        byte[] byArray3 = this.g;
        this.e = this.A;
        this.f = this.B;
        this.g = this.C;
        this.A = byArray;
        this.B = byArray2;
        this.C = byArray3;
    }

    public int setEAC2Channel() {
        int n2;
        Object object = new b(this);
        Object object2 = new ArrayList<Byte>();
        for (int i2 = 0; i2 < 32; ++i2) {
            ((ArrayList)object2).add((byte)0);
        }
        try {
            int n3;
            ArrayList<Byte> arrayList = this;
            Object object3 = new byte[]{-128, -72, 0, 0, 7};
            ((CeresCommand_v5)((Object)arrayList)).e = new byte[24];
            ((CeresCommand_v5)((Object)arrayList)).f = new byte[24];
            ((CeresCommand_v5)((Object)arrayList)).g = new byte[16];
            Arrays.fill(((CeresCommand_v5)((Object)arrayList)).e, (byte)0);
            Arrays.fill(((CeresCommand_v5)((Object)arrayList)).f, (byte)0);
            Arrays.fill(((CeresCommand_v5)((Object)arrayList)).g, (byte)0);
            ((CeresCommand_v5)((Object)arrayList)).z = false;
            ((CeresCommand_v5)((Object)arrayList)).F = ((CeresCommand_v5)((Object)arrayList)).b.sendAPDU_Get((byte[])object3);
            if (!this.a("Master.File")) {
                return 0;
            }
            this.a((short)12040);
            arrayList = this.a((short)2, (short)6);
            ArrayList<Byte> arrayList2 = arrayList;
            object2 = this.a(arrayList2, arrayList2.size());
            if (object2 == null) {
                return -1;
            }
            object3 = object;
            arrayList = this;
            if (Arrays.equals(Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.b), ((CeresCommand_v5)((Object)arrayList)).v)) {
                a.debug("INICIO loadChannelData datosCanal_EAC2ST_TEST_BP");
                object3.a = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.a);
                object3.b = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.b);
                object3.c = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.c);
                object3.d = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.d);
                object3.e = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.e);
                object3.f = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).n.f);
                ((CeresCommand_v5)((Object)arrayList)).w = (byte)13;
            } else if (Arrays.equals(Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.b), ((CeresCommand_v5)((Object)arrayList)).v)) {
                a.debug("INICIO loadChannelData datosCanal_EAC2ST_TEST_NIST");
                object3.a = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.a);
                object3.b = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.b);
                object3.c = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.c);
                object3.d = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.d);
                object3.e = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.e);
                object3.f = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).o.f);
            } else if (Arrays.equals(Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.b), ((CeresCommand_v5)((Object)arrayList)).v)) {
                a.debug("INICIO loadChannelData datosCanal_EAC2ST");
                object3.a = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.a);
                object3.b = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.b);
                object3.c = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.c);
                object3.d = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.d);
                object3.e = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.e);
                object3.f = Utilities.decodeHexString(((CeresCommand_v5)((Object)arrayList)).p.f);
            }
            arrayList = this.b.toListByte(((b)object).b);
            if (!this.d(arrayList)) {
                return -1;
            }
            arrayList = this.b.toListByte(((b)object).a);
            if (!this.e(arrayList)) {
                return -1;
            }
            arrayList = this.b.toListByte(((b)object).e);
            if (!this.d(arrayList)) {
                return -1;
            }
            arrayList = this.b.toListByte(((b)object).c);
            if (!this.e(arrayList)) {
                return -1;
            }
            arrayList = this.b.toListByte(((b)object).f);
            if (!this.d(arrayList)) {
                return -1;
            }
            CeresCommand_v5 ceresCommand_v5 = this;
            object3 = ceresCommand_v5.a(ceresCommand_v5.w);
            Object object4 = this.a((ECCurve)object3.a, object3.b, object3.c);
            ((c)object4).a.getEncoded(false);
            byte[] byArray = ((c)object4).a.getEncoded(false);
            object4 = byArray;
            object4 = Arrays.copyOfRange(byArray, 1, 1 + (((Object)object4).length - 1) / 2);
            ArrayList<Byte> arrayList3 = new ArrayList<Byte>();
            arrayList3.add((byte)0);
            arrayList3.add((byte)34);
            arrayList3.add((byte)-127);
            arrayList3.add((byte)-92);
            new ArrayList();
            new ArrayList();
            int n4 = arrayList.size() + 2 + ((Object)object4).length + 2;
            byte[] byArray2 = new byte[n4];
            byte[] byArray3 = byArray2;
            byArray2[0] = -125;
            byArray3[1] = (byte)arrayList.size();
            System.arraycopy(this.b.toByteArray(arrayList), 0, byArray3, 2, arrayList.size());
            byArray3[arrayList.size() + 2] = -111;
            byArray3[arrayList.size() + 3] = (byte)((Object)object4).length;
            System.arraycopy(object4, 0, byArray3, arrayList.size() + 4, ((Object)object4).length);
            arrayList = this.b.toListByte(byArray3);
            if (n4 < 250) {
                arrayList3.add((byte)n4);
            } else {
                arrayList3.add((byte)0);
                arrayList3.add((byte)(n4 / 256));
                arrayList3.add((byte)(n4 % 256));
            }
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                arrayList3.add(arrayList.get(n4));
            }
            if (this.z) {
                arrayList3 = this.b.toListByte(this.c(arrayList3));
            }
            CeresCommand_v5 ceresCommand_v52 = this;
            short s2 = ceresCommand_v52.g(ceresCommand_v52.b.sendAPDU_Get(this.b.toByteArray(arrayList3)));
            n4 = s2;
            if (s2 != -28672) {
                return -1;
            }
            arrayList = (ArrayList<Byte>)new byte[]{0, -124, 0, 0, 8};
            CeresCommand_v5 ceresCommand_v53 = this;
            arrayList = (ArrayList<Byte>)ceresCommand_v53.c(ceresCommand_v53.b.toListByte((byte[])arrayList));
            arrayList = (ArrayList<Byte>)this.b.sendAPDU_Get((byte[])arrayList);
            n4 = this.g((byte[])arrayList);
            arrayList = (ArrayList<Byte>)Arrays.copyOf(this.b.toByteArray(this.c), this.c.size());
            if (n4 != -28672) {
                return -1;
            }
            arrayList3 = new ArrayList();
            for (n4 = 0; n4 < ((ArrayList)object2).size(); ++n4) {
                arrayList3.add((Byte)((ArrayList)object2).get(n4));
            }
            for (n4 = 0; n4 < ((Object)arrayList).length; ++n4) {
                arrayList3.add((byte)arrayList[n4]);
            }
            for (n4 = 0; n4 < ((Object)object4).length; ++n4) {
                arrayList3.add((byte)object4[n4]);
            }
            byte[] byArray4 = CeresCommand_v5.b(((b)object).d, this.b.toByteArray(arrayList3));
            object2 = this.extractR(byArray4);
            arrayList = (ArrayList<Byte>)this.extractS(byArray4);
            object = new ArrayList<Byte>();
            ((ArrayList)object).add((byte)0);
            ((ArrayList)object).add((byte)-126);
            ((ArrayList)object).add((byte)0);
            ((ArrayList)object).add((byte)0);
            ((ArrayList)object).add((byte)(((Object)object2).length + ((Object)arrayList).length));
            for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
                ((ArrayList)object).add((byte)object2[n3]);
            }
            for (n3 = 0; n3 < ((Object)arrayList).length; ++n3) {
                ((ArrayList)object).add((byte)arrayList[n3]);
            }
            if (this.z) {
                object = this.b.toListByte(this.c((ArrayList<Byte>)object));
            }
            CeresCommand_v5 ceresCommand_v54 = this;
            short s3 = ceresCommand_v54.g(ceresCommand_v54.b.sendAPDU_Get(this.b.toByteArray((ArrayList<Byte>)object)));
            if (s3 != -28672) {
                return -1;
            }
            object = this.a((ECCurve)object3.a, object3.b, object3.c);
            byte[] byArray5 = ((c)object).a.getEncoded(false);
            object2 = new byte[]{-128, 86, 64, 31, 1, -122};
            if (this.z) {
                CeresCommand_v5 ceresCommand_v55 = this;
                object2 = ceresCommand_v55.c(ceresCommand_v55.b.toListByte((byte[])object2));
            }
            CeresCommand_v5 ceresCommand_v56 = this;
            s3 = ceresCommand_v56.g(ceresCommand_v56.b.sendAPDU_Get((byte[])object2));
            if (s3 != -28672) {
                return -1;
            }
            byte[] byArray6 = Arrays.copyOf(this.b.toByteArray(this.c), this.c.size());
            object2 = byArray6;
            byte[] byArray7 = new byte[byArray6.length + 1];
            arrayList = (ArrayList<Byte>)byArray7;
            byArray7[0] = 4;
            System.arraycopy(object2, 0, arrayList, 1, ((Object)object2).length);
            object2 = object3.a.decodePoint((byte[])arrayList);
            object = object3.a.getMultiplier().multiply((ECPoint)object2, ((c)object).b);
            object = object.getEncoded(false);
            CeresCommand_v5 ceresCommand_v57 = this;
            n2 = ceresCommand_v57.a(ceresCommand_v57.b.toListByte(byArray5), Arrays.copyOfRange((byte[])object, 1, 1 + ((Object)object).length / 2));
        }
        catch (Exception exception) {
            return -1;
        }
        return n2;
    }

    private int a(ArrayList<Byte> arrayList, byte[] byArray) {
        int n2;
        int n3;
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        Object object = new ArrayList<Byte>();
        Object object2 = "Master.File";
        ((ArrayList)object).add((byte)0);
        ((ArrayList)object).add((byte)-92);
        ((ArrayList)object).add((byte)4);
        ((ArrayList)object).add((byte)0);
        ((ArrayList)object).add((byte)((String)object2).length());
        object2 = ((String)object2).toCharArray();
        for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
            ((ArrayList)object).add((byte)object2[n3]);
        }
        if (this.z) {
            object = this.b.toListByte(this.c((ArrayList<Byte>)object));
        }
        CeresCommand_v5 ceresCommand_v5 = this;
        short s2 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray((ArrayList<Byte>)object)));
        n3 = s2;
        if (s2 != -28672) {
            return -1;
        }
        object = new ArrayList<Byte>();
        ((ArrayList)object).add((byte)0);
        ((ArrayList)object).add((byte)34);
        ((ArrayList)object).add((byte)65);
        ((ArrayList)object).add((byte)-92);
        object2 = new byte[]{-128, 10, 4, 0, 127, 0, 7, 2, 2, 3, 2, 3};
        byte[] byArray2 = new byte[]{-124, 2, 3, 31};
        Object object3 = new byte[]{-32, 3, -127, 1, 1};
        ((ArrayList)object).add((byte)21);
        for (n2 = 0; n2 < 12; ++n2) {
            ((ArrayList)object).add((byte)object2[n2]);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            ((ArrayList)object).add(byArray2[n2]);
        }
        for (n2 = 0; n2 < 5; ++n2) {
            ((ArrayList)object).add(object3[n2]);
        }
        try {
            int n4;
            int n5;
            if (this.z) {
                object = this.b.toListByte(this.c((ArrayList<Byte>)object));
            }
            CeresCommand_v5 ceresCommand_v52 = this;
            short s3 = ceresCommand_v52.g(ceresCommand_v52.b.sendAPDU_Get(this.b.toByteArray((ArrayList<Byte>)object)));
            if (s3 != -28672) {
                return -1;
            }
            object = new ArrayList<Byte>();
            ((ArrayList)object).add((byte)0);
            ((ArrayList)object).add((byte)-122);
            ((ArrayList)object).add((byte)0);
            ((ArrayList)object).add((byte)0);
            int n6 = arrayList.size() % 2 != 0 ? 1 : 0;
            if (n6 != 0 && arrayList.get(0) != 4) {
                return 32;
            }
            if (n6 == 0) {
                arrayList2.add((byte)4);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                arrayList2.add(arrayList.get(n2));
            }
            CeresCommand_v5.a((byte)-128, arrayList2);
            CeresCommand_v5.a((byte)124, arrayList2);
            ((ArrayList)object).add((byte)arrayList2.size());
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                ((ArrayList)object).add((Byte)arrayList2.get(n2));
            }
            if (this.z) {
                object = this.b.toListByte(this.c((ArrayList<Byte>)object));
            }
            CeresCommand_v5 ceresCommand_v53 = this;
            s3 = ceresCommand_v53.g(ceresCommand_v53.b.sendAPDU_Get(this.b.toByteArray((ArrayList<Byte>)object)));
            if (s3 != -28672) {
                return -1;
            }
            byte[] byArray3 = Arrays.copyOf(this.b.toByteArray(this.c), this.c.size());
            object = this.a(Arrays.copyOfRange(byArray3, 2, byArray3.length));
            if (((CeresCommand.b)object).c != -127) {
                return -1;
            }
            int n7 = n6 = 2 + ((CeresCommand.b)object).b;
            byte[] byArray4 = Arrays.copyOfRange(byArray3, n7, n7 + ((CeresCommand.b)object).a);
            object = this.a(Arrays.copyOfRange(byArray3, n6 += ((CeresCommand.b)object).a, byArray3.length));
            if (((CeresCommand.b)object).c != -126) {
                return -1;
            }
            int n8 = n6 += ((CeresCommand.b)object).b;
            byte[] byArray5 = Arrays.copyOfRange(byArray3, n8, n8 + ((CeresCommand.b)object).a);
            this.b();
            object = new byte[]{0, 0, 0, 1};
            object3 = new ArrayList();
            for (n5 = 0; n5 < byArray.length; ++n5) {
                ((ArrayList)object3).add(byArray[n5]);
            }
            for (n5 = 0; n5 < byArray4.length; ++n5) {
                ((ArrayList)object3).add(byArray4[n5]);
            }
            for (n5 = 0; n5 < 4; ++n5) {
                ((ArrayList)object3).add((byte)object[n5]);
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byArray = messageDigest.digest(this.b.toByteArray((ArrayList<Byte>)object3));
            this.e = Arrays.copyOfRange(byArray, 0, 24);
            Object object4 = object3;
            ((ArrayList)object4).set(((ArrayList)object4).size() - 1, (byte)2);
            byArray = messageDigest.digest(this.b.toByteArray((ArrayList<Byte>)object3));
            this.f = Arrays.copyOfRange(byArray, 0, 24);
            this.g = new byte[16];
            for (int i2 = 0; i2 < 16; ++i2) {
                this.g[i2] = 0;
            }
            ArrayList<Byte> arrayList3 = new ArrayList<Byte>();
            for (n4 = 2; n4 < this.E.length; ++n4) {
                arrayList3.add(this.E[n4]);
            }
            CeresCommand_v5.a((byte)6, arrayList3);
            arrayList2.clear();
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                arrayList2.add(arrayList.get(n4));
            }
            CeresCommand_v5.a((byte)-122, arrayList2);
            for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                arrayList3.add(arrayList2.get(n4));
            }
            CeresCommand_v5.a((byte)73, arrayList3);
            arrayList3.add(0, (byte)127);
            CeresCommand_v5 ceresCommand_v54 = this;
            byte[] byArray6 = ceresCommand_v54.a(ceresCommand_v54.b.toByteArray(arrayList3), this.f, null);
            if (!Arrays.equals(byArray6, byArray5)) {
                return -1;
            }
            this.z = true;
        }
        catch (NoSuchAlgorithmException | PKCS11Exception exception) {
            return 5;
        }
        return 0;
    }

    private ArrayList<Byte> a(ArrayList<Byte> arrayList, long l2) {
        if (arrayList == null || l2 == 0L) {
            return null;
        }
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        try {
            int n2;
            int n3;
            int n4;
            byte[] byArray = new byte[]{0, 0, 0, 3};
            Object object = new byte[]{-125, 1, 2};
            byte[] byArray2 = new byte[]{-124, 1};
            long l3 = this.D.length + 3 + 2 + 1;
            byte[] byArray3 = new byte[]{0, 34, -63, -92};
            for (n4 = 0; n4 < 4; ++n4) {
                arrayList2.add(byArray3[n4]);
            }
            arrayList2.add((byte)l3);
            for (n4 = 0; n4 < this.D.length; ++n4) {
                arrayList2.add(this.D[n4]);
            }
            for (n4 = 0; n4 < 3; ++n4) {
                arrayList2.add(object[n4]);
            }
            if (this.q == r) {
                for (n4 = 0; n4 < this.t.length; ++n4) {
                    arrayList2.add(this.t[n4]);
                }
                l3 += (long)this.t.length;
            } else if (this.q == s) {
                for (n4 = 0; n4 < this.u.length; ++n4) {
                    arrayList2.add(this.u[n4]);
                }
                l3 += (long)this.u.length;
            }
            for (n4 = 0; n4 < 2; ++n4) {
                arrayList2.add(byArray2[n4]);
            }
            byte[] byArray4 = new byte[]{0, -92, 0, 0, 2, 1, 28};
            object = this.b.sendAPDU_Get(byArray4);
            if (object[0] == 132) {
                n3 = object[object[1] + 9] << 8;
                n3 += object[object[1] + 10];
            } else {
                n3 = object[7] << 8;
                n3 += object[8];
            }
            object = this.a((short)0, (short)n3);
            this.x = (Byte)object.get(n3 - 1);
            arrayList2.add(this.x);
            arrayList2.set(4, (byte)l3);
            short s2 = this.b.sendAPDU(this.b.toByteArray(arrayList2), true);
            if (s2 != -28672) {
                return null;
            }
            Object object2 = new ArrayList<Byte>();
            object = this.a(1, (ArrayList<Byte>)object2);
            object2 = new ArrayList();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                ((ArrayList)object2).add((Byte)arrayList.get(n3));
            }
            for (n3 = 0; n3 < 4; ++n3) {
                ((ArrayList)object2).add(byArray[n3]);
            }
            Object object3 = MessageDigest.getInstance("SHA-256");
            byte[] byArray5 = ((MessageDigest)object3).digest(this.b.toByteArray((ArrayList<Byte>)object2));
            object2 = byArray5;
            arrayList = (ArrayList<Byte>)Arrays.copyOfRange(byArray5, 0, 24);
            object2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            object = CeresCommand_v5.c(object, (byte[])arrayList, (byte[])object2);
            CeresCommand_v5 ceresCommand_v5 = this;
            object2 = ceresCommand_v5.a(ceresCommand_v5.x);
            arrayList = this.a((ECCurve)((d)object2).a, ((d)object2).b, ((d)object2).c);
            byte[] byArray6 = ((c)((Object)arrayList)).a.getEncoded(false);
            object3 = byArray6;
            int n5 = (byArray6.length - 1) / 2;
            byArray4 = this.a(2, this.b.toListByte((byte[])object3));
            object3 = ((d)object2).a.decodePoint(byArray4);
            arrayList = ((d)object2).a.getMultiplier().multiply((ECPoint)object3, ((c)((Object)arrayList)).b);
            object = new BigInteger(1, (byte[])object);
            ECPoint eCPoint = ((d)object2).a.getMultiplier().multiply(((d)object2).b, (BigInteger)object);
            object = eCPoint;
            arrayList = eCPoint.add((ECPoint)arrayList).normalize();
            object3 = this.a((ECCurve)((d)object2).a, (ECPoint)arrayList, ((d)object2).c);
            byte[] byArray7 = ((c)object3).a.getEncoded(false);
            byArray4 = this.a(3, this.b.toListByte(byArray7));
            arrayList = this.b.toListByte(Arrays.copyOfRange(byArray4, 1, n5 + 1));
            object = ((d)object2).a.decodePoint(byArray4);
            object2 = ((d)object2).a.getMultiplier().multiply((ECPoint)object, ((c)object3).b);
            byte[] byArray8 = object2.getEncoded(false);
            object2 = byArray8;
            byte[] byArray9 = Arrays.copyOfRange(byArray8, 1, 1 + (((Object)object2).length - 1) / 2);
            object2 = byArray9;
            int n6 = byArray9.length < n5 ? n5 : ((Object)object2).length;
            ArrayList<Byte> arrayList3 = new ArrayList<Byte>();
            for (n2 = 0; n2 < n6 - ((Object)object2).length; ++n2) {
                arrayList3.add((byte)0);
            }
            for (n2 = 0; n2 < ((Object)object2).length; ++n2) {
                arrayList3.add((byte)object2[n2]);
            }
            byArray[3] = 1;
            for (n2 = 0; n2 < 4; ++n2) {
                arrayList3.add(byArray[n2]);
            }
            Object object4 = MessageDigest.getInstance("SHA-256");
            object2 = ((MessageDigest)object4).digest(this.b.toByteArray(arrayList3));
            this.e = Arrays.copyOfRange((byte[])object2, 0, 24);
            ArrayList<Byte> arrayList4 = arrayList3;
            arrayList4.set(arrayList4.size() - 1, (byte)2);
            object4 = MessageDigest.getInstance("SHA-256");
            object2 = ((MessageDigest)object4).digest(this.b.toByteArray(arrayList3));
            this.f = Arrays.copyOfRange((byte[])object2, 0, 24);
            object4 = new ArrayList();
            for (int i2 = 2; i2 < this.D.length; ++i2) {
                ((ArrayList)object4).add(this.D[i2]);
            }
            CeresCommand_v5.a((byte)6, (ArrayList<Byte>)object4);
            Object object5 = this.b.toListByte(byArray4);
            CeresCommand_v5.a((byte)-122, object5);
            for (n6 = 0; n6 < ((ArrayList)object5).size(); ++n6) {
                ((ArrayList)object4).add(((ArrayList)object5).get(n6));
            }
            CeresCommand_v5.a((byte)73, (ArrayList<Byte>)object4);
            ((ArrayList)object4).add(0, (byte)127);
            CeresCommand_v5 ceresCommand_v52 = this;
            byte[] byArray10 = ceresCommand_v52.a(ceresCommand_v52.b.toByteArray((ArrayList<Byte>)object4), this.f, null);
            byArray4 = this.a(4, this.b.toListByte(byArray10));
            if (byArray4 == null) {
                return null;
            }
            object5 = Arrays.copyOfRange(byArray4, 0, 8);
            for (int i3 = 0; i3 < byArray7.length; ++i3) {
                ((ArrayList)object4).set(i3 + (((ArrayList)object4).size() - byArray7.length), byArray7[i3]);
            }
            CeresCommand_v5 ceresCommand_v53 = this;
            byte[] byArray11 = ceresCommand_v53.a(ceresCommand_v53.b.toByteArray((ArrayList<Byte>)object4), this.f, null);
            if (!Arrays.equals(byArray11, (byte[])object5)) {
                return null;
            }
            if (this.q != 0) {
                object5 = this.a(Arrays.copyOfRange(byArray4, 8, byArray4.length));
                int n7 = 8 + ((CeresCommand.b)object5).b;
                if (((CeresCommand.b)object5).c != -121) {
                    return null;
                }
                int n8 = n7;
                this.v = Arrays.copyOfRange(byArray4, n8, n8 + ((CeresCommand.b)object5).a);
                if ((n7 += ((CeresCommand.b)object5).a) < byArray4.length) {
                    object5 = this.a(Arrays.copyOfRange(byArray4, n7, byArray4.length));
                    if (((CeresCommand.b)object5).c != -120) {
                        return null;
                    }
                }
            }
            Arrays.fill(this.g, (byte)0);
            this.z = true;
        }
        catch (Exception exception) {
            return null;
        }
        return arrayList;
    }

    private byte[] a(int n2, ArrayList<Byte> arrayList) {
        int n3;
        byte[] byArray = new byte[]{16, -122, 0, 0};
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        byte[] byArray2 = null;
        if (n2 == 1) {
            arrayList2.add((byte)124);
            arrayList2.add((byte)0);
        } else {
            n3 = -123;
            if (n2 == 4) {
                byArray[0] = 0;
            } else {
                n3 = n2 == 2 ? -127 : -125;
            }
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                arrayList2.add(arrayList.get(i2));
            }
            CeresCommand_v5.a((byte)n3, arrayList2);
            CeresCommand_v5.a((byte)124, arrayList2);
        }
        arrayList2.add(0, (byte)arrayList2.size());
        for (n3 = 0; n3 < 4; ++n3) {
            arrayList2.add(n3, byArray[n3]);
        }
        try {
            byArray2 = this.b.sendAPDU_Get(this.b.toByteArray(arrayList2));
            if (byArray2 == null) {
                return null;
            }
            CeresCommand.b b2 = this.a(byArray2);
            int n4 = b2.b;
            int n5 = b2.a;
            byte by = b2.c;
            if (byArray2.length != n4 + n5 || by != 124) {
                return null;
            }
            b2 = this.a(Arrays.copyOfRange(byArray2, n4, byArray2.length));
            n4 += b2.b;
            by = b2.c;
            if (n2 == 4) {
                if ((byte)by != -122) {
                    return null;
                }
                byArray2 = Arrays.copyOfRange(byArray2, n4, byArray2.length);
            } else {
                if (n2 == 1 ? (byte)by != -128 : (n2 == 2 ? (byte)by != -126 || byArray2[n4] != 4 : (byte)by != -124 || byArray2[n4] != 4)) {
                    return null;
                }
                byArray2 = Arrays.copyOfRange(byArray2, n4, byArray2.length);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(CeresCommand_v5.class.getName()).log(Level.SEVERE, null, exception);
        }
        return byArray2;
    }

    private boolean d(ArrayList<Byte> arrayList) {
        int n2;
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        arrayList2.add((byte)0);
        arrayList2.add((byte)34);
        arrayList2.add((byte)-127);
        arrayList2.add((byte)-74);
        arrayList2.add((byte)(arrayList.size() + 2));
        arrayList2.add((byte)-125);
        arrayList2.add((byte)arrayList.size());
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            arrayList2.add(arrayList.get(n2));
        }
        if (this.z) {
            arrayList2 = this.b.toListByte(this.c(arrayList2));
        }
        CeresCommand_v5 ceresCommand_v5 = this;
        short s2 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList2)));
        n2 = s2;
        return s2 == -28672;
    }

    private boolean e(ArrayList<Byte> arrayList) {
        int n2;
        ArrayList<Byte> arrayList2 = new ArrayList<Byte>();
        arrayList2.add((byte)0);
        arrayList2.add((byte)42);
        arrayList2.add((byte)0);
        arrayList2.add((byte)-66);
        ArrayList<Byte> arrayList3 = new ArrayList<Byte>();
        arrayList3.add((byte)127);
        arrayList3.add((byte)33);
        int n3 = 2;
        if (Objects.equals(arrayList.get(0), arrayList3.get(0)) && Objects.equals(arrayList.get(1), arrayList3.get(1))) {
            int n4;
            if (arrayList.get(2) == -126) {
                n4 = (arrayList.get(3) << 8) + arrayList.get(4);
                n3 += 3;
            } else if (arrayList.get(2) == -127) {
                n4 = arrayList.get(3) & 0xFF;
                n3 += 2;
            } else {
                n4 = arrayList.get(2) & 0xFF;
                ++n3;
            }
            if (n4 < 250) {
                arrayList2.add((byte)n4);
            } else {
                arrayList2.add((byte)0);
                arrayList2.add((byte)(n4 / 256));
                arrayList2.add((byte)(n4 % 256));
            }
            for (n2 = n3; n2 < n4 + n3; ++n2) {
                arrayList2.add(arrayList.get(n2));
            }
        }
        if (this.z) {
            arrayList2 = this.b.toListByte(this.c(arrayList2));
        }
        CeresCommand_v5 ceresCommand_v5 = this;
        n2 = ceresCommand_v5.g(ceresCommand_v5.b.sendAPDU_Get(this.b.toByteArray(arrayList2)));
        return n2 == -28672;
    }

    public byte[] extractR(byte[] byArray) {
        int n2 = (byArray[1] & 0x80) != 0 ? 3 : 2;
        int n3 = byArray[n2 + 1];
        if (byArray[n2 += 2] == 0) {
            --n3;
        }
        int n4 = ++n2;
        return Arrays.copyOfRange(byArray, n4, n4 + n3);
    }

    public byte[] extractS(byte[] byArray) {
        int n2 = (byArray[1] & 0x80) != 0 ? 3 : 2;
        int n3 = byArray[n2 + 1];
        n2 = n2 + 2 + n3;
        n3 = byArray[n2 + 1];
        if (byArray[n2 += 2] == 0) {
            --n3;
        }
        int n4 = ++n2;
        return Arrays.copyOfRange(byArray, n4, n4 + n3);
    }

    private static byte[] b(byte[] object, byte[] byArray) {
        try {
            Object object2 = KeyFactory.getInstance("EC", "BC");
            object = ((KeyFactory)object2).generatePrivate(new PKCS8EncodedKeySpec((byte[])object));
            object2 = Signature.getInstance("SHA256withECDSA", "BC");
            ((Signature)object2).initSign((PrivateKey)object);
            ((Signature)object2).update(byArray);
            return ((Signature)object2).sign();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BigInteger nextRandomBigInteger(BigInteger bigInteger) {
        Random random = new Random();
        BigInteger bigInteger2 = new BigInteger(bigInteger.bitLength() - 1, random);
        while (bigInteger2.compareTo(bigInteger) >= 0) {
            bigInteger2 = new BigInteger(bigInteger.bitLength() - 1, random);
        }
        return bigInteger2;
    }

    private d a(byte by) {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        BigInteger bigInteger5 = null;
        BigInteger bigInteger6 = null;
        ECCurve.Fp fp = null;
        X9ECParameters x9ECParameters = null;
        switch (by) {
            case 13: {
                bigInteger = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377", 16);
                bigInteger2 = new BigInteger("7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9", 16);
                bigInteger3 = new BigInteger("26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6", 16);
                bigInteger6 = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7", 16);
                bigInteger4 = new BigInteger("8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262", 16);
                bigInteger5 = new BigInteger("547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997", 16);
                break;
            }
            case 17: {
                bigInteger = new BigInteger("AADD9DB8DBE9C48B3FD4E6AE33C9FC07CB308DB3B3C9D20ED6639CCA703308717D4D9B009BC66842AECDA12AE6A380E62881FF2F2D82C68528AA6056583A48F3", 16);
                bigInteger2 = new BigInteger("7830A3318B603B89E2327145AC234CC594CBDD8D3DF91610A83441CAEA9863BC2DED5D5AA8253AA10A2EF1C98B9AC8B57F1117A72BF2C7B9E7C1AC4D77FC94CA", 16);
                bigInteger3 = new BigInteger("3DF91610A83441CAEA9863BC2DED5D5AA8253AA10A2EF1C98B9AC8B57F1117A72BF2C7B9E7C1AC4D77FC94CADC083E67984050B75EBAE5DD2809BD638016F723", 16);
                bigInteger6 = new BigInteger("AADD9DB8DBE9C48B3FD4E6AE33C9FC07CB308DB3B3C9D20ED6639CCA70330870553E5C414CA92619418661197FAC10471DB1D381085DDADDB58796829CA90069", 16);
                bigInteger4 = new BigInteger("81AEE4BDD82ED9645A21322E9C4C6A9385ED9F70B5D916C1B43B62EEF4D0098EFF3B1F78E2D0D48D50D1687B93B97D5F7C6D5047406A5E688B352209BCB9F822", 16);
                bigInteger5 = new BigInteger("7DDE385D566332ECC0EABFA9CF7822FDF209F70024A57B1AA000C55B881F8111B2DCDE494A5F485E5BCA4BD88A2763AED1CA2B2FA8F0540678CD1E0F3AD80892", 16);
                break;
            }
            case 12: {
                x9ECParameters = NISTNamedCurves.getByName((String)"P-256");
                fp = (ECCurve.Fp)x9ECParameters.getCurve();
                break;
            }
            case 15: {
                x9ECParameters = NISTNamedCurves.getByName((String)"P-384");
                fp = (ECCurve.Fp)x9ECParameters.getCurve();
                break;
            }
            case 18: {
                x9ECParameters = NISTNamedCurves.getByName((String)"P-521");
                fp = (ECCurve.Fp)x9ECParameters.getCurve();
            }
        }
        d d2 = new d(this, 0);
        if (by == 12) {
            d2.a = fp;
            d2.b = (ECPoint.Fp)x9ECParameters.getG();
            d2.c = fp.getOrder();
        } else {
            d2.a = new ECCurve.Fp(bigInteger, bigInteger2, bigInteger3);
            d2.b = d2.a.createPoint(bigInteger4, bigInteger5);
            d2.c = bigInteger6;
        }
        return d2;
    }

    public static ECPoint referenceMultiply(ECPoint eCPoint, BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger.abs();
        ECPoint eCPoint2 = eCPoint.getCurve().getInfinity();
        int n2 = bigInteger2.bitLength();
        if (n2 > 0) {
            if (bigInteger2.testBit(0)) {
                eCPoint2 = eCPoint;
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                eCPoint = eCPoint.twice();
                if (!bigInteger2.testBit(i2)) continue;
                eCPoint2 = eCPoint2.add(eCPoint);
            }
        }
        if (bigInteger.signum() < 0) {
            return eCPoint2.negate();
        }
        return eCPoint2;
    }

    private c a(ECCurve eCCurve, ECPoint eCPoint, BigInteger bigInteger) {
        int n2;
        c c2 = new c(this, 0);
        do {
            c2.b = this.nextRandomBigInteger(bigInteger);
            c2.a = eCCurve.getMultiplier().multiply(eCPoint, c2.b);
        } while ((n2 = c2.a.getEncoded(false).length) < 64);
        return c2;
    }

    private static /* synthetic */ void c(ArrayList arrayList, Byte by) {
        arrayList.add(by);
    }

    final class a {
        String a;
        String b;
        String c;
        String d;
        String e;
        String f;
        private /* synthetic */ CeresCommand_v5 g;

        a(CeresCommand_v5 ceresCommand_v5, String string, String string2, String string3, String string4, String string5, String string6) {
            this.g = ceresCommand_v5;
            this.a = string;
            this.b = string2;
            this.c = string3;
            this.d = string4;
            this.e = string5;
            this.f = string6;
        }
    }

    final class b {
        byte[] a;
        byte[] b;
        byte[] c;
        byte[] d;
        byte[] e;
        byte[] f;
        private /* synthetic */ CeresCommand_v5 g;

        b(CeresCommand_v5 ceresCommand_v5) {
            this.g = ceresCommand_v5;
        }
    }

    final class d {
        ECCurve.Fp a;
        ECPoint b;
        BigInteger c;
        private /* synthetic */ CeresCommand_v5 d;

        private d(CeresCommand_v5 ceresCommand_v5) {
            this.d = ceresCommand_v5;
        }

        /* synthetic */ d(CeresCommand_v5 ceresCommand_v5, byte by) {
            this(ceresCommand_v5);
        }
    }

    final class c {
        ECPoint a;
        BigInteger b;
        private /* synthetic */ CeresCommand_v5 c;

        private c(CeresCommand_v5 ceresCommand_v5) {
            this.c = ceresCommand_v5;
        }

        /* synthetic */ c(CeresCommand_v5 ceresCommand_v5, byte by) {
            this(ceresCommand_v5);
        }
    }
}

