/*
 * Decompiled with CFR 0.152.
 */
package com.nubosolutions.pkcs11helper;

import com.nubosolutions.pkcs11helper.PKCS11Helper;
import com.nubosolutions.pkcs11helper.PasswordDialogRunnable;
import com.nubosolutions.pkcs11helper.Utilities;
import java.awt.Frame;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PCSCHelper {
    private static Logger a = LogManager.getLogger((String)PKCS11Helper.class.getName());
    public byte currentCardType;
    public int index = -1;
    public Card card;
    public CardChannel channel;
    public List<CardTerminal> terminals;
    public final ArrayList<Card> cards = new ArrayList();
    public ArrayList<Byte> cardType;
    private ArrayList<CardTerminal> b;
    private final byte[] c = new byte[]{0, -92, 4, 0, 11, 77, 97, 115, 116, 101, 114, 46, 70, 105, 108, 101};
    private final byte[] d = new byte[]{0, -92, 0, 0, 2, 0, 0};
    private final byte[] e = new byte[]{-112, 36, 0, 0};
    private final byte[] f = new byte[]{-112, 44, 0, 0};

    public PCSCHelper() {
        a.debug("INICIO PCSCHelper");
        String string = System.getProperty("os.name").toLowerCase();
        a.debug("OS: " + string);
        String string2 = System.getProperty("os.arch").toLowerCase();
        a.debug("Arch: " + string2);
        System.setProperty("sun.security.smartcardio.t0GetResponse", "false");
        if (string.contains("mac")) {
            System.setProperty("sun.security.smartcardio.library", "/System/Library/Frameworks/PCSC.framework/Versions/Current/PCSC");
        }
        if (string.contains("linux")) {
            Utilities.isLinux = true;
            string = Utilities.getLinuxDistribution().toLowerCase();
            if (string.contains("ubuntu")) {
                if (!new File("/lib/libpcsclite.so.1").isFile()) {
                    if (string2.contains("64")) {
                        if (new File("/lib/x86_64-linux-gnu/libpcsclite.so.1").isFile()) {
                            System.setProperty("sun.security.smartcardio.library", "/lib/x86_64-linux-gnu/libpcsclite.so.1");
                        } else {
                            System.setProperty("sun.security.smartcardio.library", "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1");
                        }
                    } else if (new File("/lib/i386-linux-gnu/libpcsclite.so.1").isFile()) {
                        System.setProperty("sun.security.smartcardio.library", "/lib/i386-linux-gnu/libpcsclite.so.1");
                    } else {
                        System.setProperty("sun.security.smartcardio.library", "/usr/lib/i386-linux-gnu/libpcsclite.so.1");
                    }
                }
            } else if (string.contains("debian")) {
                if (!new File("/usr/lib/libpcsclite.so.1").isFile()) {
                    if (string2.contains("64")) {
                        System.setProperty("sun.security.smartcardio.library", "/usr/lib/x86_64-linux-gnu/libpcsclite.so.1");
                    } else {
                        System.setProperty("sun.security.smartcardio.library", "/usr/lib/i386-linux-gnu/libpcsclite.so.1");
                    }
                }
            } else if (!string.contains("fedora")) {
                string.contains("openSUSE");
            }
        } else if (string.contains("mac")) {
            Utilities.isMac = true;
        }
        a.debug("FIN PCSCHelper");
    }

    public byte[] toByteArray(ArrayList<Byte> arrayList) {
        byte[] byArray = new byte[arrayList.size()];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = arrayList.get(i2);
        }
        return byArray;
    }

    public int[] toIntArray(ArrayList<Integer> arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = arrayList.get(i2);
        }
        return nArray;
    }

    public ArrayList<Byte> toListByte(char[] cArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            arrayList.add((byte)cArray[i2]);
        }
        return arrayList;
    }

    public ArrayList<Byte> toListByte(byte[] byArray) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            arrayList.add(byArray[i2]);
        }
        return arrayList;
    }

    public ArrayList<CardTerminal> listReaders(byte by) {
        a.debug("INICIO listReaders type=" + by);
        this.b = new ArrayList();
        a.debug("TerminalFactory.getDefault()");
        TerminalFactory terminalFactory = TerminalFactory.getDefault();
        try {
            a.debug("list()");
            this.terminals = terminalFactory.terminals().list();
        }
        catch (CardException cardException) {
            a.error("Exception:", (Throwable)cardException);
            return null;
        }
        this.cardType = new ArrayList();
        for (CardTerminal cardTerminal : this.terminals) {
            try {
                byte[] byArray;
                if (!cardTerminal.isCardPresent()) continue;
                a.debug("connect()");
                Card card = cardTerminal.connect("*");
                byte by2 = by;
                Object object = card.getATR();
                PCSCHelper pCSCHelper = this;
                a.debug("INICIO checkFNMT type: " + by2 + " ATR: " + Utilities.bytesToHex(((ATR)object).getBytes()));
                boolean bl = true;
                byte[] byArray2 = ((ATR)object).getBytes();
                object = byArray2;
                short s2 = ByteBuffer.wrap(byArray2).order(ByteOrder.BIG_ENDIAN).getShort(1);
                byte[] byArray3 = new byte[]{67, 69, 82, 69, 83};
                byte[] byArray4 = new byte[]{70, 78, 77, 84};
                byte[] byArray5 = new byte[]{84, 73, 70};
                byte[] byArray6 = new byte[]{68, 78, 73};
                if (s2 == -4352) {
                    byArray = new byte[21];
                    s2 = ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).getShort(16);
                    ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).get(byArray);
                    object = Arrays.copyOfRange(byArray, 8, 13);
                } else {
                    byArray = new byte[20];
                    s2 = ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).getShort(15);
                    ByteBuffer.wrap((byte[])object).order(ByteOrder.BIG_ENDIAN).get(byArray);
                    object = Arrays.copyOfRange(byArray, 7, 12);
                }
                if (Arrays.equals((byte[])object, byArray3) || Arrays.equals(Arrays.copyOf((byte[])object, 4), byArray4)) {
                    if (s2 == 1072) {
                        pCSCHelper.cardType.add((byte)2);
                    } else if (s2 == 1280) {
                        pCSCHelper.cardType.add((byte)2);
                    } else {
                        pCSCHelper.cardType.add((byte)1);
                    }
                } else if (by2 == 1 && Arrays.equals(Arrays.copyOf((byte[])object, 3), byArray5)) {
                    pCSCHelper.cardType.add((byte)3);
                } else if (by2 == 1 && Arrays.equals(Arrays.copyOf((byte[])object, 3), byArray6)) {
                    pCSCHelper.cardType.add((byte)4);
                } else {
                    bl = false;
                }
                a.debug("FIN checkFNMT result = " + bl);
                if (!bl) continue;
                this.b.add(cardTerminal);
                this.cards.add(card);
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
            }
        }
        a.debug("FIN listReaders");
        return this.b;
    }

    public boolean conectar() {
        a.debug("INICIO conectar");
        this.currentCardType = this.cardType.get(this.index);
        try {
            this.card = this.cards.get(this.index);
            a.debug("disconnect");
            this.card.disconnect(true);
            a.debug("connect");
            this.card = this.b.get(this.index).connect("*");
        }
        catch (CardException cardException) {
            a.error("Exception:", (Throwable)cardException);
            return false;
        }
        this.channel = this.card.getBasicChannel();
        a.debug("FIN conectar");
        return this.channel != null;
    }

    public void disconnect() {
        a.debug("INICIO disconnect");
        this.cards.stream().forEach(card -> {
            try {
                card.disconnect(true);
                return;
            }
            catch (CardException cardException) {
                return;
            }
        });
        a.debug("FIN disconnect");
    }

    private byte[] a(short s2) {
        ResponseAPDU responseAPDU;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        byte[] byArray = new byte[]{0, -64, 0, 0, 0};
        arrayList.clear();
        do {
            try {
                byArray[4] = (byte)s2;
                responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
                return null;
            }
            byte[] byArray2 = responseAPDU.getData();
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                arrayList.add(byArray2[i2]);
            }
        } while ((short)((short)responseAPDU.getSW() & 0xFF00) == 24832);
        return this.toByteArray(arrayList);
    }

    public short sendAPDU(byte[] byArray, boolean bl) {
        ResponseAPDU responseAPDU;
        block13: {
            responseAPDU = null;
            try {
                responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
                if (!this.conectar()) break block13;
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException2) {
                    a.error("Exception:", (Throwable)cardException2);
                    return -1;
                }
            }
        }
        if (responseAPDU == null) {
            return -1;
        }
        if (bl && (short)((short)responseAPDU.getSW() & 0xFF00) != 24832 && (short)responseAPDU.getSW() != -28672) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                a.error("Exception:", (Throwable)interruptedException);
            }
            if (this.conectar()) {
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException) {
                    a.error("Exception:", (Throwable)cardException);
                    return -1;
                }
            }
        }
        if ((short)((short)responseAPDU.getSW() & 0xFF00) != 24832) {
            return (short)responseAPDU.getSW();
        }
        byArray = this.a((short)responseAPDU.getSW());
        if (byArray != null) {
            return -28672;
        }
        return 28416;
    }

    public byte[] sendAPDU_Get(byte[] byArray) {
        ResponseAPDU responseAPDU;
        block13: {
            responseAPDU = null;
            try {
                responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
            }
            catch (CardException cardException) {
                a.error("Exception:", (Throwable)cardException);
                if (!this.conectar()) break block13;
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException2) {
                    a.error("Exception:", (Throwable)cardException2);
                    return null;
                }
            }
        }
        if (responseAPDU == null) {
            return null;
        }
        if ((short)((short)responseAPDU.getSW() & 0xFF00) != 24832 && (short)responseAPDU.getSW() != -28672) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                a.error("Exception:", (Throwable)interruptedException);
            }
            if (this.conectar()) {
                try {
                    responseAPDU = this.channel.transmit(new CommandAPDU(byArray));
                }
                catch (CardException cardException) {
                    a.error("Exception:", (Throwable)cardException);
                    return null;
                }
            }
        }
        if ((short)((short)responseAPDU.getSW() & 0xFF00) == 24832) {
            return this.a((short)responseAPDU.getSW());
        }
        if ((short)responseAPDU.getSW() != -28672) {
            return null;
        }
        return responseAPDU.getData();
    }

    public int cambiarPIN(Frame object) {
        a.debug("INICIO cambiarPIN");
        Object object2 = new PasswordDialogRunnable((Frame)object, 0, false);
        ((PasswordDialogRunnable)object2).run();
        Object object3 = ((PasswordDialogRunnable)object2).a();
        if (object3 != null) {
            object2 = new PasswordDialogRunnable((Frame)object, 1, true);
            ((PasswordDialogRunnable)object2).run();
            object2 = ((PasswordDialogRunnable)object2).a();
            if (object2 != null) {
                int n2;
                int n3;
                byte by;
                object = ((KeyStore.PasswordProtection)object3).getPassword();
                object3 = object2 = (Object)((KeyStore.PasswordProtection)object2).getPassword();
                object2 = object;
                object = this;
                a.debug("INICIO sendCommandsPinChange");
                a.debug("sendAPDU commandSelectMaster");
                ArrayList<Byte> arrayList = new ArrayList<Byte>();
                byte[] byArray = ((PCSCHelper)object).c;
                for (by = 0; by < 16; ++by) {
                    n3 = byArray[by];
                    arrayList.add((byte)n3);
                }
                Object object4 = object;
                int n4 = ((PCSCHelper)object4).sendAPDU(((PCSCHelper)object4).toByteArray(arrayList), true);
                if (n4 != -28672) {
                    a.debug("FIN sendCommandsPinChange");
                    n2 = 2;
                } else {
                    arrayList.clear();
                    a.debug("sendAPDU commandSelectPin");
                    byte[] byArray2 = ((PCSCHelper)object).d;
                    for (n3 = 0; n3 < 7; ++n3) {
                        by = byArray2[n3];
                        arrayList.add(by);
                    }
                    Object object5 = object;
                    n4 = ((PCSCHelper)object5).sendAPDU(((PCSCHelper)object5).toByteArray(arrayList), true);
                    if (n4 != -28672) {
                        a.debug("FIN sendCommandsPinChange");
                        n2 = 2;
                    } else {
                        arrayList.clear();
                        a.debug("sendAPDU commandUnlockPin");
                        byte[] byArray3 = ((PCSCHelper)object).e;
                        for (n3 = 0; n3 < 4; ++n3) {
                            by = byArray3[n3];
                            arrayList.add(by);
                        }
                        arrayList.add((byte)(3 + ((Object)object2).length + ((Object)object3).length));
                        arrayList.add((byte)1);
                        arrayList.add((byte)((Object)object2).length);
                        for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                            arrayList.add((byte)object2[n4]);
                        }
                        arrayList.add((byte)((Object)object3).length);
                        for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
                            arrayList.add((byte)object3[n4]);
                        }
                        Object object6 = object;
                        short s2 = ((PCSCHelper)object6).sendAPDU(((PCSCHelper)object6).toByteArray(arrayList), true);
                        n4 = s2;
                        if (s2 != -28672) {
                            a.debug("FIN sendCommandsPinChange");
                            n2 = 2;
                        } else {
                            a.debug("FIN sendCommandsPinChange");
                            n2 = 0;
                        }
                    }
                }
                int n5 = n2;
                a.debug("FIN cambiarPIN");
                return n5;
            }
            a.debug("newPasswordProtection = NULL");
            a.debug("FIN cambiarPIN");
            return 1;
        }
        a.debug("passwordProtection = NULL");
        a.debug("FIN cambiarPIN");
        return 1;
    }

    public int desbloquearPIN(Frame object) {
        int n2;
        a.debug("INICIO desbloquearPIN");
        Object object2 = new PasswordDialogRunnable((Frame)object, 2, false);
        ((PasswordDialogRunnable)object2).run();
        Object object3 = ((PasswordDialogRunnable)object2).a();
        if (object3 != null) {
            object2 = new PasswordDialogRunnable((Frame)object, 1, true);
            ((PasswordDialogRunnable)object2).run();
            object = ((PasswordDialogRunnable)object2).a();
            if (object != null) {
                boolean bl;
                int n3;
                byte by;
                object3 = ((KeyStore.PasswordProtection)object3).getPassword();
                object2 = ((KeyStore.PasswordProtection)object).getPassword();
                object = this;
                a.debug("INICIO desbloquearTarjeta");
                a.debug("sendAPDU commandSelectMaster");
                ArrayList<Byte> arrayList = new ArrayList<Byte>();
                byte[] byArray = ((PCSCHelper)object).c;
                for (by = 0; by < 16; ++by) {
                    n3 = byArray[by];
                    arrayList.add((byte)n3);
                }
                Object object4 = object;
                short s2 = ((PCSCHelper)object4).sendAPDU(((PCSCHelper)object4).toByteArray(arrayList), true);
                if (s2 != -28672) {
                    a.debug("FIN desbloquearTarjeta");
                    bl = false;
                } else {
                    arrayList.clear();
                    a.debug("sendAPDU commandSelectPin");
                    byte[] byArray2 = ((PCSCHelper)object).d;
                    for (n3 = 0; n3 < 7; ++n3) {
                        by = byArray2[n3];
                        arrayList.add(by);
                    }
                    Object object5 = object;
                    short s3 = ((PCSCHelper)object5).sendAPDU(((PCSCHelper)object5).toByteArray(arrayList), true);
                    if (s3 != -28672) {
                        a.debug("FIN desbloquearTarjeta");
                        bl = false;
                    } else {
                        int n4;
                        arrayList.clear();
                        a.debug("sendAPDU commandUnlockCard");
                        byte[] byArray3 = ((PCSCHelper)object).f;
                        for (n3 = 0; n3 < 4; ++n3) {
                            by = byArray3[n3];
                            arrayList.add(by);
                        }
                        arrayList.add((byte)(17 + ((Object)object2).length));
                        for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
                            arrayList.add((byte)object3[n4]);
                        }
                        arrayList.add((byte)((Object)object2).length);
                        for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
                            arrayList.add((byte)object2[n4]);
                        }
                        Object object6 = object;
                        short s4 = ((PCSCHelper)object6).sendAPDU(((PCSCHelper)object6).toByteArray(arrayList), true);
                        n4 = s4;
                        if (s4 != -28672) {
                            a.debug("FIN desbloquearTarjeta NO OK");
                            bl = false;
                        } else {
                            a.debug("FIN desbloquearTarjeta OK");
                            bl = true;
                        }
                    }
                }
                n2 = bl ? 0 : 2;
            } else {
                n2 = 1;
            }
        } else {
            n2 = 1;
        }
        a.debug("FIN desbloquearPIN result = " + n2);
        return n2;
    }
}

