/*
 * Decompiled with CFR 0.152.
 */
package com.nubosolutions.pkcs11helper;

import com.nubosolutions.pkcs11helper.CertificateObject;
import com.nubosolutions.pkcs11helper.DataObject;
import com.nubosolutions.pkcs11helper.PasswordDialogRunnable;
import com.nubosolutions.pkcs11helper.PrivateKeyObject;
import com.nubosolutions.pkcs11helper.PublicKeyObject;
import com.nubosolutions.pkcs11helper.Utilities;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class PKCS11Helper {
    private static Logger b = LogManager.getLogger((String)PKCS11Helper.class.getName());
    KeyStore.PasswordProtection a;
    private static String c;
    private ArrayList<X509Certificate> d = new ArrayList();
    public ArrayList<Long> hObjects = new ArrayList();
    public ArrayList<String> lectores = new ArrayList();
    public PKCS11 p11 = null;
    public static CK_INFO info;

    public PKCS11Helper(String string) {
        c = string;
        System.out.println("PKCS11Helper: pk11LibPath:" + c);
        b.info("PKCS11Helper: pk11LibPath:" + c);
    }

    public static PKCS11Helper initHelper(byte by) {
        Object object;
        b.debug("INICIO initHelper");
        PKCS11Helper pKCS11Helper = null;
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch").toLowerCase();
        String string3 = "";
        try {
            string3 = PKCS11Helper.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        if (string3.endsWith("jar")) {
            string3 = new File(string3).getParent();
        }
        if (string3.endsWith("lib") || string3.endsWith("lib/") || string3.endsWith("lib\\")) {
            string3 = new File(string3).getParent();
        }
        string3 = string3 + "/";
        b.info("initHelper: jarPath:" + string3);
        System.out.println("initHelper: jarPath:" + string3);
        if (by != 0) {
            if (by == 1 || by == 2) {
                if (string2.contains("64")) {
                    if (new File("FNMT_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("FNMT_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/FNMT_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11_x64.dll");
                        } else if (new File("C:/Windows/System32/FNMT_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11.dll");
                        }
                    }
                } else {
                    if (new File("FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("FNMT_P11.dll");
                    }
                    if (pKCS11Helper == null && new File("C:/Windows/SysWOW64/FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/FNMT_P11.dll");
                    }
                }
            } else if (by == 4) {
                if (string2.contains("64")) {
                    if (new File("DNIe_P11_priv_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11_priv_x64.dll");
                    } else if (new File("DNIe_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/DNIe_P11_priv_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/DNIe_P11_priv_x64.dll");
                        } else if (new File("C:/Windows/System32/DNIe_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/DNIe_P11_x64.dll");
                        }
                    }
                } else {
                    if (new File("DNIe_P11_priv.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11_priv.dll");
                    } else if (new File("DNIe_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("DNIe_P11.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/SysWOW64/DNIe_P11_priv.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/DNIe_P11_priv.dll");
                        } else if (new File("C:/Windows/SysWOW64/DNIe_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/DNIe_P11.dll");
                        }
                    }
                }
            } else if (by == 3) {
                if (string2.contains("64")) {
                    if (new File("TIF_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("TIF_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/TIF_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/TIF_P11_x64.dll");
                        } else if (new File("C:/Windows/System32/TIF_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/TIF_P11.dll");
                        }
                    }
                } else {
                    if (new File("TIF_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("TIF_P11.dll");
                    }
                    if (pKCS11Helper == null && new File("C:/Windows/SysWOW64/TIF_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/TIF_P11.dll");
                    }
                }
            }
        } else if (string.contains("windows")) {
            Utilities.isWindows = true;
            if (System.getenv("ProgramFiles(x86)") != null) {
                if (string2.contains("64")) {
                    if (new File(string3 + "FNMT_P11_x64.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper(string3 + "FNMT_P11_x64.dll");
                    }
                    if (pKCS11Helper == null) {
                        if (new File("C:/Windows/System32/FNMT_P11_x64.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11_x64.dll");
                        } else if (new File("C:/Windows/System32/FNMT_P11.dll").exists()) {
                            pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11.dll");
                        }
                    }
                    if (pKCS11Helper == null) {
                        pKCS11Helper = new PKCS11Helper("FNMT_P11_x64.dll");
                    }
                } else {
                    if (new File(string3 + "FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper(string3 + "FNMT_P11.dll");
                    }
                    if (pKCS11Helper == null && new File("C:/Windows/SysWOW64/FNMT_P11.dll").exists()) {
                        pKCS11Helper = new PKCS11Helper("C:/Windows/SysWOW64/FNMT_P11.dll");
                    }
                }
            } else {
                if (new File(string3 + "FNMT_P11.dll").exists()) {
                    pKCS11Helper = new PKCS11Helper(string3 + "FNMT_P11_x64.dll");
                }
                if (pKCS11Helper == null && new File("C:/Windows/System32/FNMT_P11.dll").exists()) {
                    pKCS11Helper = new PKCS11Helper("C:/Windows/System32/FNMT_P11.dll");
                }
            }
            if (pKCS11Helper == null) {
                pKCS11Helper = new PKCS11Helper("FNMT_P11.dll");
            }
        } else if (string.contains("linux")) {
            Utilities.isLinux = true;
            object = Utilities.getLinuxDistribution().toLowerCase();
            if (((String)object).contains("ubuntu") || ((String)object).contains("debian")) {
                if (new File("/usr/lib/libpkcs11-fnmtdnie.so").isFile()) {
                    pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmtdnie.so");
                }
                if (pKCS11Helper == null && new File("/usr/lib/libpkcs11-fnmt.so").isFile()) {
                    pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmt.so");
                }
            } else if (((String)object).contains("fedora") || ((String)object).contains("opensuse")) {
                if (string2.contains("64")) {
                    if (new File("/usr/lib64/libpkcs11-fnmtdnie.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib64/libpkcs11-fnmtdnie.so");
                    }
                    if (pKCS11Helper == null && new File("/usr/lib64/libpkcs11-fnmt.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib64/libpkcs11-fnmt.so");
                    }
                } else {
                    if (new File("/usr/lib/libpkcs11-fnmtdnie.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmtdnie.so");
                    }
                    if (pKCS11Helper == null && new File("/usr/lib/libpkcs11-fnmt.so").isFile()) {
                        pKCS11Helper = new PKCS11Helper("/usr/lib/libpkcs11-fnmt.so");
                    }
                }
            }
        } else if (string.contains("mac")) {
            Utilities.isMac = true;
            if (new File("/Library/Libpkcs11-fnmtdnie/lib/libpkcs11-fnmtdnie.so").isFile()) {
                pKCS11Helper = new PKCS11Helper("/Library/Libpkcs11-fnmtdnie/lib/libpkcs11-fnmtdnie.so");
            } else if (new File("/Library/Libpkcs11-fnmt/lib/libpkcs11-fnmt.so").isFile()) {
                pKCS11Helper = new PKCS11Helper("/Library/Libpkcs11-fnmt/lib/libpkcs11-fnmt.so");
            }
        }
        if (pKCS11Helper != null) {
            b.debug("Cargada librer\u00eda " + c);
        } else {
            b.debug("No se ha cargado librer\u00eda");
        }
        b.debug("FIN initHelper");
        return pKCS11Helper;
    }

    private X509Certificate a(long l2, long l3) {
        Object object;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        block3: {
            b.debug("INICIO loadCert");
            cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
            try {
                b.debug("C_GetAttributeValue CKA_VALUE");
                this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = pKCS11Exception;
                int n2 = (int)pKCS11Exception.getErrorCode();
                if (n2 != -2146408056 && n2 != -2146407802) break block3;
                this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
            }
        }
        byte[] byArray = cK_ATTRIBUTEArray[0].getByteArray();
        object = byArray;
        if (byArray == null) {
            b.debug("unexpectedly retrieved null byte array");
            throw new CertificateException("unexpectedly retrieved null byte array");
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        b.debug("generateCertificate");
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])object));
        b.debug("FIN loadCert");
        return x509Certificate;
    }

    public byte[] getID(long l2, long l3) {
        b.debug("INICIO getID");
        byte[] byArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 258L;
        try {
            b.debug("C_GetAttributeValue CKA_ID");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            byArray = cK_ATTRIBUTEArray[0].getByteArray();
        }
        b.debug("FIN getID");
        return byArray;
    }

    public char[] getLabel(long l2, long l3) {
        b.debug("INICIO getLabel");
        char[] cArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 3L;
        try {
            b.debug("C_GetAttributeValue CKA_LABEL");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            cArray = cK_ATTRIBUTEArray[0].getCharArray();
        }
        b.debug("FIN getLabel");
        return cArray;
    }

    public char[] getSubject(long l2, long l3) {
        b.debug("INICIO getSubject");
        char[] cArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 257L;
        try {
            b.debug("C_GetAttributeValue CKA_SUBJECT");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            cArray = cK_ATTRIBUTEArray[0].getCharArray();
        }
        b.debug("FIN getSubject");
        return cArray;
    }

    public byte[] getIssuer(long l2, long l3) {
        b.debug("INICIO getIssuer");
        byte[] byArray = null;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        (new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()})[0].type = 129L;
        try {
            b.debug("C_GetAttributeValue CKA_ISSUER");
            this.p11.C_GetAttributeValue(l2, l3, cK_ATTRIBUTEArray);
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (cK_ATTRIBUTEArray[0].pValue != null) {
            byArray = cK_ATTRIBUTEArray[0].getByteArray();
        }
        b.debug("FIN getIssuer");
        return byArray;
    }

    private X509Certificate[] a() {
        b.debug("INICIO getCertificates");
        X509Certificate[] x509CertificateArray = new X509Certificate[]{};
        x509CertificateArray = this.d.toArray(x509CertificateArray);
        b.debug("FIN getCertificates");
        return x509CertificateArray;
    }

    public int getP11Instance() {
        b.debug("INICIO getP11Instance");
        int n2 = 0;
        Object object = new File(c);
        try {
            c = ((File)object).getCanonicalPath();
            b.debug("getCanonicalPath: " + c);
        }
        catch (IOException iOException) {
            b.error("Exception:", (Throwable)iOException);
            return 1;
        }
        object = System.getProperty("java.version");
        b.debug("Java version: " + (String)object);
        if (((String)object).startsWith("1.8.") || ((String)object).startsWith("11.") || ((String)object).startsWith("12.") || ((String)object).startsWith("13.") || ((String)object).startsWith("14.") || ((String)object).startsWith("15.")) {
            try {
                b.debug("getInstance");
                this.p11 = PKCS11.getInstance(c, "C_GetFunctionList", null, false);
                b.debug("C_GetInfo");
                info = this.p11.C_GetInfo();
            }
            catch (IOException | PKCS11Exception exception) {
                Exception exception2 = exception;
                exception.getMessage();
                b.error("Exception:", (Throwable)exception2);
                return 2;
            }
        } else {
            n2 = 3;
        }
        b.debug("FIN getP11Instance");
        return n2;
    }

    public ArrayList<Long> openSession(long l2, byte by) {
        Object object;
        b.debug("INICIO openSession");
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            b.debug("C_GetSlotList");
            object = this.p11.C_GetSlotList(true);
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return null;
        }
        if (object == null) {
            return null;
        }
        long[] lArray = object;
        int n2 = ((long[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = lArray[i2];
            try {
                b.debug("C_GetMechanismList");
                this.p11.C_GetMechanismList(l3);
            }
            catch (PKCS11Exception pKCS11Exception) {
                b.error("Exception:", (Throwable)pKCS11Exception);
                return null;
            }
            try {
                b.debug("C_GetTokenInfo");
                object = this.p11.C_GetTokenInfo(l3);
                object = new String(((CK_TOKEN_INFO)object).manufacturerID).substring(0, 8);
                b.debug("Manufacturer: " + (String)object);
                if (!((String)object).equalsIgnoreCase("FNMT-RCM") && !((String)object).toUpperCase().contains("TC-FNMT") && (by != 1 || !((String)object).equalsIgnoreCase("CNP-FNMT")) && (by != 1 || !((String)object).equalsIgnoreCase("DGP-FNMT"))) continue;
                b.debug("C_OpenSession");
                arrayList.add(this.p11.C_OpenSession(l3, l2, null, null));
                b.debug("C_GetSlotInfo");
                this.lectores.add(new String(this.p11.C_GetSlotInfo((long)l3).slotDescription));
                continue;
            }
            catch (PKCS11Exception pKCS11Exception) {
                b.error("Exception:", (Throwable)pKCS11Exception);
                return null;
            }
        }
        b.debug("FIN openSession");
        return arrayList;
    }

    public void closeSession(ArrayList<Long> object) {
        b.debug("INICIO closeSession");
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            long l2 = (Long)object.next();
            this.p11.C_CloseSession(l2);
        }
        b.debug("FIN closeSession");
    }

    public void logout(long l2) {
        try {
            this.p11.C_Logout(l2);
        }
        catch (PKCS11Exception pKCS11Exception) {}
        if (Utilities.isWindows) {
            b.debug("Start CertPropSvc");
            try {
                String[] stringArray = new String[]{"cmd.exe", "/c", "sc", "start", "CertPropSvc"};
                new ProcessBuilder(stringArray).start().waitFor();
                return;
            }
            catch (Exception exception) {
                b.debug("Exception : " + exception);
            }
        }
    }

    public int login(Frame stringArray, long l2) {
        int n2 = 0;
        b.debug("INICIO login");
        if (this.a == null) {
            stringArray = new PasswordDialogRunnable((Frame)stringArray, 0, false);
            stringArray.run();
            this.a = stringArray.a();
        }
        try {
            if (this.a != null) {
                b.debug("C_Login");
                this.p11.C_Login(l2, 1L, this.a.getPassword());
                if (Utilities.isWindows) {
                    b.debug("Stop CertPropSvc");
                    try {
                        stringArray = new String[]{"cmd.exe", "/c", "net", "stop", "CertPropSvc"};
                        new ProcessBuilder(stringArray).start().waitFor();
                    }
                    catch (Exception exception) {
                        b.debug("Exception : " + exception);
                    }
                }
            } else {
                n2 = 1;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            this.a = null;
            b.error("Exception:", (Throwable)pKCS11Exception);
            if (pKCS11Exception.getErrorCode() != 256L) {
                pKCS11Exception.getErrorCode();
            }
            n2 = 2;
        }
        b.debug("FIN login");
        return n2;
    }

    public ArrayList<CertificateObject> getCertificateObject(long l2) {
        b.debug("INICIO getCertificateObject");
        ArrayList<CertificateObject> arrayList = new ArrayList<CertificateObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 1L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                CertificateObject certificateObject = new CertificateObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                try {
                    b.debug("C_GetAttributeValue CKA_VALUE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.value = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    b.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    b.debug("C_GetAttributeValue CKA_ID");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.id = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(130L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SERIAL_NUMBER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.serialNumber = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(257L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SUBJECT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.subject = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(129L)};
                try {
                    b.debug("C_GetAttributeValue CKA_ISSUER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    certificateObject.issuer = cK_ATTRIBUTEArray[0].getByteArray();
                }
                arrayList.add(certificateObject);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
        }
        b.debug("FIN getCertificateObject");
        return arrayList;
    }

    public ArrayList<PublicKeyObject> getPublicKeyObject(long l2) {
        b.debug("INICIO getPublicKeyObject");
        ArrayList<PublicKeyObject> arrayList = new ArrayList<PublicKeyObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 2L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                PublicKeyObject publicKeyObject = new PublicKeyObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    b.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    b.debug("C_GetAttributeValue CKA_ID");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.id = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(289L)};
                try {
                    b.debug("C_GetAttributeValue CKA_MODULUS_BITS");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.modulus_bits = cK_ATTRIBUTEArray[0].getLong();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(257L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SUBJECT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.subject = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
                try {
                    b.debug("C_GetAttributeValue CKA_MODULUS");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.modulus = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(260L)};
                try {
                    b.debug("C_GetAttributeValue CKA_ENCRYPT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.encrypt = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(266L)};
                try {
                    b.debug("C_GetAttributeValue CKA_VERIFY");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.verify = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(267L)};
                try {
                    b.debug("C_GetAttributeValue CKA_VERIFY_RECOVER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.verify_recover = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(262L)};
                try {
                    b.debug("C_GetAttributeValue CKA_WRAP");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    publicKeyObject.wrap = cK_ATTRIBUTEArray[0].getBoolean();
                }
                arrayList.add(publicKeyObject);
            }
        }
        catch (Exception exception) {
            b.error("Exception:", (Throwable)exception);
        }
        b.debug("FIN getPublicKeyObject");
        return arrayList;
    }

    public ArrayList<PrivateKeyObject> getPrivateKeyObject(long l2) {
        b.debug("INICIO getPrivateKeyObject");
        ArrayList<PrivateKeyObject> arrayList = new ArrayList<PrivateKeyObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 3L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                PrivateKeyObject privateKeyObject = new PrivateKeyObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    b.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    b.debug("C_GetAttributeValue CKA_ID");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.id = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
                try {
                    b.debug("C_GetAttributeValue CKA_MODULUS");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.modulus = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(257L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SUBJECT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.subject = cK_ATTRIBUTEArray[0].getByteArray();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(259L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SENSITIVE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.sensitive = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(261L)};
                try {
                    b.debug("C_GetAttributeValue CKA_DECRYPT");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.decrypt = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(264L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SIGN");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.sign = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(265L)};
                try {
                    b.debug("C_GetAttributeValue CKA_SIGN_RECOVER");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.sign_recover = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(263L)};
                try {
                    b.debug("C_GetAttributeValue CKA_UNWRAP");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.unwrap = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(354L)};
                try {
                    b.debug("C_GetAttributeValue CKA_EXTRACTABLE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.extractable = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(357L)};
                try {
                    b.debug("C_GetAttributeValue CKA_ALWAYS_SENSITIVE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.always_sensitive = cK_ATTRIBUTEArray[0].getBoolean();
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(356L)};
                try {
                    b.debug("C_GetAttributeValue CKA_NEVER_EXTRACTABLE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    privateKeyObject.never_extractable = cK_ATTRIBUTEArray[0].getBoolean();
                }
                arrayList.add(privateKeyObject);
            }
        }
        catch (Exception exception) {
            b.error("Exception:", (Throwable)exception);
        }
        b.debug("FIN getPrivateKeyObject");
        return arrayList;
    }

    public ArrayList<DataObject> getDataObject(long l2) {
        b.debug("INICIO getDataObject");
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        Object object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        ((CK_ATTRIBUTE)object).pValue = 0L;
        cK_ATTRIBUTEArray[0] = object;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            object = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                DataObject dataObject = new DataObject();
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
                try {
                    b.debug("C_GetAttributeValue CKA_LABEL");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    dataObject.label = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(16L)};
                try {
                    b.debug("C_GetAttributeValue CKA_APPLICATION");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    dataObject.application = new String(cK_ATTRIBUTEArray[0].getCharArray());
                }
                cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                try {
                    b.debug("C_GetAttributeValue CKA_VALUE");
                    this.p11.C_GetAttributeValue(l2, (long)object[i2], cK_ATTRIBUTEArray);
                }
                catch (Exception exception) {
                    b.error("Exception:", (Throwable)exception);
                }
                if (cK_ATTRIBUTEArray[0].pValue != null) {
                    dataObject.value = cK_ATTRIBUTEArray[0].getByteArray();
                }
                arrayList.add(dataObject);
            }
        }
        catch (Exception exception) {
            b.error("Exception:", (Throwable)exception);
        }
        b.debug("FIN getDataObject");
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public int loadPublicKeys(long l2) {
        b.debug("INICIO loadPublicKeys");
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 2L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            void var7_10;
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            b.debug("C_FindObjects");
            long[] i2 = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] iterator = i2;
            int n3 = i2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                long l3 = iterator[i3];
                CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cfr_ignored_0 = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE2.type = 0L;
                cK_ATTRIBUTE2.pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue != null) {
                    arrayList.add(cK_ATTRIBUTE.pValue);
                    arrayList2.add(l3);
                    continue;
                }
                arrayList3.add(l3);
            }
            boolean pKCS11Exception = false;
            while (var7_10 < arrayList.size()) {
                CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE3.type = 0L;
                cK_ATTRIBUTE3.pValue = 1L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = arrayList.get((int)var7_10);
                cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE3;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                b.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                b.debug("C_FindObjects");
                long[] lArray = this.p11.C_FindObjects(l2, 1000L);
                b.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
                if (lArray == null || lArray.length == 0) {
                    b.debug("C_DestroyObject");
                    this.p11.C_DestroyObject(l2, (Long)arrayList2.get((int)var7_10));
                    ++n2;
                }
                ++var7_10;
            }
            Iterator iterator2 = arrayList3.iterator();
            while (iterator2.hasNext()) {
                long l4 = (Long)iterator2.next();
                b.debug("C_DestroyObject publicKeysNoCKA");
                this.p11.C_DestroyObject(l2, l4);
                ++n2;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return -1;
        }
        b.debug("FIN loadPublicKeys: " + n2);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public int loadPrivateKeys(long l2) {
        b.debug("INICIO loadPrivateKeys");
        int n2 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 3L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            void var7_10;
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            b.debug("C_FindObjects");
            long[] i2 = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] iterator = i2;
            int n3 = i2.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                long l3 = iterator[i3];
                CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cfr_ignored_0 = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE2.type = 0L;
                cK_ATTRIBUTE2.pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue != null) {
                    arrayList.add(cK_ATTRIBUTE.pValue);
                    arrayList2.add(l3);
                    continue;
                }
                arrayList3.add(l3);
            }
            boolean pKCS11Exception = false;
            while (var7_10 < arrayList.size()) {
                CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                cK_ATTRIBUTE3.type = 0L;
                cK_ATTRIBUTE3.pValue = 1L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = arrayList.get((int)var7_10);
                cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE3;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                b.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                b.debug("C_FindObjects");
                long[] lArray = this.p11.C_FindObjects(l2, 1000L);
                b.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
                if (lArray == null || lArray.length == 0) {
                    b.debug("C_DestroyObject");
                    this.p11.C_DestroyObject(l2, (Long)arrayList2.get((int)var7_10));
                    ++n2;
                }
                ++var7_10;
            }
            Iterator iterator2 = arrayList3.iterator();
            while (iterator2.hasNext()) {
                long l4 = (Long)iterator2.next();
                b.debug("C_DestroyObject privateKeysNoCKA");
                this.p11.C_DestroyObject(l2, l4);
                ++n2;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
            return -1;
        }
        b.debug("FIN loadPrivateKeys: " + n2);
        return n2;
    }

    public void deleteAllObjects(long l2) {
        b.debug("INICIO deleteAllObjects");
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            long[] lArray = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                b.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
            cK_ATTRIBUTE.pValue = 3L;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            lArray = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                b.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
            cK_ATTRIBUTE.pValue = 2L;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            lArray = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                b.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
            cK_ATTRIBUTE.pValue = 0L;
            cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            lArray = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            for (long l3 : lArray) {
                b.debug("C_DestroyObject");
                this.p11.C_DestroyObject(l2, l3);
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
        }
        b.debug("FIN deleteAllObjects");
    }

    public X509Certificate[] getCertificates(long l2) {
        b.debug("INICIO getCertificates");
        this.d = new ArrayList();
        this.hObjects = new ArrayList();
        this.lectores = new ArrayList();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            b.debug("C_FindObjects");
            long[] exception = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] lArray = exception;
            int n2 = exception.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = lArray[i2];
                Object object = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                ((CK_ATTRIBUTE)object).type = 0L;
                ((CK_ATTRIBUTE)object).pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue == null) continue;
                cK_ATTRIBUTEArray[0] = object;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                b.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                b.debug("C_FindObjects");
                long[] lArray2 = this.p11.C_FindObjects(l2, 1000L);
                object = lArray2;
                if (lArray2.length > 0) {
                    this.d.add(this.a(l2, l3));
                    this.hObjects.add(l3);
                }
                b.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
            }
        }
        catch (CertificateException | PKCS11Exception exception) {
            b.error("Exception:", (Throwable)exception);
            return null;
        }
        X509Certificate[] x509CertificateArray = this.a();
        b.debug("FIN getCertificates");
        return x509CertificateArray;
    }

    public X509Certificate[] getCertificatesLogout(long l2) {
        b.debug("INICIO getCertificatesLogout");
        this.d = new ArrayList();
        this.hObjects = new ArrayList();
        this.lectores = new ArrayList();
        CK_ATTRIBUTE[] objectArray = new CK_ATTRIBUTE[1];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        objectArray[0] = cK_ATTRIBUTE;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, objectArray);
            b.debug("C_FindObjects");
            long[] exception = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            long[] lArray = exception;
            int n2 = exception.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                long l3 = lArray[i2];
                Object object = new CK_ATTRIBUTE();
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
                ((CK_ATTRIBUTE)object).type = 0L;
                ((CK_ATTRIBUTE)object).pValue = 2L;
                cK_ATTRIBUTE.type = 258L;
                cK_ATTRIBUTE.pValue = this.getID(l2, l3);
                if (cK_ATTRIBUTE.pValue == null) continue;
                cK_ATTRIBUTEArray[0] = object;
                cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE;
                b.debug("C_FindObjectsInit");
                this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
                b.debug("C_FindObjects");
                long[] lArray2 = this.p11.C_FindObjects(l2, 1000L);
                object = lArray2;
                if (lArray2.length > 0) {
                    this.d.add(this.a(l2, l3));
                    this.hObjects.add(l3);
                }
                b.debug("C_FindObjectsFinal");
                this.p11.C_FindObjectsFinal(l2);
            }
        }
        catch (CertificateException | PKCS11Exception exception) {
            b.error("Exception:", (Throwable)exception);
            return null;
        }
        X509Certificate[] x509CertificateArray = this.a();
        b.debug("FIN getCertificatesLogout");
        return x509CertificateArray;
    }

    public boolean isNewCertificate(long l2, byte[] objectArray) {
        b.debug("INICIO isNewCertificate");
        boolean bl = true;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        cK_ATTRIBUTE.type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        cK_ATTRIBUTE2.type = 258L;
        cK_ATTRIBUTE2.pValue = objectArray;
        cK_ATTRIBUTEArray[1] = cK_ATTRIBUTE2;
        try {
            b.debug("C_FindObjectsInit");
            this.p11.C_FindObjectsInit(l2, cK_ATTRIBUTEArray);
            b.debug("C_FindObjects");
            objectArray = this.p11.C_FindObjects(l2, 1000L);
            b.debug("C_FindObjectsFinal");
            this.p11.C_FindObjectsFinal(l2);
            if (objectArray.length > 0) {
                bl = false;
            }
        }
        catch (PKCS11Exception pKCS11Exception) {
            b.error("Exception:", (Throwable)pKCS11Exception);
        }
        b.debug("FIN isNewCertificate");
        return bl;
    }

    public long makeCertificate(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        b.debug("INICIO makeCertificate");
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 1L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 128L;
        cK_ATTRIBUTE2.pValue = 0L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[9];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)cK_ATTRIBUTE3;
        objectArray[3] = (byte)cK_ATTRIBUTE2;
        objectArray[4] = (byte)new CK_ATTRIBUTE(257L, byArray2);
        objectArray[5] = (byte)object;
        objectArray[6] = (byte)new CK_ATTRIBUTE(129L, byArray3);
        objectArray[7] = (byte)new CK_ATTRIBUTE(130L, byArray4);
        objectArray[8] = (byte)new CK_ATTRIBUTE(17L, byArray);
        try {
            b.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                b.debug("FIN makeCertificate");
                return l3;
            }
        }
        catch (Exception exception) {
            b.error("Exception:", (Throwable)exception);
            b.debug("FIN makeCertificate");
            return -1L;
        }
        b.debug("FIN makeCertificate");
        return 0L;
    }

    public long makePublicKey(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        b.debug("INICIO makePublicKey");
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 2L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 256L;
        cK_ATTRIBUTE2.pValue = 0L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[8];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)cK_ATTRIBUTE3;
        objectArray[3] = (byte)cK_ATTRIBUTE2;
        objectArray[4] = (byte)object;
        objectArray[5] = (byte)new CK_ATTRIBUTE(257L, byArray);
        if (byArray2.length % 64 != 0) {
            byArray2 = Arrays.copyOfRange(byArray2, 1, byArray2.length);
        }
        objectArray[6] = (byte)new CK_ATTRIBUTE(288L, byArray2);
        objectArray[7] = (byte)new CK_ATTRIBUTE(290L, byArray3);
        try {
            b.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                b.debug("FIN makePublicKey");
                return l3;
            }
        }
        catch (Exception exception) {
            b.error("Exception:", (Throwable)exception);
            b.debug("FIN makePublicKey");
            return -1L;
        }
        b.debug("FIN makePublicKey");
        return 0L;
    }

    public long makePrivateKey(long l2, String object, byte[] objectArray, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, byte[] byArray7, byte[] byArray8, byte[] byArray9) {
        b.debug("INICIO makePrivateKey");
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 0L;
        cK_ATTRIBUTE.pValue = 3L;
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 256L;
        cK_ATTRIBUTE2.pValue = 0L;
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 3L;
        cK_ATTRIBUTE3.pValue = object;
        object = new CK_ATTRIBUTE();
        new CK_ATTRIBUTE().type = 258L;
        ((CK_ATTRIBUTE)object).pValue = objectArray;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[16];
        objectArray = cK_ATTRIBUTEArray;
        cK_ATTRIBUTEArray[0] = cK_ATTRIBUTE;
        objectArray[1] = (byte)new CK_ATTRIBUTE(1L, true);
        objectArray[2] = (byte)new CK_ATTRIBUTE(2L, true);
        objectArray[3] = (byte)cK_ATTRIBUTE3;
        objectArray[4] = (byte)cK_ATTRIBUTE2;
        objectArray[5] = (byte)object;
        objectArray[6] = (byte)new CK_ATTRIBUTE(257L, byArray);
        objectArray[7] = (byte)new CK_ATTRIBUTE(259L, true);
        if (byArray2.length % 64 != 0) {
            byArray2 = Arrays.copyOfRange(byArray2, 1, byArray2.length);
        }
        objectArray[8] = (byte)new CK_ATTRIBUTE(288L, byArray2);
        objectArray[9] = (byte)new CK_ATTRIBUTE(290L, byArray3);
        if (byArray4.length % 64 != 0) {
            byArray4 = Arrays.copyOfRange(byArray4, 1, byArray4.length);
        }
        objectArray[10] = (byte)new CK_ATTRIBUTE(291L, byArray4);
        if (byArray5.length % 64 != 0) {
            byArray5 = Arrays.copyOfRange(byArray5, 1, byArray5.length);
        }
        objectArray[11] = (byte)new CK_ATTRIBUTE(292L, byArray5);
        if (byArray6.length % 64 != 0) {
            byArray6 = Arrays.copyOfRange(byArray6, 1, byArray6.length);
        }
        objectArray[12] = (byte)new CK_ATTRIBUTE(293L, byArray6);
        if (byArray7.length % 64 != 0) {
            byArray7 = Arrays.copyOfRange(byArray7, 1, byArray7.length);
        }
        objectArray[13] = (byte)new CK_ATTRIBUTE(294L, byArray7);
        if (byArray8.length % 64 != 0) {
            byArray8 = Arrays.copyOfRange(byArray8, 1, byArray8.length);
        }
        objectArray[14] = (byte)new CK_ATTRIBUTE(295L, byArray8);
        if (byArray9.length % 64 != 0) {
            byArray9 = Arrays.copyOfRange(byArray9, 1, byArray9.length);
        }
        objectArray[15] = (byte)new CK_ATTRIBUTE(296L, byArray9);
        try {
            b.debug("C_CreateObject");
            long l3 = this.p11.C_CreateObject(l2, (CK_ATTRIBUTE[])objectArray);
            if (0L != l3) {
                b.debug("FIN makePrivateKey");
                return l3;
            }
        }
        catch (Exception exception) {
            b.error("Exception:", (Throwable)exception);
            b.debug("FIN makePrivateKey");
            return -1L;
        }
        b.debug("FIN makePrivateKey");
        return 0L;
    }

    static {
        info = null;
    }
}

